<?php
session_start();
require_once 'config.php';

// Tampilkan error untuk debug
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Ambil data setting sekolah
$settingQuery = $conn->query("SELECT * FROM setting LIMIT 1");
$setting = $settingQuery ? $settingQuery->fetch_assoc() : [];
$nama_sekolah = $setting['nama_sekolah'] ?? 'Nama Sekolah';
$logo_sekolah = $setting['logo_sekolah'] ?? 'default-logo.png';

$error = null;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, username, password, nama_lengkap, role FROM users WHERE username = ?");
    if ($stmt) {
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();

        // Jika user ditemukan
        if ($stmt->num_rows === 1) {
            $stmt->bind_result($id, $db_username, $db_password, $nama_lengkap, $role);
            $stmt->fetch();

            if ($password === $db_password) {
                // Set session
                $_SESSION['user_id'] = $id;
                $_SESSION['username'] = $db_username;
                $_SESSION['nama_lengkap'] = $nama_lengkap;
                $_SESSION['role'] = $role;

                // Redirect sesuai role
                switch ($role) {
                    case 'admin':
                        header("Location: admin.php");
                        exit;
                    case 'pengawas':
                        header("Location: pengawas.php");
                        exit;
                    case 'siswa':
                        header("Location: siswa.php");
                        exit;
                    default:
                        $error = "Peran tidak dikenali.";
                }
            } else {
                $error = "Username atau password salah!";
            }
        } else {
            $error = "Username atau password salah!";
        }

        $stmt->close();
    } else {
        $error = "Terjadi kesalahan saat menyiapkan pernyataan SQL.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login - <?= htmlspecialchars($nama_sekolah) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .login-box {
            max-width: 400px;
            margin: 5% auto;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.15);
            background: #fff;
        }
        .logo-img {
            width: 80px;
            height: 80px;
            object-fit: contain;
        }
    </style>
</head>
<body class="bg-light">

<div class="login-box text-center">
    <img src="uploads/<?= htmlspecialchars($logo_sekolah) ?>" alt="Logo Sekolah" class="logo-img mb-3">
    <h4 class="mb-4"><?= htmlspecialchars($nama_sekolah) ?></h4>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" action="index.php">
        <div class="mb-3 text-start">
            <label class="form-label">Username</label>
            <input type="text" name="username" class="form-control" required autofocus>
        </div>

        <div class="mb-3 text-start">
            <label class="form-label">Password</label>
            <input type="password" name="password" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-primary w-100">Login</button>
    </form>
</div>

</body>
</html>
