<?php
session_start();
include 'config.php';

// Ambil data setting
$setting = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM setting LIMIT 1"));

// Proses form jika dikirim
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
    $password = mysqli_real_escape_string($conn, $_POST['password']);

    if (empty($password)) {
        $emptyError = true;
    } else {
        $query = mysqli_query($conn, "SELECT * FROM ujian WHERE password = '$password'");

        if (mysqli_num_rows($query) > 0) {
            $_SESSION['ujian'] = true;
            header("Location: ujian/");
            exit();
        } else {
            $wrongPassword = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Ujian</title>
    <style>
        /* [style tetap sama dengan versi Anda] */
        body {
            font-family: Arial, sans-serif;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background: url('bg.jpg') no-repeat center center/cover;
        }
        .container {
            background: rgba(255, 255, 255, 0.2);
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            backdrop-filter: blur(10px);
        }
        .logo {
            width: 100px;
            margin-bottom: 15px;
        }
        input {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .password-container {
            position: relative;
            width: 94%;
        }
        .toggle-password {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
        }
        button {
            width: 100%;
            padding: 10px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .alert {
            padding: 10px;
            margin-top: 10px;
            color: white;
            border-radius: 5px;
            opacity: 1;
        }
        .alert.error {
            background: #dc3545;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            color: white;
        }
        .footer img {
            width: 50px;
            vertical-align: middle;
        }
        .speed-test {
            margin-top: 20px;
            font-weight: bold;
            color: white;
            background: rgba(0, 0, 0, 0.5);
            padding: 10px;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <img src="admin/uploads/<?= $setting['logo_sekolah'] ?>" alt="Logo" class="logo">
        <h2><?= htmlspecialchars($setting['nama_sekolah']) ?></h2>
        <h4>Masukkan Password Ujian</h4>

        <form method="POST" onsubmit="return validateForm()">
            <div class="password-container">
                <input type="password" name="password" id="password" placeholder="Masukkan Password">
                <span class="toggle-password" onclick="togglePassword('password')">👁️</span>
            </div>
            <button type="submit" name="submit">Masuk</button>
        </form>

        <?php if (!empty($wrongPassword)): ?>
            <div class="alert error">Password salah!</div>
        <?php elseif (!empty($emptyError)): ?>
            <div class="alert error">Password tidak boleh kosong!</div>
        <?php endif; ?>

        <div id="speed-test" class="speed-test">Menguji kecepatan internet...</div>

        <div class="footer">
            <p>&copy; 2025 All Rights Reserved.</p>
            <img src="logodigipas.png" alt="Logo">
        </div>
    </div>

    <script>
        function togglePassword(id) {
            var input = document.getElementById(id);
            input.type = input.type === "password" ? "text" : "password";
        }

        function validateForm() {
            var password = document.getElementById('password').value;
            return password.trim() !== "";
        }

        function testInternetSpeed() {
            var startTime = new Date().getTime();
            var image = new Image();
            image.src = "https://www.google.com/images/branding/googlelogo/2x/googlelogo_color_92x30dp.png?t=" + startTime;
            image.onload = function() {
                var endTime = new Date().getTime();
                var speed = ((1000 / (endTime - startTime)) * 1).toFixed(2);
                document.getElementById("speed-test").innerText = "Kecepatan Internet: " + speed + " Mbps";
            };
            image.onerror = function() {
                document.getElementById("speed-test").innerText = "Gagal mengukur kecepatan internet.";
            };
        }

        window.onload = testInternetSpeed;
    </script>
</body>
</html>
