<div class="container">
  <section class="content-header">
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">Selamat Datang</li>
    </ol>
  </section>

  <section class="content">
    <div class="row justify-content-center">
      <div class="login-box">
        <div class="login-box-body">
          <center>
            <img src="logosmk.png" width="35%" alt="LOGO " class="logo">
            <div class="login-logo">
              <b>CBT PASTI</b>
            </div>
          </center>

          <p class="login-box-msg">Masukkan Username dan Password</p>
          <div id="form-pesan"></div>

          <?php echo form_open('welcome/login','id="form-login" class="form-horizontal"'); ?>

          <div class="form-group has-feedback">
            <input type="text" id="username" name="username" class="form-control" placeholder="Username" autocomplete="off" required />
            <span class="glyphicon glyphicon-user form-control-feedback"></span>
          </div>

          <div class="form-group has-feedback">
            <input type="password" id="password" name="password" class="form-control" placeholder="Password" autocomplete="off" required />
            <span class="glyphicon glyphicon-lock form-control-feedback"></span>
          </div>

          <div class="form-group d-flex align-items-center justify-content-between">
            <label class="switch">
              <input type="checkbox" id="show-password">
              <span class="slider round"></span>
            </label>
            <span>Tampilkan Password</span>
          </div>

          <div class="form-group">
            <button type="submit" class="btn btn-primary btn-block btn-flat">Login</button>
          </div>

          <?php echo form_close(); ?>

          <div class="footer">
            <img src="logodigipas.png" width="50px" alt="Logo Digipas" class="footer-logo">
            <span class="copyright">Aplikasi by digitalpasundan.id © <?= date('Y'); ?></span>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<style>
  .body {
    background: url('image/background.jpg') no-repeat center center fixed;
    background-size: cover;
    font-family: 'Arial', sans-serif;
  }

  .login-box {
    width: 380px;
    margin: auto;
    padding-top: 40px;
  }

  .login-box-body {
    background: rgba(255, 255, 255, 0.2); /* Transparan */
    backdrop-filter: blur(12px); /* Efek buram */
    -webkit-backdrop-filter: blur(12px); /* Support Safari */
    padding: 25px 20px;
    border-radius: 16px;
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
  }

  .login-logo {
    font-size: 24px;
    font-weight: bold;
    color: #333;
    margin-top: 12px;
    margin-bottom: 18px;
  }

  .logo {
    margin-bottom: 12px;
  }

  .login-box-msg {
    font-size: 15px;
    margin-bottom: 20px;
    font-weight: 500;
    color: #222;
  }

  .form-group {
    margin-bottom: 16px;
  }

  .btn-primary {
  background-color: #000; /* Warna hitam */
  color: #fff; /* Warna teks putih */
  border: none;
  padding: 10px 20px;
  border-radius: 8px;
  transition: background-color 0.3s ease, transform 0.2s ease;
}

.btn-primary:hover {
  background-color: #28a745; /* Warna hijau */
  transform: translateY(-3px);
}

.btn-primary:active {
  background-color: #1e7e34; /* Warna hijau lebih gelap saat ditekan */
  transform: translateY(0);
}

  #form-pesan {
    margin-top: 12px;
    color: red;
    font-weight: bold;
    text-align: center;
  }

  .switch {
    position: relative;
    display: inline-block;
    width: 46px;
    height: 24px;
  }

  .switch input {
    display: none;
  }

  .slider {
    position: absolute;
    cursor: pointer;
    top: 0; left: 0; right: 0; bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 24px;
  }

  .slider:before {
    content: "";
    position: absolute;
    height: 20px;
    width: 20px;
    left: 2px;
    bottom: 2px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
  }

  input:checked + .slider {
    background-color: #28a745;
  }

  input:checked + .slider:before {
    transform: translateX(22px);
  }

  .footer {
    display: flex;
    align-items: center;
    justify-content: center;
    margin-top: 22px;
    padding-top: 12px;
    border-top: 1px solid rgba(255, 255, 255, 0.3);
  }

  .footer-logo {
    margin-right: 10px;
  }

  .copyright {
    font-size: 12px;
    color: #000000;
  }
</style>

<script>
  $(document).ready(function() {
    $('#username').focus();

    $('#show-password').change(function() {
      $('#password').attr('type', this.checked ? 'text' : 'password');
    });

    $('#form-login').submit(function(e) {
      e.preventDefault();
      $("#modal-proses").modal('show');

      $.ajax({
        url: "<?php echo site_url(); ?>/welcome/login",
        type: "POST",
        data: $(this).serialize(),
        cache: false,
        success: function(response) {
          const res = JSON.parse(response);
          if (res.status == 1) {
            window.location.href = "<?php echo site_url(); ?>/tes_dashboard";
          } else {
            $('#form-pesan').html(res.error);
            $("#modal-proses").modal('hide');
            $('#username').focus();
          }
        },
        error: function() {
          $('#form-pesan').html('Terjadi kesalahan. Silakan coba lagi.');
          $("#modal-proses").modal('hide');
        }
      });
    });
  });
</script>
