<?php
session_start();
include 'config.php';

// Ambil password ujian saat ini
$query = mysqli_query($conn, "SELECT password FROM ujian LIMIT 1");
$data = mysqli_fetch_assoc($query);

// Ambil nama sekolah dari tabel setting
$setting_query = mysqli_query($conn, "SELECT nama_sekolah FROM setting LIMIT 1");
$setting_data = mysqli_fetch_assoc($setting_query);
$nama_sekolah = $setting_data['nama_sekolah'] ?? 'Sekolah Anda'; // fallback

// Fungsi membersihkan nomor WA (hanya angka)
function bersihkanNoWA($nomor) {
    return preg_replace('/\D/', '', $nomor);
}

// Fungsi kirim WA via Wablas
function kirimWA($no_wa, $pesan, $token, $secret_key) {
    $url = "https://jogja.wablas.com/api/send-message?token=$token.$secret_key&phone=$no_wa&message=" . urlencode($pesan);
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_exec($curl);
    curl_close($curl);
}

// Proses ubah password ujian
if (isset($_POST['ubah_password'])) {
    $new_password = $_POST['new_password'];
    $escaped_password = mysqli_real_escape_string($conn, $new_password);

    // Update ke database
    mysqli_query($conn, "UPDATE ujian SET password = '$escaped_password'");

    // Token dan secret key untuk API Wablas
    $token = 'kd7fGszkIXJcGrI2mEnBwWMMpDynRejzrGGFYxBV1XFSh9KhquUibGz';
    $secret_key = 'sVtZqxZE';

    // Ambil semua user yang perlu diberi info password baru
    $res = mysqli_query($conn, "SELECT nama_lengkap, no_wa, role FROM users 
        WHERE role IN ('pengawas', 'pengurus') AND no_wa IS NOT NULL AND no_wa != ''");

    while ($row = mysqli_fetch_assoc($res)) {
        $nama = $row['nama_lengkap'];
        $no_wa = bersihkanNoWA($row['no_wa']);
        $role = ucfirst($row['role']);

       if (!empty($no_wa)) {
  $pesan_wa = "📢 *ADMIN $nama_sekolah*\n\n"
          . "👋 *HALO $nama*,\n"
          . "Password ujian Anda telah *DIPERBARUI* dengan token baru.\n\n"
          . "🔑 Token Baru:\n"
          . "   *$new_password*\n\n"
          . "📌 *Catatan Penting:*\n"
          . "1. Jangan ditulis di papan tulis.\n"
          . "2. Token hanya diberikan kepada siswa yang benar-benar meminta.\n"
          . "3. Jangan lupa catat di berita acara.\n\n"
          . "🙏 Terima kasih atas kerja keras Bapak/Ibu pengawas di $nama_sekolah.\n\n"
          . "Salam hormat,\n"
          . "*Tim IT $nama_sekolah*";
    kirimWA($no_wa, $pesan_wa, $token, $secret_key);
}
    }

    // Redirect dengan informasi sukses
    header("Location: admin.php?success=1&new=" . urlencode($new_password));
    exit();
}

// Logout
if (isset($_POST['logout'])) {
    session_destroy();
    header("Location: loginadmin.php");
    exit();
}

// Jika berhasil update password
$success = isset($_GET['success']) && $_GET['success'] == 1;
$newPassword = $_GET['new'] ?? '';
?>


<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Ubah Password Ujian - Admin CBT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="sb-admin-2/vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="sb-admin-2/css/sb-admin-2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body id="page-top">
<div id="wrapper">
    <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">
        <a class="sidebar-brand d-flex align-items-center justify-content-center" href="token.php">
            <div class="sidebar-brand-icon">
                <img src="sb-admin-2/img/logo.png" alt="Logo Sekolah" style="width: 40px;">
            </div>
            <div class="sidebar-brand-text mx-3">Admin CBT</div>
        </a>

        <hr class="sidebar-divider">
        <li class="nav-item active">
            <a class="nav-link" href="admin.php"><i class="fas fa-fw fa-key"></i><span>Ubah Password Ujian</span></a>
        </li>
        <li class="nav-item"><a class="nav-link" href="setting.php"><i class="fas fa-fw fa-cogs"></i><span>Setting WA API</span></a></li>
        <li class="nav-item"><a class="nav-link" href="daftarpengawas.php"><i class="fas fa-fw fa-users"></i><span>Daftar Pengawas</span></a></li>
        <hr class="sidebar-divider d-none d-md-block">
        <form method="POST" class="m-3">
            <button type="submit" name="logout" class="btn btn-danger w-100">Logout</button>
        </form>
    </ul>

    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 shadow">
                <span class="text-primary fw-bold">Dashboard Admin CBT</span>
            </nav>

            <div class="container-fluid">
                <div class="card mx-auto shadow-lg p-4 rounded-4" style="max-width: 500px;">
                    <h4 class="mb-4 text-center">🔐 Ubah Password Ujian</h4>
                  <p class="text-center" style="font-size: 2rem; font-weight: bold; color: black;">
  Password Saat Ini: <br>
  <strong><?= htmlspecialchars($data['password']) ?></strong>
</p>


                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label">Password Baru</label>
                            <input type="password" name="new_password" class="form-control" placeholder="Masukkan password baru..." required>
                        </div>
                        <button type="submit" name="ubah_password" class="btn btn-success w-100">Ubah Password Manual</button>
                    </form>

                    <!-- Mode -->
                    <div class="text-center mt-4">
                        <label class="form-label mb-2"><strong>Mode Ubah Password</strong></label>
                        <div class="btn-group" role="group">
                            <input type="radio" class="btn-check" name="mode" id="manual" autocomplete="off" checked>
                            <label class="btn btn-outline-primary" for="manual">Manual</label>

                            <input type="radio" class="btn-check" name="mode" id="otomatis" autocomplete="off">
                            <label class="btn btn-outline-success" for="otomatis">Otomatis</label>
                        </div>
                    </div>

                    <!-- Countdown -->
                    <div id="countdown" class="text-center mt-3" style="display: none;">
                        <h5>⏳ Password akan diubah otomatis dalam:</h5>
                        <h3 id="timer">05:00</h3>
                    </div>

                    <!-- Password terbaru otomatis -->
                    <div id="password-terbaru" class="mt-3 text-center" style="font-size: 1.2rem; display: none;">
                        🔐 Password terbaru: <strong id="password-text"></strong>
                    </div>

                    <div class="text-center mt-4">
                        <a href="https://ujian.smkpasja.sch.id" target="_blank" class="btn btn-outline-primary">🔗 Cek Login Ujian</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($success): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Password Diperbarui!',
        html: 'Password baru: <strong><?= htmlspecialchars($newPassword) ?></strong>',
        showConfirmButton: true,
    });
</script>
<?php endif; ?>

<script src="sb-admin-2/vendor/jquery/jquery.min.js"></script>
<script src="sb-admin-2/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="sb-admin-2/js/sb-admin-2.min.js"></script>

<script>
    const manualBtn = document.getElementById('manual');            // Ambil elemen tombol mode manual
const otomatisBtn = document.getElementById('otomatis');        // Ambil elemen tombol mode otomatis
const countdownDiv = document.getElementById('countdown');      // Ambil elemen div hitung mundur
const timerDisplay = document.getElementById('timer');          // Ambil elemen untuk menampilkan waktu timer
const passwordDiv = document.getElementById('password-terbaru'); // Ambil elemen div untuk password terbaru
const passwordText = document.getElementById('password-text');  // Ambil elemen teks password terbaru

let countdownInterval;  // Variabel untuk menyimpan interval countdown
let timeLeft = 120;      // Waktu hitung mundur mulai dari 10 detik

function startCountdown() {
    clearInterval(countdownInterval);  // Hentikan interval jika sebelumnya sudah berjalan
    timeLeft = 120;                     // Reset waktu hitung mundur ke 10 detik
    updateTimerDisplay();              // Update tampilan timer dengan waktu sekarang

    countdownInterval = setInterval(() => {  // Mulai interval yang berjalan tiap 1 detik (1000 ms)
        timeLeft--;                         // Kurangi waktu tersisa tiap detik
        updateTimerDisplay();               // Update tampilan timer
        if (timeLeft <= 0) {                // Jika waktu habis
            timeLeft = 120;                  // Reset waktu ke 10 detik
            updateTimerDisplay();           // Update tampilan timer setelah reset
            ubahPasswordOtomatis();         // Panggil fungsi untuk mengganti password otomatis
        }
    }, 1000);
}

function updateTimerDisplay() {
    const m = String(Math.floor(timeLeft / 60)).padStart(2, '0');  // Hitung menit dan format 2 digit
    const s = String(timeLeft % 60).padStart(2, '0');              // Hitung detik dan format 2 digit
    timerDisplay.textContent = `${m}:${s}`;                        // Tampilkan waktu dalam format MM:SS
}

function ubahPasswordOtomatis() {
    fetch('autopassword.php')                // Request ke server untuk mendapatkan password baru
        .then(r => r.text())                 // Ubah response jadi teks
        .then(pw => {
            console.log("Password otomatis diubah:", pw);  // Log password baru di console
            passwordText.textContent = pw;                  // Tampilkan password baru di halaman
            passwordDiv.style.display = 'block';            // Tampilkan div password terbaru

            Swal.fire({                  // Tampilkan notifikasi sukses menggunakan SweetAlert
                icon: 'success',
                title: 'Password Otomatis Diperbarui!',
                html: 'Password terbaru: <strong>' + pw + '</strong>',
                timer: 4000,            // Notifikasi hilang otomatis setelah 4 detik
                showConfirmButton: false,
                timerProgressBar: true
            });
        });
}

// Ketika tombol manual dipilih
manualBtn.addEventListener('change', () => {
    countdownDiv.style.display = 'none';   // Sembunyikan hitung mundur
    clearInterval(countdownInterval);      // Hentikan hitung mundur
    passwordDiv.style.display = 'none';    // Sembunyikan password terbaru
});

// Ketika tombol otomatis dipilih
otomatisBtn.addEventListener('change', () => {
    countdownDiv.style.display = 'block';  // Tampilkan hitung mundur
    startCountdown();                      // Mulai hitung mundur dan otomatis ganti password
});

</script>
</body>
</html>
