<?php
session_start();
include 'config.php';
// Proses Tambah User
if (isset($_POST['simpan_user'])) {
    $nama_lengkap = $_POST['nama_lengkap'];
    $no_wa = $_POST['no_wa'];
    $username = $_POST['username'];
    $password = $_POST['password'];
    $role = $_POST['role'];

    $filename = '';
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] === 0) {
        $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $filename = uniqid() . '.' . $ext;
        $target = 'uploads/users/' . $filename;
        move_uploaded_file($_FILES['foto']['tmp_name'], $target);
    }

    $query = mysqli_query($conn, "INSERT INTO users (username, password, nama_lengkap, no_wa, role, foto)
                                  VALUES ('$username', '$password', '$nama_lengkap', '$no_wa', '$role', '$filename')");

    header("Location: daftarpengawas.php");
    exit();
}

// Proses Update User (Edit)
if (isset($_POST['edit_user'])) {
    $id = $_POST['id'];
    $nama_lengkap = $_POST['nama_lengkap'];
    $no_wa = $_POST['no_wa'];
    $role = $_POST['role'];

    if (isset($_FILES['foto']) && $_FILES['foto']['error'] === 0) {
        $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $filename = uniqid() . '.' . $ext;
        $target = 'uploads/users/' . $filename;
        move_uploaded_file($_FILES['foto']['tmp_name'], $target);

        $query = mysqli_query($conn, "UPDATE users SET nama_lengkap='$nama_lengkap', no_wa='$no_wa', role='$role', foto='$filename' WHERE id=$id");
    } else {
        $query = mysqli_query($conn, "UPDATE users SET nama_lengkap='$nama_lengkap', no_wa='$no_wa', role='$role' WHERE id=$id");
    }

    header("Location: daftarpengawas.php");
    exit();
}

// Proses Hapus User
if (isset($_POST['hapus_user'])) {
    $id = $_POST['id'];
    $res = mysqli_query($conn, "SELECT foto FROM users WHERE id=$id");
    $data = mysqli_fetch_assoc($res);
    if ($data['foto'] && file_exists('uploads/users/' . $data['foto'])) {
        unlink('uploads/users/' . $data['foto']);
    }
    mysqli_query($conn, "DELETE FROM users WHERE id=$id");
    header("Location: daftarpengawas.php");
    exit();
}

// Ambil data user
$query = mysqli_query($conn, "SELECT * FROM users ORDER BY id DESC");
$users = mysqli_fetch_all($query, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Ubah Password Ujian - Admin CBT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- SB Admin 2 CSS -->
    <link href="sb-admin-2/vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="sb-admin-2/css/sb-admin-2.min.css" rel="stylesheet">

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
    .foto-adri {
        width: 50px;
        height: 50px;
        object-fit: cover;
        border-radius: 50%;
        border: 2px solid #ddd;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s ease;
    }

    .foto-adri:hover {
        transform: scale(1.05);
    }

    .img-thumbnail.rounded {
        object-fit: cover;
        width: 100px;
        height: 100px;
        border-radius: 8px;
    }
</style>
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">
            <!-- Logo Sekolah -->
            <a class="sidebar-brand d-flex align-items-center justify-content-center" href="token.php">
                <div class="sidebar-brand-icon">
                    <img src="sb-admin-2/img/logo.png" alt="Logo Sekolah" style="width: 40px;">
                </div>
                <div class="sidebar-brand-text mx-3">Admin CBT</div>
            </a>

            <hr class="sidebar-divider">

            <!-- Menu Ubah Password -->
            <li class="nav-item active">
                <a class="nav-link" href="admin.php">
                    <i class="fas fa-fw fa-key"></i>
                    <span>Ubah Password Ujian</span>
                </a>
            </li>

            <!-- Menu Setting WA API -->
            <li class="nav-item">
                <a class="nav-link" href="setting.php">
                    <i class="fas fa-fw fa-cogs"></i>
                    <span>Setting WA API</span>
                </a>
            </li>

            <!-- Menu Daftar Pengawas -->
            <li class="nav-item">
                <a class="nav-link" href="daftarpengawas.php">
                    <i class="fas fa-fw fa-users"></i>
                    <span>Daftar Pengawas</span>
                </a>
            </li>

            <hr class="sidebar-divider d-none d-md-block">

            <!-- Logout Button -->
            <form method="POST" class="m-3">
                <button type="submit" name="logout" class="btn btn-danger w-100">Logout</button>
            </form>
        </ul>
        <!-- End Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 shadow">
                    <span class="text-primary fw-bold">Dashboard Admin CBT</span>
                </nav>

                <!-- Page Content -->
                <div class="container-fluid">
        <h2 class="mb-4 text-center">Daftar Pengguna</h2>

        <!-- FILTERS -->
        <div class="row mb-3">
            <div class="col-md-6 mb-2">
                <input type="text" id="searchInput" class="form-control" placeholder="Cari Nama Lengkap atau No. WA...">
            </div>
            <div class="col-md-3 mb-2">
                <select id="roleFilter" class="form-select">
                    <option value="">Semua Role</option>
                    <option value="admin">Admin</option>
                    <option value="pengawas">Pengawas</option>
                    <option value="siswa">Siswa</option>
                </select>
            </div>
        </div>
<button type="button" class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#modalTambahUser">
    + Tambah User
</button>
        <div class="table-responsive">
            <table id="usersTable" class="table table-bordered table-striped align-middle text-center">
                <thead class="table-dark">
                    <tr>
                        <th>No</th>
                        <th>Foto</th>
                        <th>Nama Lengkap</th>
                        <th>No. WhatsApp</th>
                        <th>Role</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; ?>
                    <?php foreach ($users as $user) :
                        $foto = $user['foto'] ? 'uploads/users/' . $user['foto'] : 'default.jpg';
                    ?>
                        <tr data-role="<?= htmlspecialchars($user['role']) ?>">
                            <td><?= $no ?></td>
                            <td><img src="<?= $foto ?>" class=" foto-adri" alt="Foto"></td>
                            <td class="nama"><?= htmlspecialchars($user['nama_lengkap']) ?></td>
                            <td class="nowa"><a href="https://wa.me/<?= preg_replace('/\D/', '', $user['no_wa']) ?>" target="_blank"><?= htmlspecialchars($user['no_wa']) ?></a></td>
                            <td><span class="badge bg-primary badge-role"><?= $user['role'] ?></span></td>
                            <td>
                                <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editModal<?= $user['id'] ?>">Edit</button>
                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?= $user['id'] ?>">Hapus</button>
                            </td>
                        </tr>
                    <?php
                        $no++;
                    endforeach; ?>
                </tbody>
            </table>
        </div>

       <?php foreach ($users as $user) :
    $foto = $user['foto'] ? 'uploads/users/' . $user['foto'] : 'default.jpg';
?>
    <!-- Modal Edit -->
    <div class="modal fade" id="editModal<?= $user['id'] ?>" tabindex="-1" aria-labelledby="editModalLabel<?= $user['id'] ?>" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form method="POST" enctype="multipart/form-data" class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="editModalLabel<?= $user['id'] ?>">Edit Pengguna</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-start">
                    <input type="hidden" name="id" value="<?= $user['id'] ?>">
                    
                    <div class="mb-3">
                        <label class="form-label">Nama Lengkap</label>
                        <input type="text" name="nama_lengkap" class="form-control" required value="<?= htmlspecialchars($user['nama_lengkap']) ?>">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">No. WhatsApp</label>
                        <input type="text" name="no_wa" class="form-control" required value="<?= htmlspecialchars($user['no_wa']) ?>">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Role</label>
                        <select name="role" class="form-select" required>
                            <option value="admin" <?= $user['role'] == 'admin' ? 'selected' : '' ?>>Admin</option>
                            <option value="pengawas" <?= $user['role'] == 'pengawas' ? 'selected' : '' ?>>Pengawas</option>
                            <option value="siswa" <?= $user['role'] == 'siswa' ? 'selected' : '' ?>>Siswa</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Foto (kosongkan jika tidak ingin diubah)</label>
                        <input type="file" name="foto" class="form-control" accept="image/*">
                    </div>

                    <?php if ($user['foto']) : ?>
                        <div class="mb-3 text-center">
                            <img src="<?= $foto ?>" alt="Foto saat ini" class="img-thumbnail rounded" style="width: 100px; height: 100px;">
                            <div class="small text-muted mt-1">Foto saat ini</div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="edit_user" class="btn btn-success">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
<!-- Modal Tambah User -->
<div class="modal fade" id="modalTambahUser" tabindex="-1" aria-labelledby="modalTambahUserLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" enctype="multipart/form-data" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTambahUserLabel">Tambah User</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <div class="mb-2">
          <label>Nama Lengkap</label>
          <input type="text" name="nama_lengkap" class="form-control" required>
        </div>
        <div class="mb-2">
          <label>No. WA</label>
          <input type="text" name="no_wa" class="form-control" required>
        </div>
        <div class="mb-2">
          <label>Username</label>
          <input type="text" name="username" class="form-control" required>
        </div>
        <div class="mb-2">
          <label>Password</label>
          <input type="text" name="password" class="form-control" required>
        </div>
        <div class="mb-2">
          <label>Role</label>
          <select name="role" class="form-control" required>
            <option value="">-- Pilih Role --</option>
            <option value="admin">Admin</option>
            <option value="siswa">Siswa</option>
            <option value="pengawas">pengawas</option>
          </select>
        </div>
        <div class="mb-2">
          <label>Foto</label>
          <input type="file" name="foto" class="form-control">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <button type="submit" name="simpan_user" class="btn btn-primary">Simpan</button>
      </div>
    </form>
  </div>
</div>

    <!-- Modal Hapus -->
    <div class="modal fade" id="deleteModal<?= $user['id'] ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?= $user['id'] ?>" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form method="POST" class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="deleteModalLabel<?= $user['id'] ?>">Konfirmasi Hapus</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus user <strong><?= htmlspecialchars($user['nama_lengkap']) ?></strong>?</p>
                    <input type="hidden" name="id" value="<?= $user['id'] ?>">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="hapus_user" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
<?php endforeach; ?>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Filter realtime
        const searchInput = document.getElementById('searchInput');
        const roleFilter = document.getElementById('roleFilter');
        const table = document.getElementById('usersTable').getElementsByTagName('tbody')[0];

        function filterTable() {
            const searchText = searchInput.value.toLowerCase();
            const selectedRole = roleFilter.value.toLowerCase();

            for (let row of table.rows) {
                const nama = row.querySelector('.nama').textContent.toLowerCase();
                const noWA = row.querySelector('.nowa').textContent.toLowerCase();
                const role = row.getAttribute('data-role').toLowerCase();

                const matchesSearch = nama.includes(searchText) || noWA.includes(searchText);
                const matchesRole = selectedRole === "" || role === selectedRole;

                if (matchesSearch && matchesRole) {
                    row.style.display = "";
                } else {
                    row.style.display = "none";
                }
            }
        }

        searchInput.addEventListener('input', filterTable);
        roleFilter.addEventListener('change', filterTable);
    </script>
</body>

</html>