<?php
session_start();
include 'config.php';

// Ambil data setting
$query = mysqli_query($conn, "SELECT * FROM setting WHERE id = 1");
$setting = mysqli_fetch_assoc($query);

// Handle submit form
if (isset($_POST['simpan'])) {
    $nama_sekolah = mysqli_real_escape_string($conn, $_POST['nama_sekolah']);
    $wa_api_key = mysqli_real_escape_string($conn, $_POST['wa_api_key']);
    $secret_api_key = mysqli_real_escape_string($conn, $_POST['secret_api_key']);
    $latitude = mysqli_real_escape_string($conn, $_POST['latitude']);
    $longitude = mysqli_real_escape_string($conn, $_POST['longitude']);
    $aktif_lokasi = isset($_POST['aktif_lokasi']) ? 1 : 0;
    $logo_sekolah = $setting['logo_sekolah'];

    // Upload logo jika ada file baru
    if (!empty($_FILES['logo']['name'])) {
        $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
        $filename = "logo_" . time() . "." . $ext;
        move_uploaded_file($_FILES['logo']['tmp_name'], "uploads/" . $filename);
        $logo_sekolah = $filename;
    }

    // Update ke database
    $sql = "UPDATE setting SET 
        nama_sekolah = '$nama_sekolah',
        logo_sekolah = '$logo_sekolah',
        wa_api_key = '$wa_api_key',
        secret_api_key = '$secret_api_key',
        latitude = '$latitude',
        longitude = '$longitude',
        aktif_lokasi = '$aktif_lokasi'
        WHERE id = 1";

    mysqli_query($conn, $sql);

    header("Location: setting.php?success=1");
    exit();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Setting Aplikasi - Admin CBT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- SB Admin 2 -->
    <link href="sb-admin-2/vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="sb-admin-2/css/sb-admin-2.min.css" rel="stylesheet">

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body id="page-top">

<div id="wrapper">
    <!-- Sidebar -->
    <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">
        <a class="sidebar-brand d-flex align-items-center justify-content-center" href="token.php">
            <div class="sidebar-brand-icon">
                <img src="sb-admin-2/img/logo.png" alt="Logo Sekolah" style="width: 40px;">
            </div>
            <div class="sidebar-brand-text mx-3">Admin CBT</div>
        </a>

        <hr class="sidebar-divider">

        <li class="nav-item">
            <a class="nav-link" href="admin.php">
                <i class="fas fa-key"></i>
                <span>Ubah Password Ujian</span>
            </a>
        </li>

        <li class="nav-item active">
            <a class="nav-link" href="setting.php">
                <i class="fas fa-cogs"></i>
                <span>Setting WA API</span>
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link" href="daftarpengawas.php">
                <i class="fas fa-users"></i>
                <span>Daftar Pengawas</span>
            </a>
        </li>

        <hr class="sidebar-divider d-none d-md-block">

        <form method="POST" class="m-3">
            <button type="submit" name="logout" class="btn btn-danger w-100">Logout</button>
        </form>
    </ul>
    <!-- End Sidebar -->

    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 shadow">
                <span class="text-primary fw-bold">Dashboard Admin CBT</span>
            </nav>

            <div class="container-fluid">
                <h1 class="h4 mb-4 text-gray-800">⚙️ Pengaturan Aplikasi</h1>

                <div class="card shadow p-4 mx-auto" style="max-width: 600px;">
                    <form method="POST" enctype="multipart/form-data">
                        <div class="mb-3">
                            <label class="form-label">Nama Sekolah</label>
                            <input type="text" name="nama_sekolah" class="form-control" value="<?= htmlspecialchars($setting['nama_sekolah']) ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Logo Sekolah (opsional)</label><br>
                            <img src="uploads/<?= $setting['logo_sekolah'] ?>" alt="Logo" height="70" class="mb-2"><br>
                            <input type="file" name="logo" class="form-control">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">WA API Key</label>
                            <input type="text" name="wa_api_key" class="form-control" value="<?= htmlspecialchars($setting['wa_api_key']) ?>">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Secret API Key</label>
                            <input type="text" name="secret_api_key" class="form-control" value="<?= htmlspecialchars($setting['secret_api_key']) ?>">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Latitude Lokasi Ujian</label>
                            <input type="text" name="latitude" class="form-control" value="<?= htmlspecialchars($setting['latitude']) ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Longitude Lokasi Ujian</label>
                            <input type="text" name="longitude" class="form-control" value="<?= htmlspecialchars($setting['longitude']) ?>" required>
                        </div>

                      <div class="form-check mb-3">
    <input type="checkbox" name="aktif_lokasi" class="form-check-input" id="lokasiAktif" <?= !empty($setting['aktif_lokasi']) ? 'checked' : '' ?>>
    <label class="form-check-label" for="lokasiAktif">Aktifkan Lokasi Saat Ujian</label>
</div>


                        <button type="submit" name="simpan" class="btn btn-primary w-100">💾 Simpan Pengaturan</button>
                    </form>
                </div>
            </div>

            <?php if (isset($_GET['success'])): ?>
                <script>
                    Swal.fire({
                        icon: 'success',
                        title: 'Tersimpan!',
                        text: 'Pengaturan berhasil diperbarui!',
                        timer: 2000,
                        showConfirmButton: false
                    });
                </script>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- JS -->
<script src="sb-admin-2/vendor/jquery/jquery.min.js"></script>
<script src="sb-admin-2/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="sb-admin-2/js/sb-admin-2.min.js"></script>
</body>
</html>
