<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title>Login CBT PASTI | Digital Pasundan</title>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Bootstrap 5 (CSS Only for Layout) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <style>
    :root {
        --primary-color: #4facfe;
        --secondary-color: #00f2fe;
        --glass-bg: rgba(255, 255, 255, 0.15);
        --glass-border: rgba(255, 255, 255, 0.2);
        --text-color: #000; /* Warna hitam */
    }

    body {
        font-family: 'Poppins', sans-serif;
        margin: 0;
        padding: 0;
        height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        background-image: url('https://images.unsplash.com/photo-1497294815431-9365093b7331?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80');
        background-size: cover;
        background-position: center;
        overflow: hidden;
    }

    body::before {
        content: '';
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background: linear-gradient(135deg, rgba(0,0,0,0.8) 0%, rgba(20,20,20,0.6) 100%);
        z-index: -1;
    }

    .login-card {
        width: 100%;
        max-width: 420px;
        padding: 40px 30px;
        background: var(--glass-bg);
        backdrop-filter: blur(15px);
        -webkit-backdrop-filter: blur(15px);
        border-radius: 20px;
        border: 1px solid var(--glass-border);
        box-shadow: 0 15px 35px rgba(0,0,0,0.2);
        text-align: center;
        animation: fadeInUp 0.8s ease-out;
        color: #000;
        position: relative;
    }

    .logo-container img {
        width: 80px;
        height: auto;
        margin-bottom: 10px;
        filter: drop-shadow(0 4px 6px rgba(0,0,0,0.3));
        transition: transform 0.3s;
    }

    .logo-container img:hover {
        transform: scale(1.05) rotate(5deg);
    }

    .app-title {
        font-size: 24px;
        font-weight: 700;
        margin-bottom: 5px;
        letter-spacing: 1px;
        color: #000;
    }

    .app-subtitle {
        font-size: 14px;
        opacity: 0.8;
        margin-bottom: 30px;
        color: #000;
    }

    .input-group-custom {
        position: relative;
        margin-bottom: 25px;
        text-align: left;
    }

    .input-group-custom input {
        width: 100%;
        padding: 15px 45px 15px 20px;
        background: rgba(255, 255, 255, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 12px;
        color: #000;
        font-size: 15px;
        outline: none;
        transition: all 0.3s;
    }

    .input-group-custom input::placeholder {
        color: rgba(0, 0, 0, 0.6);
    }

    .input-group-custom input:focus {
        background: rgba(255, 255, 255, 0.25);
        border-color: var(--secondary-color);
        box-shadow: 0 0 15px rgba(0, 242, 254, 0.3);
    }

    .input-group-custom i {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        color: rgba(0, 0, 0, 0.7);
        transition: 0.3s;
    }

    .toggle-password {
        cursor: pointer;
    }

    .toggle-password:hover {
        color: #000;
    }

    .btn-login {
        width: 100%;
        padding: 14px;
        background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
        border: none;
        border-radius: 12px;
        color: #000; /* Tombol teks hitam */
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: 0.3s;
        box-shadow: 0 5px 15px rgba(0, 242, 254, 0.4);
    }

    .btn-login:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(0, 242, 254, 0.6);
    }

    .btn-login:disabled {
        background: #ccc;
        cursor: not-allowed;
        transform: none;
    }

    .footer-info {
        margin-top: 30px;
        font-size: 12px;
        color: rgba(0, 0, 0, 0.6);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }

    .footer-logo {
        width: 30px;
        opacity: 0.8;
    }

    #caps-warning {
        display: none;
        color: #ffcc00;
        font-size: 12px;
        margin-top: -20px;
        margin-bottom: 15px;
        text-align: left;
        padding-left: 5px;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translate3d(0, 40px, 0);
        }
        to {
            opacity: 1;
            transform: translate3d(0, 0, 0);
        }
    }
</style>

</head>
<body>

    <div class="login-card">
        <div class="logo-container">
            <!-- Pastikan path logo benar -->
            <img src="logosmk.png" alt="Logo Sekolah" onerror="this.src='https://cdn-icons-png.flaticon.com/512/2991/2991148.png'"> 
        </div>
        <div class="app-title">CBT PASTI</div>
        <div class="app-subtitle">Computer Based Test System</div>

        <!-- Start Form -->
        <?php echo form_open('welcome/login', 'id="form-login"'); ?>
            
            <div class="input-group-custom">
                <!-- Tambahkan title untuk petunjuk -->
                <input type="text" id="username" name="username" placeholder="Username / NISN (Paste disini)" autocomplete="off" required title="Paste Username dan Password sekaligus disini">
                <i class="fas fa-user"></i>
            </div>

            <div class="input-group-custom">
                <input type="password" id="password" name="password" placeholder="Password" autocomplete="off" required>
                <i class="fas fa-eye toggle-password" id="togglePassword"></i>
            </div>
            
            <div id="caps-warning">
                <i class="fas fa-exclamation-triangle"></i> Caps Lock menyala!
            </div>

            <div class="form-group">
                <button type="submit" id="btn-submit" class="btn-login">
                    MASUK SEKARANG <i class="fas fa-arrow-right ms-2"></i>
                </button>
            </div>

        <?php echo form_close(); ?>
        <!-- End Form -->

        <div class="footer-info">
            <img src="logodigipas.png" alt="Digipas" class="footer-logo" onerror="this.style.display='none'">
            <span>&copy; <?= date('Y'); ?> Digital Pasundan</span>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        $(document).ready(function() {
            // Focus on username load
            $('#username').focus();

            // ============================================
            // FITUR BARU: AUTO SPLIT PASTE (Excel/Text)
            // ============================================
            $('#username').on('paste', function(e) {
                // Ambil data yang di-paste dari clipboard
                var clipboardData = e.originalEvent.clipboardData || window.clipboardData;
                var pastedData = clipboardData.getData('text');

                // Cek separator (Pemisah). 
                // Jika dari Excel biasanya pakai TAB (\t).
                // Jika manual text mungkin pakai spasi atau garis lurus (|).
                
                var separator = null;

                if (pastedData.indexOf('\t') > -1) {
                    separator = '\t'; // Deteksi Tab (Excel)
                } else if (pastedData.indexOf('|') > -1) {
                    separator = '|'; // Deteksi Garis Lurus
                }
                
                // Jika ditemukan pemisah, kita proses
                if (separator) {
                    e.preventDefault(); // Mencegah paste default
                    
                    var parts = pastedData.split(separator);
                    var user = parts[0].trim();
                    var pass = parts[1] ? parts[1].trim() : '';

                    // Isi ke kolom input
                    $(this).val(user);
                    $('#password').val(pass);

                    // Beri notifikasi kecil (Toast)
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 2000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    });

                    Toast.fire({
                        icon: 'success',
                        title: 'Username & Password terisi otomatis!'
                    });

                    // Fokus ke tombol login agar siap tekan enter
                    $('#btn-submit').focus();
                }
            });
            // ============================================

            // 1. Toggle Password Visibility (Modern Way)
            $('#togglePassword').click(function() {
                const passwordInput = $('#password');
                const type = passwordInput.attr('type') === 'password' ? 'text' : 'password';
                passwordInput.attr('type', type);
                
                // Toggle Icon Class
                $(this).toggleClass('fa-eye fa-eye-slash');
            });

            // 2. Caps Lock Detector
            const passwordField = document.getElementById("password");
            const capsWarning = document.getElementById("caps-warning");

            passwordField.addEventListener("keyup", function(event) {
                if (event.getModifierState("CapsLock")) {
                    capsWarning.style.display = "block";
                } else {
                    capsWarning.style.display = "none";
                }
            });

            // 3. Form Submission with SweetAlert2
            $('#form-login').submit(function(e) {
                e.preventDefault();
                
                // UI Loading State
                const btn = $('#btn-submit');
                const originalText = btn.html();
                btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Memproses...');

                $.ajax({
                    url: "<?php echo site_url(); ?>/welcome/login",
                    type: "POST",
                    data: $(this).serialize(),
                    cache: false,
                    success: function(response) {
                        try {
                            const res = JSON.parse(response);
                            
                            if (res.status == 1) {
                                // Success Animation
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Login Berhasil!',
                                    text: 'Mengalihkan ke Dashboard...',
                                    showConfirmButton: false,
                                    timer: 1500,
                                    timerProgressBar: true,
                                    background: '#fff',
                                    color: '#333'
                                }).then(() => {
                                    window.location.href = "<?php echo site_url(); ?>/tes_dashboard";
                                });
                            } else {
                                // Error Animation
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Gagal Masuk',
                                    text: res.error || 'Username atau Password salah.',
                                    confirmButtonColor: '#d33',
                                    confirmButtonText: 'Coba Lagi'
                                });
                                
                                // Reset Button
                                btn.prop('disabled', false).html(originalText);
                                $('#password').val('').focus();
                            }
                        } catch (e) {
                            console.error("Parsing Error", e);
                            Swal.fire('Error', 'Terjadi kesalahan sistem.', 'error');
                            btn.prop('disabled', false).html(originalText);
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Koneksi Terputus',
                            text: 'Gagal menghubungi server.',
                            confirmButtonColor: '#f39c12'
                        });
                        btn.prop('disabled', false).html(originalText);
                    }
                });
            });
        });
    </script>
</body>
</html>