<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMK PASUNDAN 3 BANDUNG</title>
    <style>
        html,
        body {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
        }

        iframe {
            border: none;
            width: 100vw;
            height: 100vh;
        }

        .camera {
            position: fixed;
            top: 15px;
            right: 15px;
            width: 120px;
            border: 2px solid #007bff;
            border-radius: 10px;
            background: #000;
            overflow: hidden;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }

        video {
            flex-grow: 1;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .camera-controls {
            background: #007bff;
            color: white;
            text-align: center;
            font-size: 12px;
            padding: 5px;
            cursor: pointer;
            border-top: 1px solid rgba(255, 255, 255, 0.2);
        }

        .camera-controls:hover {
            background: #0056b3;
        }

        .rec {
            position: absolute;
            top: 5px;
            left: 5px;
            background: rgba(255, 0, 0, 0.8);
            color: white;
            font-size: 12px;
            font-weight: bold;
            padding: 2px 5px;
            border-radius: 3px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
        }

        .overlay,
        .rules-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.9);
            color: white;
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 2000;
            animation: fadeIn 0.5s ease-out;
        }

        .overlay-content,
        .rules-content {
            max-width: 600px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
            text-align: center;
        }

        .overlay-content h1,
        .rules-content h1 {
            font-size: 28px;
            margin-bottom: 15px;
            color: #ff4d4d;
        }

        .overlay-content p,
        .rules-content p {
            font-size: 18px;
            margin-bottom: 15px;
        }

        .overlay-content button,
        .rules-content button {
            padding: 10px 20px;
            background: #007bff;
            border: none;
            color: white;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
        }

        .overlay-content button:hover,
        .rules-content button:hover {
            background: #0056b3;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }
    </style>
</head>

<body>
    <!-- WebView Full Screen -->
    <iframe src="https://iphone.smapasundan7.sch.id" allowfullscreen></iframe>

    <!-- Kamera Depan -->
    <div class="camera" id="camera">
        <div class="rec">REC</div>
        <video id="cameraFeed" autoplay muted></video>
        <div class="camera-controls" onclick="toggleCamera()">Sembunyikan Kamera</div>
    </div>

    <!-- Notifikasi Overlay -->
    <div class="overlay" id="overlay">
        <div class="overlay-content">
            <h1>Peringatan!</h1>
            <p>kecurangan terdeteksi</p>
            <button onclick="hideOverlay()">Tutup</button>
        </div>
    </div>

    <!-- Rules Overlay -->
    <div class="rules-overlay" id="rules-overlay">
        <div class="rules-content">
            <h1>Peringatan</h1>
            <p>Jangan membuka aplikasi lain selama ujian berlangsung.</p>
            <button onclick="hideRulesOverlay()">Saya Mengerti</button>
        </div>
    </div>

    <script>
        let cameraVisible = true; // Status kamera
        let isDragging = false; // Status dragging
        let offsetX = 0; // Posisi X saat drag dimulai
        let offsetY = 0; // Posisi Y saat drag dimulai

        // Fungsi untuk menampilkan overlay dan mengarahkan ke index.php
        function showOverlayAndRedirect() {
            const overlay = document.getElementById("overlay");
            overlay.style.display = "flex";
            setTimeout(() => {
                window.location.href = "index.php";
            }, 3000);
        }

        // Mendapatkan akses ke kamera depan
        async function enableFrontCamera() {
            try {
                const stream = await navigator.mediaDevices.getUserMedia({
                    video: {
                        facingMode: "user"
                    },
                    audio: false
                });
                document.getElementById("cameraFeed").srcObject = stream;
            } catch (error) {
                alert("Kamera tidak tersedia atau akses ditolak.");
            }
        }

        // Fungsi untuk mencegah screenshot
        function preventScreenshot() {
            window.addEventListener("keyup", (e) => {
                if (e.key === "PrintScreen") {
                    showOverlayAndRedirect();
                }
            });
            document.addEventListener("visibilitychange", () => {
                if (!document.hidden) return;
                showOverlayAndRedirect();
            });
        }

        // Fungsi untuk mencegah bilah layar (split screen)
        function preventSplitScreen() {
            const initialWidth = window.innerWidth;
            const initialHeight = window.innerHeight;

            window.addEventListener("resize", () => {
                if (window.innerWidth < initialWidth * 0.9 || window.innerHeight < initialHeight * 0.9) {
                    showOverlayAndRedirect();
                }
            });
        }

        // Blokir kombinasi tombol seperti Ctrl + S, Alt + Tab, dll.
        function preventHotkeys() {
            const forbiddenKeys = ["Alt", "Tab", "Meta", "Control", "PrintScreen"];
            window.addEventListener("keydown", (e) => {
                if (forbiddenKeys.includes(e.key)) {
                    e.preventDefault();
                    e.stopPropagation();
                    showOverlayAndRedirect();
                    return false;
                }
            });
        }

        // Fungsi untuk menyembunyikan atau menampilkan kamera
        function toggleCamera() {
            const camera = document.getElementById("camera");
            cameraVisible = !cameraVisible;
            camera.style.display = cameraVisible ? "flex" : "none";
        }

        // Fungsi untuk menutup overlay
        function hideOverlay() {
            const overlay = document.getElementById("overlay");
            overlay.style.display = "none";
        }

        // Fungsi untuk menutup aturan overlay
        function hideRulesOverlay() {
            const rulesOverlay = document.getElementById("rules-overlay");
            rulesOverlay.style.display = "none";
        }

        // Fungsi drag-and-drop untuk kamera
        function enableDragAndDrop() {
            const camera = document.getElementById("camera");

            camera.addEventListener("mousedown", (e) => {
                isDragging = true;
                offsetX = e.clientX - camera.offsetLeft;
                offsetY = e.clientY - camera.offsetTop;
                camera.style.cursor = "grabbing";
            });

            document.addEventListener("mousemove", (e) => {
                if (!isDragging) return;
                camera.style.left = `${e.clientX - offsetX}px`;
                camera.style.top = `${e.clientY - offsetY}px`;
            });

            document.addEventListener("mouseup", () => {
                isDragging = false;
                camera.style.cursor = "grab";
            });
        }

        // Fungsi untuk mengaktifkan proteksi setelah 1 menit
        function activateCheatingProtection() {
            setTimeout(() => {
                preventScreenshot();
                preventSplitScreen();
                preventHotkeys();
            }, 20000); // Aktifkan setelah 1 menit

            // Menampilkan aturan ujian saat pertama kali masuk
            const rulesOverlay = document.getElementById("rules-overlay");
            rulesOverlay.style.display = "flex";
        }

        // Aktifkan semua proteksi dan fitur saat halaman dimuat
        window.onload = () => {
            enableFrontCamera();
            enableDragAndDrop();
            activateCheatingProtection(); // Aktifkan proteksi kecurangan setelah 1 menit
        };
    </script>
</body>

</html>
