<?php
session_start();

// Cek apakah sudah ada pelanggaran sebelumnya
if (!isset($_SESSION['pelanggaran'])) {
    $_SESSION['pelanggaran'] = 1; // Pelanggaran pertama
} else {
    $_SESSION['pelanggaran']++; // Tambah jumlah pelanggaran
}

// Hitung waktu tunggu (30 detik x jumlah pelanggaran)
$waktu_tunggu = 30 * $_SESSION['pelanggaran'];

// Hapus sesi setelah pengalihan untuk reset saat akses normal
if ($waktu_tunggu > 30 * 3) { // Maksimal 90 detik
    $waktu_tunggu = 90;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peringatan Keamanan</title>
    <style>
        /* Background */
        body {
            font-family: 'Arial', sans-serif;
            text-align: center;
            background: url('../bg.jpg') no-repeat center center fixed;
            background-size: cover;
            color: white;
            padding: 50px;
            overflow: hidden;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
        }
        /* Container */
        .container {
            background: rgba(0, 0, 0, 0.7);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.5);
            max-width: 450px;
            width: 90%;
            animation: fadeIn 1.5s ease-in-out;
        }
        /* Efek Teks */
        h1 {
            font-size: 28px;
            margin-bottom: 10px;
            text-transform: uppercase;
            animation: bounce 1s infinite alternate;
        }
        p {
            font-size: 16px;
            margin-bottom: 15px;
        }
        /* Kotak Hitungan Mundur */
        .countdown {
            font-size: 40px;
            font-weight: bold;
            background: rgba(255, 255, 255, 0.2);
            padding: 10px 20px;
            border-radius: 10px;
            display: inline-block;
            animation: pulse 1s infinite alternate;
        }
        /* Ikon Peringatan */
        .warning-icon {
            font-size: 60px;
            color: yellow;
            margin-bottom: 10px;
        }
        /* Hadis */
        .hadis {
            font-size: 14px;
            font-style: italic;
            margin-top: 20px;
            background: rgba(255, 255, 255, 0.2);
            padding: 15px;
            border-radius: 10px;
            line-height: 1.5;
        }
        /* Animasi */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        @keyframes bounce {
            from { transform: translateY(0); }
            to { transform: translateY(-5px); }
        }
        @keyframes pulse {
            from { transform: scale(1); }
            to { transform: scale(1.1); }
        }
    </style>
    <script>
        let timeLeft = <?php echo $waktu_tunggu; ?>;

        function startCountdown() {
            const countdownElement = document.getElementById("countdown");
            const warningSound = new Audio("https://www.soundjay.com/button/beep-07.wav");
            warningSound.play();
            
            if (navigator.vibrate) {
                navigator.vibrate([500, 300, 500]);
            }

            const interval = setInterval(() => {
                countdownElement.textContent = timeLeft;
                timeLeft--;

                if (timeLeft < 0) {
                    clearInterval(interval);
                    <?php session_destroy(); ?> 
                    window.location.href = "../index.php";
                }
            }, 1000);
        }

        window.onload = startCountdown;
    </script>
</head>
<body>
    <div class="container">
        <div class="warning-icon">⚠️</div>
        <h1>Kecurangan Terdeteksi!</h1>
        <p>Jika terjadi lagi, waktu tunggu akan semakin lama.</p>
        <h1><span id="countdown" class="countdown"><?php echo $waktu_tunggu; ?></span></h1>

        <!-- Hadis Kejujuran -->
        <div class="hadis">
            <strong>Hadis tentang Kejujuran:</strong><br>
            "Sesungguhnya kejujuran itu membawa kepada kebaikan, dan kebaikan itu membawa ke surga..."  
            <br><small>(HR. Bukhari & Muslim)</small>
        </div>
    </div>
</body>
</html>
