<?php
  header("Content-type: application/vnd-ms-excel");
  header("Content-Disposition: attachment; filename=Data-Absensi.xls");
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <title><?php echo $this->config->item('app_name') ?> <?php echo isset($title) ? ' | ' . $title : null; ?></title>
        <style type="text/css">
            .tbl, .tbl td, .tbl th {
                border: 1px solid black;
                border-collapse: collapse;
            }
            .tbl th {
                background-color: black;
                color: white;
            }
            .centered {
                text-align: center;
            }
        </style>
    </head>
    <body>
        <div class="ticket">
            <table>
                <tr>
                    <th align="left">Laporan Keuangan</th>
                </tr>
                <tr>
                    <th align="left"><?=  $setting_school['setting_value'] ?></th>
                </tr>
                <tr>
                    <th align="left">Tanggal Laporan</th>
                    <th>: <?= pretty_date($q['ds'],'d F Y',false).' s/d '.pretty_date($q['de'],'d F Y',false) ?></th>
                </tr>
                <tr>
                    <th align="left">Tanggal Unduh</th>
                    <th>: <?= pretty_date(date('Y-m-d h:i:s'),'d F Y, H:i',false) ?></th>
                </tr>
                <tr>
                    <th align="left">Pengunduh</th>
                    <th>: <?= $this->session->userdata('ufullname') ?></th>
                </tr>
            </table>

            <table class="tbl">
              <tr>
                <th>No</th>
                <th>Pembayaran</th>
                <th>Nama Siswa</th>
                <th>Kelas</th>
                <th>Tanggal</th>
                <th>Penerimaan</th>
                <th>Keterangan</th>
              </tr>
              <?php
              $no = 1;
              foreach ($bulan as $row) {   
                  $ta = $row['pos_name'].' - T.A '.$row['period_start'].'/'.$row['period_end'].'-'.$row['month_name'];
                  $siswa = $row['student_full_name'];
                  $kelas = $row['class_name'];
                  $tanggal = pretty_date($row['bulan_date_pay'], 'm/d/Y', FALSE);
                  $penerimaan = $row['bulan_bill'];
                  $keterangan = $row['bebas_pay_desc'];
                  <tr>
                      <td><?= $no ?></td>
                      <td><?= $ta ?></td>
                      <td><?= $siswa ?></td>
                      <td><?= $kelas ?></td>
                      <td><?= $tanggal ?></td>
                      <td><?= $penerimaan ?></td>
                      <td><?= $keterangan ?></td>
                  </tr>
              <?php 
              $no++;
              }

              foreach ($free as $row) {
                  $ta_free = $row['pos_name'].' - T.A '.$row['period_start'].'/'.$row['period_end'];
                  $siswa = $row['student_full_name'];
                  $kelas = $row['class_name'];
                  $tanggal = pretty_date($row['bebas_pay_input_date'], 'm/d/Y', FALSE);
                  $penerimaan = $row['bebas_pay_bill'];
                  $keterangan =($row['bebas_pay_desc']) ? $row['bebas_pay_desc'] : ''; ?>
                  <tr>
                      <td><?= $no ?></td>
                      <td><?= $ta_free ?></td>
                      <td><?= $siswa ?></td>
                      <td><?= $kelas ?></td>
                      <td><?= $tanggal ?></td>
                      <td><?= $penerimaan ?></td>
                      <td><?= $keterangan ?></td>
                  </tr>
              <?php  
              $no++;
              }

              foreach ($kredit as $row) {
                  $kredits = $row['kredit_desc'];
                  $tanggal_kredit = pretty_date($row['kredit_date'], 'm/d/Y', FALSE);
                  $kredit_value = $row['kredit_value']; ?>
                  <tr>
                      <td><?= $no ?></td>
                      <td><?= $kredits ?></td>
                      <td></td>
                      <td></td>
                      <td><?= $tanggal_kredit ?></td>
                      <td></td>
                      <td><?= $kredit_value ?></td>
                      <td></td>
                  </tr>
              <?php  
              $no++;
              }

              foreach ($debit as $row) {
                  $debits = $row['debit_desc'];
                  $tanggal_debit = pretty_date($row['debit_date'], 'm/d/Y', FALSE);
                  $debit_value = $row['debit_value']; ?>
                  <tr>
                      <td><?= $no ?></td>
                      <td><?= $debits ?></td>
                      <td></td>
                      <td></td>
                      <td><?= $tanggal_debit ?></td>
                      <td><?= $debit_value ?></td>
                      <td></td>
                      <td></td>
                  </tr>
              <?php  
              $no++;
              }
              ?>
            </table>
        </div>
    </body>
</html>
