<?php
// Mulai sesi PHP. Ini penting untuk mengakses variabel sesi.
session_start();

// Sertakan file konfigurasi database
require_once '../config.php'; // Pastikan path ini benar

// Periksa apakah pengguna sudah login
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== TRUE) {
    // Jika belum login, arahkan kembali ke halaman login
    header("location: index.php"); // Arahkan ke file login.php Anda
    exit;
}

// Periksa peran pengguna. Hanya admin yang bisa mengakses halaman ini.
if ($_SESSION['role'] !== 'admin') {
    // Jika bukan admin, arahkan ke halaman lain atau tampilkan pesan akses ditolak
    header("location: index.php"); // Contoh: arahkan ke halaman selamat datang umum
    exit;
}

// Data pengguna yang akan ditampilkan di halaman admin
$nama_pengguna = htmlspecialchars($_SESSION['nama']);
$username_pengguna = htmlspecialchars($_SESSION['username']);
$role_pengguna = htmlspecialchars($_SESSION['role']);

// Direktori untuk logo sekolah
$uploadDir = 'uploads/';

// Fungsi untuk mendapatkan pengaturan sekolah saat ini (duplikat dari setting.php untuk kemudahan, idealnya di file helper terpisah)
function getSchoolSettings($conn) {
    $sql = "SELECT nama_sekolah, alamat_sekolah, logo_sekolah FROM pengaturan_sekolah WHERE id = 1 LIMIT 1";
    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    return ['nama_sekolah' => 'Nama Sekolah Default', 'alamat_sekolah' => '', 'logo_sekolah' => '']; // Nilai default
}

// Ambil pengaturan sekolah
$settings = getSchoolSettings($conn);
$conn->close(); // Tutup koneksi database setelah semua operasi

$nama_sekolah_display = htmlspecialchars($settings['nama_sekolah']);
$logo_sekolah_path = !empty($settings['logo_sekolah']) ? $uploadDir . htmlspecialchars($settings['logo_sekolah']) : 'https://placehold.co/60x60/B0E0E6/000000?text=LOGO'; // Placeholder jika tidak ada logo
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - <?php echo $nama_pengguna; ?></title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Inter dari Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            transition: background-color 0.5s ease-in-out, color 0.5s ease-in-out;
            overflow-x: hidden; /* Mencegah scroll horizontal */
        }
        /* Mode gelap: Latar belakang yang lebih dalam */
        html.dark body {
            background-color: #0b0c10;
            color: #e2e8f0;
        }
        /* Mode terang: Latar belakang yang lebih hidup */
        html:not(.dark) body {
            background-color: #e0e7ff;
            color: #1a202c;
        }
        /* Transisi untuk elemen di dalam kartu */
        .glass-effect {
            transition: background-color 0.5s ease-in-out, border-color 0.5s ease-in-out, box-shadow 0.5s ease-in-out;
        }
        /* Mode gelap untuk teks */
        html.dark .text-day-mode-black {
            color: #e2e8f0;
        }
        /* Mode terang untuk teks: tetap hitam */
        html:not(.dark) .text-day-mode-black {
            color: #000000;
        }
        html.dark .sidebar {
            background-color: #1a202c;
            border-right-color: #2d3748;
        }
        html:not(.dark) .sidebar {
            background-color: #ffffff;
            border-right-color: #e2e8f0;
        }
        html.dark .sidebar a {
            color: #a0aec0;
        }
        html.dark .sidebar a:hover {
            background-color: #2d3748;
            color: #ffffff;
        }
        html:not(.dark) .sidebar a {
            color: #4a5568;
        }
        html:not(.dark) .sidebar a:hover {
            background-color: #edf2f7;
            color: #2d3748;
        }
        /* Gaya untuk tombol pengalih tema */
        #themeToggle {
            transition: background-color 0.5s ease-in-out, color 0.5s ease-in-out, box-shadow 0.5s ease-in-out;
        }

        /* Gaya untuk sidebar minimisasi */
        .sidebar {
            width: 256px; /* Lebar default (w-64) */
            transition: width 0.3s ease-in-out; /* Transisi untuk perubahan lebar */
            flex-shrink: 0; /* Mencegah sidebar menyusut saat konten utama lebar */
        }
        .sidebar.minimized {
            width: 64px; /* Lebar saat diminimalisir (w-16) */
        }
        .sidebar.minimized .sidebar-text {
            display: none; /* Sembunyikan teks menu */
        }
        .sidebar.minimized .sidebar-icon {
            margin-right: 0 !important; /* Hapus margin dari ikon */
            /* Mengatur ukuran ikon agar terlihat jelas saat diminimalisir */
            width: 24px; /* Sedikit lebih besar dari w-5 (20px) */
            height: 24px; /* Sedikit lebih besar dari h-5 (20px) */
        }
        .sidebar.minimized .sidebar-menu-item {
            justify-content: center; /* Pusatkan ikon */
            padding-left: 0; /* Hapus padding kiri */
            padding-right: 0; /* Hapus padding kanan */
        }
        .sidebar.minimized .sidebar-dropdown-icon {
            display: none; /* Sembunyikan ikon panah dropdown saat diminimalisir */
        }
        .sidebar.minimized .sidebar-header {
            visibility: hidden; /* Sembunyikan teks header sidebar */
            white-space: nowrap; /* Pastikan teks tidak membungkus */
            overflow: hidden; /* Sembunyikan overflow */
            width: 0; /* Atur lebar menjadi nol */
            padding-left: 0;
            padding-right: 0;
        }
        .sidebar.minimized .sidebar-toggle-button {
            justify-content: center; /* Pusatkan tombol toggle */
        }
        .sidebar.minimized .school-logo {
            margin-right: 0 !important; /* Hapus margin kanan logo */
            width: 40px; /* Sesuaikan ukuran logo saat diminimalisir */
            height: 40px; /* Sesuaikan ukuran logo saat diminimalisir */
        }
        .sidebar.minimized .school-name {
            display: none; /* Sembunyikan nama sekolah saat diminimalisir (tetap) */
        }

        /* Tooltip untuk ikon saat sidebar diminimalisir */
        .sidebar.minimized [data-tooltip]:hover:after {
            content: attr(data-tooltip); /* Ambil teks dari atribut data-tooltip */
            position: absolute;
            left: 70px; /* Sesuaikan posisi tooltip */
            top: 50%;
            transform: translateY(-50%);
            background-color: #333;
            color: #fff;
            padding: 5px 10px;
            border-radius: 4px;
            white-space: nowrap;
            z-index: 999;
            opacity: 1;
            transition: opacity 0.2s ease;
        }
        .sidebar.minimized [data-tooltip]:after {
            opacity: 0; /* Sembunyikan secara default */
            pointer-events: none; /* Jangan menghalangi interaksi mouse */
        }
    </style>
</head>
<body class="flex min-h-screen">

    <!-- Sidebar -->
    <aside id="sidebar" class="sidebar w-64 p-5 border-r shadow-lg flex flex-col justify-between transition-colors duration-500 relative">
        <div>
            <div class="flex items-center justify-between mb-8">
                <div class="flex items-center sidebar-header">
                    <!-- Logo Sekolah -->
                    <img src="<?php echo $logo_sekolah_path; ?>" alt="Logo Sekolah" class="school-logo w-12 h-12 object-contain mr-3 rounded-md" onerror="this.onerror=null;this.src='https://placehold.co/60x60/B0E0E6/000000?text=LOGO';">
                    <span class="text-xl font-bold text-blue-600 dark:text-blue-400 school-name"><?php echo $nama_sekolah_display; ?></span>
                </div>
                <button id="sidebarToggle" class="p-2 rounded-full hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-toggle-button">
                    <!-- Icon untuk toggle sidebar (hamburger atau chevron) -->
                    <svg class="w-6 h-6 sidebar-toggle-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
            <nav>
                <ul class="space-y-1">
                    <li>
                        <a href="admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Dashboard">
                            <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg>
                            <span class="sidebar-text">Dashboard</span>
                        </a>
                    </li>
                    <!-- Dropdown Menu untuk Manajemen Pengguna -->
                    <li class="relative">
                        <a href="#" id="manajemenPenggunaDropdownToggle" class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Manajemen Pengguna">
                            <div class="flex items-center">
                                <!-- Icon "users" -->
                                <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h-5v-9H4L12 3l8 8h-8v9z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 11c-2.209 0-4-1.791-4-4s1.791-4 4-4 4 1.791 4 4-1.791 4-4 4zM12 13a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                                <span class="sidebar-text">Manajemen Pengguna</span>
                            </div>
                            <svg id="manajemenPenggunaDropdownArrow" class="w-4 h-4 sidebar-dropdown-icon transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </a>
                        <ul id="manajemenPenggunaSubmenu" class="pl-8 mt-1 space-y-1 hidden">
                            <li>
                                <a href="daftarsiswa.php" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Lihat Semua Pengguna">
                                    <span class="sidebar-text">Daftar Siswa</span>
                                </a>
                            </li>
                            <li>
                                <a href="pengawas.php" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Manajemen Pengawas">
                                    <span class="sidebar-text">Manajemen Pengawas</span>
                                </a>
                            </li>
                             <li>
                                <a href="#" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Tambah Pengguna Baru">
                                    <span class="sidebar-text">Tambah Pengguna</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <a href="#" class="flex items-center py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Laporan">
                            <!-- Icon "book" -->
                            <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.523 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5s3.332.477 4.5 1.253v13C19.832 18.523 18.246 18 16.5 18s-3.332.477-4.5 1.253"></path></svg>
                            <span class="sidebar-text">Laporan</span>
                        </a>
                    </li>
                    <!-- Dropdown Menu untuk Pengaturan -->
                    <li class="relative">
                        <a href="#" id="settingsDropdownToggle" class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Pengaturan">
                            <div class="flex items-center">
                                <!-- Icon "settings" -->
                                <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.525.322 1.018.673 1.505 1.01z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                <span class="sidebar-text">Pengaturan</span>
                            </div>
                            <svg id="settingsDropdownArrow" class="w-4 h-4 sidebar-dropdown-icon transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </a>
                        <ul id="settingsSubmenu" class="pl-8 mt-1 space-y-1 hidden">
                            <li>
                                <a href="setting.php" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Pengaturan Umum">
                                    <span class="sidebar-text">Pengaturan Umum</span>
                                </a>
                            </li>
                            <li>
                                <a href="waapi.php" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Pengaturan WA API">
                                    <span class="sidebar-text">Pengaturan WA API</span>
                                </a>
                            </li>
                             <li>
                                <a href="token.php" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Pengaturan Token Ujian">
                                    <span class="sidebar-text">Token Ujian</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </nav>
        </div>
        <div class="mt-8">
            <a href="logout.php" class="flex items-center py-2 px-3 rounded-lg bg-red-500 hover:bg-red-600 text-white transition-colors duration-200 sidebar-menu-item" data-tooltip="Logout">
                <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
                <span class="sidebar-text">Logout</span>
            </a>
        </div>
    </aside>

    <!-- Konten Utama -->
    <main id="mainContent" class="flex-1 p-10 transition-all duration-300">
        <!-- Tombol pengalih tema gelap/terang -->
        <div class="absolute top-4 right-4 z-10">
            <button id="themeToggle" class="p-2 rounded-full bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-white shadow-md">
                <!-- Icon SVG untuk tema terang (matahari) -->
                <svg class="w-6 h-6 sun-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h1M3 12h1m15.325-7.757l-.707-.707M4.343 19.657l-.707-.707m12.728 0l-.707.707M6.343 6.343l-.707-.707"></path>
                </svg>
                <!-- Ikon bulan, tersembunyi secara default -->
                <svg class="w-6 h-6 moon-icon hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9 9 0 008.354-5.646z"></path>
                </svg>
            </button>
        </div>

        <h1 class="text-4xl font-extrabold mb-8 text-day-mode-black dark:text-white">Dashboard Admin</h1>

        <div class="glass-effect p-8 rounded-lg shadow-xl mb-8">
            <h3 class="text-2xl font-semibold mb-4 text-day-mode-black dark:text-white">Selamat Datang, <?php echo $nama_pengguna; ?>!</h3>
            <p class="text-gray-700 dark:text-gray-300">Anda masuk sebagai **<?php echo $role_pengguna; ?>**.</p>
            <p class="text-gray-600 dark:text-gray-400 mt-2">Ini adalah halaman utama panel administrasi Anda. Gunakan sidebar di kiri untuk navigasi.</p>
        </div>

        <!-- Tambahkan lebih banyak konten dashboard di sini -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <div class="glass-effect p-6 rounded-lg shadow-md">
                <h4 class="text-xl font-semibold mb-3 text-day-mode-black dark:text-white">Statistik Pengguna</h4>
                <p class="text-gray-700 dark:text-gray-300">Jumlah pengguna terdaftar: <strong>XXX</strong></p>
                <p class="text-gray-700 dark:text-gray-300">Pengguna aktif bulan ini: <strong>YYY</strong></p>
            </div>
            <div class="glass-effect p-6 rounded-lg shadow-md">
                <h4 class="text-xl font-semibold mb-3 text-day-mode-black dark:text-white">Aktivitas Terkini</h4>
                <ul class="list-disc list-inside text-gray-700 dark:text-gray-300">
                    <li>Pengguna <strong><?php echo $username_pengguna; ?></strong> login.</li>
                    <li>Laporan baru ditambahkan.</li>
                    <li>Pengaturan sistem diperbarui.</li>
                </ul>
            </div>
            <div class="glass-effect p-6 rounded-lg shadow-md">
                <h4 class="text-xl font-semibold mb-3 text-day-mode-black dark:text-white">Pintasan Cepat</h4>
                <ul class="space-y-2">
                    <li><a href="#" class="text-blue-600 hover:underline dark:text-blue-400">Tambah Pengguna Baru</a></li>
                    <li><a href="#" class="text-blue-600 hover:underline dark:text-blue-400">Lihat Semua Laporan</a></li>
                    <li><a href="#" class="text-blue-600 hover:underline dark:text-blue-400">Kelola Pengaturan</a></li>
                </ul>
            </div>
        </div>

        <!-- Powered by: digipas.id dengan logo dan tahun -->
        <div class="text-center mt-10">
            <!-- Logo Digipas.id dari file digipas.png dengan ukuran kecil dan warna asli -->
            <img src="digipas.png" alt="Logo Digipas.id" class="mx-auto mb-2 w-16 h-auto" onerror="this.onerror=null;this.src='https://placehold.co/64x16/AAAAAA/FFFFFF?text=Logo+Error';">
            <p class="text-sm text-gray-600 dark:text-gray-400">
                Powered by: digipas.id &copy; <span id="currentYear"></span>
            </p>
        </div>
    </main>

    <!-- Skrip JavaScript -->
    <script>
        const themeToggle = document.getElementById('themeToggle');
        const htmlElement = document.documentElement;
        const sunIcon = document.querySelector('.sun-icon');
        const moonIcon = document.querySelector('.moon-icon');
        
        // Fungsi untuk menerapkan tema (gelap atau terang)
        function applyTheme(theme) {
            if (theme === 'dark') {
                htmlElement.classList.add('dark');
                sunIcon.classList.add('hidden');
                moonIcon.classList.remove('hidden');
            } else {
                htmlElement.classList.remove('dark');
                sunIcon.classList.remove('hidden');
                moonIcon.classList.add('hidden');
            }
        }

        // Periksa preferensi tema yang tersimpan di localStorage saat halaman dimuat
        const savedTheme = localStorage.getItem('theme');
        if (savedTheme) {
            applyTheme(savedTheme);
        } else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            applyTheme('dark');
        } else {
            applyTheme('light');
        }

        // Tambahkan event listener untuk tombol pengalih tema
        themeToggle.addEventListener('click', () => {
            if (htmlElement.classList.contains('dark')) {
                applyTheme('light');
                localStorage.setItem('theme', 'light');
            } else {
                localStorage.setItem('theme', 'dark');
                localStorage.setItem('theme', 'dark');
            }
        });

        // Set tahun saat ini
        document.getElementById('currentYear').textContent = new Date().getFullYear();

        // JavaScript untuk Dropdown Sidebar - Manajemen Pengguna
        const manajemenPenggunaDropdownToggle = document.getElementById('manajemenPenggunaDropdownToggle');
        const manajemenPenggunaSubmenu = document.getElementById('manajemenPenggunaSubmenu');
        const manajemenPenggunaDropdownArrow = document.getElementById('manajemenPenggunaDropdownArrow'); // Diperbarui dari 'dropdownArrow'

        if (manajemenPenggunaDropdownToggle && manajemenPenggunaSubmenu && manajemenPenggunaDropdownArrow) {
            manajemenPenggunaDropdownToggle.addEventListener('click', (e) => {
                e.preventDefault();
                manajemenPenggunaSubmenu.classList.toggle('hidden');
                manajemenPenggunaDropdownArrow.classList.toggle('rotate-180');
            });
            // Pastikan sub-menu manajemen pengguna terbuka jika sedang di halaman pengawas.php
            const currentPath = window.location.pathname;
            if (currentPath.includes('pengawas.php') || currentPath.includes('daftarsiswa.php')) { // Tambahkan daftarsiswa.php
                manajemenPenggunaSubmenu.classList.remove('hidden');
                manajemenPenggunaDropdownArrow.classList.add('rotate-180');
            }
        }

        // JavaScript untuk Dropdown Sidebar - Pengaturan (Ditambahkan)
        const settingsDropdownToggle = document.getElementById('settingsDropdownToggle');
        const settingsSubmenu = document.getElementById('settingsSubmenu');
        const settingsDropdownArrow = document.getElementById('settingsDropdownArrow');

        if (settingsDropdownToggle && settingsSubmenu && settingsDropdownArrow) {
            settingsDropdownToggle.addEventListener('click', (e) => {
                e.preventDefault();
                settingsSubmenu.classList.toggle('hidden');
                settingsDropdownArrow.classList.toggle('rotate-180');
            });
            // Pastikan sub-menu pengaturan terbuka jika sedang berada di halaman waapi.php atau token.php
            const currentPath = window.location.pathname;
            if (currentPath.includes('waapi.php') || currentPath.includes('setting.php') || currentPath.includes('token.php')) {
                settingsSubmenu.classList.remove('hidden');
                settingsDropdownArrow.classList.add('rotate-180');
            }
        }


        // JavaScript untuk Sidebar Minimization
        const sidebarToggle = document.getElementById('sidebarToggle');
        const sidebar = document.getElementById('sidebar');
        const sidebarToggleIcon = document.querySelector('.sidebar-toggle-icon');
        // Tidak perlu schoolName, schoolLogo, sidebarHeader di sini karena mereka hanya elemen HTML yang dihidupkan/dimatikan dengan CSS

        // Fungsi untuk menginisialisasi sidebar berdasarkan status tersimpan
        function initializeSidebar() {
            const isMinimized = localStorage.getItem('sidebarMinimized') === 'true';
            if (isMinimized) {
                sidebar.classList.add('minimized');
                sidebarToggleIcon.setAttribute('d', 'M9 5l7 7-7 7'); // Chevron kanan
            } else {
                sidebar.classList.remove('minimized');
                sidebarToggleIcon.setAttribute('d', 'M4 6h16M4 12h16M4 18h16'); // Hamburger
            }
            // Tambahkan event listener setelah inisialisasi awal
            sidebarToggle.addEventListener('click', toggleSidebar);
        }
        
        // Fungsi untuk mengganti status sidebar dan menyimpannya
        function toggleSidebar() {
            const isCurrentlyMinimized = sidebar.classList.contains('minimized');
            if (isCurrentlyMinimized) {
                sidebar.classList.remove('minimized');
                sidebarToggleIcon.setAttribute('d', 'M4 6h16M4 12h16M4 18h16'); // Hamburger
                localStorage.setItem('sidebarMinimized', 'false');
            } else {
                sidebar.classList.add('minimized');
                sidebarToggleIcon.setAttribute('d', 'M9 5l7 7-7 7'); // Chevron kanan
                localStorage.setItem('sidebarMinimized', 'true');
            }
        }
        
        // Panggil inisialisasi sidebar saat DOM siap
        document.addEventListener('DOMContentLoaded', initializeSidebar);
    </script>
</body>
</html>
