<?php
session_start();

require_once '../config.php';

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== TRUE) {
    header("location: index.php");
    exit;
}

if ($_SESSION['role'] !== 'admin') {
    header("location: index.php");
    exit;
}

$nama_pengguna = htmlspecialchars($_SESSION['nama']);
$username_pengguna = htmlspecialchars($_SESSION['username']);
$role_pengguna = htmlspecialchars($_SESSION['role']);

$uploadDir = 'uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

function getSchoolSettings($conn) {
    $sql = "SELECT nama_sekolah, alamat_sekolah, logo_sekolah FROM pengaturan_sekolah WHERE id = 1 LIMIT 1";
    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    return ['nama_sekolah' => 'Nama Sekolah Default', 'alamat_sekolah' => '', 'logo_sekolah' => ''];
}

$settings = getSchoolSettings($conn);
$nama_sekolah_display = htmlspecialchars($settings['nama_sekolah']);
$logo_sekolah_path = !empty($settings['logo_sekolah']) ? $uploadDir . htmlspecialchars($settings['logo_sekolah']) : 'https://placehold.co/60x60/B0E0E6/000000?text=LOGO';


$statusMessage = '';
$messageType = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nama_sekolah = $conn->real_escape_string(htmlspecialchars($_POST['nama_sekolah']));
    $alamat_sekolah = $conn->real_escape_string(htmlspecialchars($_POST['alamat_sekolah']));
    $current_logo = $conn->real_escape_string(htmlspecialchars($_POST['current_logo']));

    $logo_file_name = $current_logo;

    if (isset($_FILES['logo_sekolah']) && $_FILES['logo_sekolah']['error'] == UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['logo_sekolah']['tmp_name'];
        $fileName = $_FILES['logo_sekolah']['name'];
        $fileSize = $_FILES['logo_sekolah']['size'];
        $fileType = $_FILES['logo_sekolah']['type'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));
        $newFileName = md5(time() . $fileName) . '.' . $fileExtension;
        $destPath = $uploadDir . $newFileName;

        $allowedfileExtensions = array('jpg', 'gif', 'png', 'jpeg');
        if (in_array($fileExtension, $allowedfileExtensions)) {
            if (!empty($current_logo) && file_exists($uploadDir . $current_logo) && $current_logo !== $newFileName) {
                unlink($uploadDir . $current_logo);
            }

            if (move_uploaded_file($fileTmpPath, $destPath)) {
                $logo_file_name = $newFileName;
                $statusMessage = "Pengaturan berhasil diperbarui dan logo baru diunggah.";
                $messageType = "success";
            } else {
                $statusMessage = "Gagal mengunggah logo baru.";
                $messageType = "error";
            }
        } else {
            $statusMessage = "Ekstensi file logo tidak diizinkan. Hanya JPG, JPEG, PNG, GIF yang diperbolehkan.";
            $messageType = "error";
        }
    } else if (isset($_POST['remove_logo']) && $_POST['remove_logo'] === 'true') {
        if (!empty($current_logo) && file_exists($uploadDir . $current_logo)) {
            unlink($uploadDir . $current_logo);
            $logo_file_name = NULL;
            $statusMessage = "Logo berhasil dihapus.";
            $messageType = "success";
        } else {
            $statusMessage = "Tidak ada logo untuk dihapus atau logo tidak ditemukan.";
            $messageType = "error";
        }
    }


    $sql_check = "SELECT id FROM pengaturan_sekolah WHERE id = 1";
    $result_check = $conn->query($sql_check);

    if ($result_check->num_rows > 0) {
        $sql = "UPDATE pengaturan_sekolah SET nama_sekolah = '$nama_sekolah', alamat_sekolah = '$alamat_sekolah', logo_sekolah = " . ($logo_file_name ? "'$logo_file_name'" : "NULL") . " WHERE id = 1";
    } else {
        $sql = "INSERT INTO pengaturan_sekolah (id, nama_sekolah, alamat_sekolah, logo_sekolah) VALUES (1, '$nama_sekolah', '$alamat_sekolah', " . ($logo_file_name ? "'$logo_file_name'" : "NULL") . ")";
    }

    if ($conn->query($sql) === TRUE) {
        if (empty($statusMessage)) {
            $statusMessage = "Pengaturan sekolah berhasil diperbarui.";
            $messageType = "success";
        }
    } else {
        $statusMessage = "Terjadi kesalahan saat memperbarui pengaturan: " . $conn->error;
        $messageType = "error";
    }
}

$settings = getSchoolSettings($conn);
$conn->close();

$nama_sekolah_display = htmlspecialchars($settings['nama_sekolah']);
$logo_sekolah_path = !empty($settings['logo_sekolah']) ? $uploadDir . htmlspecialchars($settings['logo_sekolah']) : 'https://placehold.co/60x60/B0E0E6/000000?text=LOGO';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengaturan Sekolah - Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            transition: background-color 0.5s ease-in-out, color 0.5s ease-in-out;
            overflow-x: hidden;
        }
        html.dark body {
            background-color: #0b0c10;
            color: #e2e8f0;
        }
        html:not(.dark) body {
            background-color: #e0e7ff;
            color: #1a202c;
        }
        .glass-effect {
            transition: background-color 0.5s ease-in-out, border-color 0.5s ease-in-out, box-shadow 0.5s ease-in-out;
        }
        html.dark .text-day-mode-black {
            color: #e2e8f0;
        }
        html:not(.dark) .text-day-mode-black {
            color: #000000;
        }
        html.dark .sidebar {
            background-color: #1a202c;
            border-right-color: #2d3748;
        }
        html:not(.dark) .sidebar {
            background-color: #ffffff;
            border-right-color: #e2e8f0;
        }
        html.dark .sidebar a {
            color: #a0aec0;
        }
        html.dark .sidebar a:hover {
            background-color: #2d3748;
            color: #ffffff;
        }
        html:not(.dark) .sidebar a {
            color: #4a5568;
        }
        html:not(.dark) .sidebar a:hover {
            background-color: #edf2f7;
            color: #2d3748;
        }
        #themeToggle {
            transition: background-color 0.5s ease-in-out, color 0.5s ease-in-out, box-shadow 0.5s ease-in-out;
        }

        .sidebar {
            width: 256px;
            transition: width 0.3s ease-in-out;
            flex-shrink: 0;
        }
        .sidebar.minimized {
            width: 64px;
        }
        .sidebar.minimized .sidebar-text {
            display: none;
        }
        .sidebar.minimized .sidebar-icon {
            margin-right: 0 !important;
            width: 24px;
            height: 24px;
        }
        .sidebar.minimized .sidebar-menu-item {
            justify-content: center;
            padding-left: 0;
            padding-right: 0;
        }
        .sidebar.minimized .sidebar-dropdown-icon {
            display: none;
        }
        .sidebar.minimized .sidebar-header {
            visibility: hidden;
            white-space: nowrap;
            overflow: hidden;
            width: 0;
            padding-left: 0;
            padding-right: 0;
        }
        .sidebar.minimized .sidebar-toggle-button {
            justify-content: center;
        }
        .sidebar.minimized .school-logo {
            margin-right: 0 !important;
            width: 40px;
            height: 40px;
        }
        .sidebar.minimized .school-name {
            display: none;
        }


        .sidebar.minimized [data-tooltip]:hover:after {
            content: attr(data-tooltip);
            position: absolute;
            left: 70px;
            top: 50%;
            transform: translateY(-50%);
            background-color: #333;
            color: #fff;
            padding: 5px 10px;
            border-radius: 4px;
            white-space: nowrap;
            z-index: 999;
            opacity: 1;
            transition: opacity 0.2s ease;
        }
        .sidebar.minimized [data-tooltip]:after {
            opacity: 0;
            pointer-events: none;
        }
    </style>
</head>
<body class="flex min-h-screen">

    <aside id="sidebar" class="sidebar w-64 p-5 border-r shadow-lg flex flex-col justify-between transition-colors duration-500 relative">
        <div>
            <div class="flex items-center justify-between mb-8">
                <div class="flex items-center sidebar-header">
                    <img src="<?php echo $logo_sekolah_path; ?>" alt="Logo Sekolah" class="school-logo w-12 h-12 object-contain mr-3 rounded-md" onerror="this.onerror=null;this.src='https://placehold.co/60x60/B0E0E6/000000?text=LOGO';">
                    <span class="text-xl font-bold text-blue-600 dark:text-blue-400 school-name"><?php echo $nama_sekolah_display; ?></span>
                </div>
                <button id="sidebarToggle" class="p-2 rounded-full hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-toggle-button">
                    <svg class="w-6 h-6 sidebar-toggle-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
            <nav>
                <ul class="space-y-1">
                    <li>
                        <a href="admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Dashboard">
                            <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg>
                            <span class="sidebar-text">Dashboard</span>
                        </a>
                    </li>
                    <li class="relative">
                        <a href="#" id="manajemenPenggunaDropdownToggle" class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Manajemen Pengguna">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h-5v-9H4L12 3l8 8h-8v9z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 11c-2.209 0-4-1.791-4-4s1.791-4 4-4 4 1.791 4 4-1.791 4-4 4zM12 13a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                                <span class="sidebar-text">Manajemen Pengguna</span>
                            </div>
                            <svg id="dropdownArrow" class="w-4 h-4 sidebar-dropdown-icon transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </a>
                        <ul id="manajemenPenggunaSubmenu" class="pl-8 mt-1 space-y-1 hidden">
                            <li>
                                <a href="daftarsiswa.php" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Lihat Semua Pengguna">
                                    <span class="sidebar-text">Lihat Semua</span>
                                </a>
                            </li>
                            <li>
                                <a href="#" class="flex items-center py-1 px-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Tambah Pengguna Baru">
                                    <span class="sidebar-text">Tambah Pengguna</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <a href="#" class="flex items-center py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Laporan">
                            <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.523 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5s3.332.477 4.5 1.253v13C19.832 18.523 18.246 18 16.5 18s-3.332.477-4.5 1.253"></path></svg>
                            <span class="sidebar-text">Laporan</span>
                        </a>
                    </li>
                    <li>
                        <a href="setting.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 sidebar-menu-item" data-tooltip="Pengaturan">
                            <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.525.322 1.018.673 1.505 1.01z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                            <span class="sidebar-text">Pengaturan</span>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
        <div class="mt-8">
            <a href="logout.php" class="flex items-center py-2 px-3 rounded-lg bg-red-500 hover:bg-red-600 text-white transition-colors duration-200 sidebar-menu-item" data-tooltip="Logout">
                <svg class="w-5 h-5 mr-3 sidebar-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
                <span class="sidebar-text">Logout</span>
            </a>
        </div>
    </aside>

    <main id="mainContent" class="flex-1 p-10 transition-all duration-300">
        <div class="absolute top-4 right-4 z-10">
            <button id="themeToggle" class="p-2 rounded-full bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-white shadow-md">
                <svg class="w-6 h-6 sun-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h1M3 12h1m15.325-7.757l-.707-.707M4.343 19.657l-.707-.707m12.728 0l-.707.707M6.343 6.343l-.707-.707"></path>
                </svg>
                <svg class="w-6 h-6 moon-icon hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9 9 0 008.354-5.646z"></path>
                </svg>
            </button>
        </div>

        <h1 class="text-4xl font-extrabold mb-8 text-day-mode-black dark:text-white">Pengaturan Sekolah</h1>

        <div class="glass-effect p-8 rounded-lg shadow-xl mb-8">
            <?php if (!empty($statusMessage)): ?>
                <div class="mb-4 p-3 rounded-lg text-sm <?php echo $messageType === 'success' ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'; ?>">
                    <?php echo $statusMessage; ?>
                </div>
            <?php endif; ?>

            <form action="setting.php" method="POST" enctype="multipart/form-data">
                <div class="mb-4">
                    <label for="nama_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">Nama Sekolah:</label>
                    <input
                        type="text"
                        id="nama_sekolah"
                        name="nama_sekolah"
                        value="<?php echo htmlspecialchars($settings['nama_sekolah']); ?>"
                        class="shadow appearance-none border rounded-lg w-full py-2 px-3 text-day-mode-black dark:text-gray-200 dark:bg-gray-700 dark:border-gray-600 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                        placeholder="Masukkan nama sekolah"
                        required
                    >
                </div>

                <div class="mb-4">
                    <label for="alamat_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">Alamat:</label>
                    <textarea
                        id="alamat_sekolah"
                        name="alamat_sekolah"
                        rows="3"
                        class="shadow appearance-none border rounded-lg w-full py-2 px-3 text-day-mode-black dark:text-gray-200 dark:bg-gray-700 dark:border-gray-600 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                        placeholder="Masukkan alamat sekolah"
                    ><?php echo htmlspecialchars($settings['alamat_sekolah']); ?></textarea>
                </div>

                <div class="mb-6">
                    <label for="logo_sekolah" class="block text-day-mode-black dark:text-gray-300 text-sm font-semibold mb-2">Logo Sekolah:</label>
                    <input
                        type="file"
                        id="logo_sekolah"
                        name="logo_sekolah"
                        accept="image/*"
                        class="block w-full text-sm text-day-mode-black dark:text-gray-300
                            file:mr-4 file:py-2 file:px-4
                            file:rounded-full file:border-0
                            file:text-sm file:font-semibold
                            file:bg-blue-50 file:text-blue-700
                            hover:file:bg-blue-100"
                    >
                    <input type="hidden" name="current_logo" value="<?php echo htmlspecialchars($settings['logo_sekolah']); ?>">
                    <?php if (!empty($settings['logo_sekolah'])): ?>
                        <div class="mt-4 flex items-center space-x-4">
                            <p class="text-sm text-gray-600 dark:text-gray-400">Logo Saat Ini:</p>
                            <img src="<?php echo $uploadDir . htmlspecialchars($settings['logo_sekolah']); ?>" alt="Logo Sekolah" class="w-24 h-24 object-contain rounded-lg border border-gray-300 dark:border-gray-600">
                            <label class="inline-flex items-center text-sm text-red-600 dark:text-red-400 cursor-pointer">
                                <input type="checkbox" name="remove_logo" value="true" class="form-checkbox h-4 w-4 text-red-600">
                                <span class="ml-2">Hapus Logo</span>
                            </label>
                        </div>
                    <?php else: ?>
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-2">Belum ada logo yang diatur.</p>
                    <?php endif; ?>
                </div>

                <div class="flex items-center justify-between">
                    <button
                        type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition duration-300 w-full"
                    >
                        Simpan Pengaturan
                    </button>
                </div>
            </form>
        </div>

        <div class="text-center mt-10">
            <img src="digipas.png" alt="Logo Digipas.id" class="mx-auto mb-2 w-16 h-auto" onerror="this.onerror=null;this.src='https://placehold.co/64x16/AAAAAA/FFFFFF?text=Logo+Error';">
            <p class="text-sm text-gray-600 dark:text-gray-400">
                Powered by: digipas.id &copy; <span id="currentYear"></span>
            </p>
        </div>
    </main>

    <script>
        const themeToggle = document.getElementById('themeToggle');
        const htmlElement = document.documentElement;
        const sunIcon = document.querySelector('.sun-icon');
        const moonIcon = document.querySelector('.moon-icon');
        
        function applyTheme(theme) {
            if (theme === 'dark') {
                htmlElement.classList.add('dark');
                sunIcon.classList.add('hidden');
                moonIcon.classList.remove('hidden');
            } else {
                htmlElement.classList.remove('dark');
                sunIcon.classList.remove('hidden');
                moonIcon.classList.add('hidden');
            }
        }

        const savedTheme = localStorage.getItem('theme');
        if (savedTheme) {
            applyTheme(savedTheme);
        } else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            applyTheme('dark');
        } else {
            applyTheme('light');
        }

        themeToggle.addEventListener('click', () => {
            if (htmlElement.classList.contains('dark')) {
                applyTheme('light');
                localStorage.setItem('theme', 'light');
            } else {
                localStorage.setItem('theme', 'dark');
                applyTheme('dark');
            }
        });

        document.getElementById('currentYear').textContent = new Date().getFullYear();

        const manajemenPenggunaDropdownToggle = document.getElementById('manajemenPenggunaDropdownToggle');
        const manajemenPenggunaSubmenu = document.getElementById('manajemenPenggunaSubmenu');
        const dropdownArrow = document.getElementById('dropdownArrow');

        if (manajemenPenggunaDropdownToggle && manajemenPenggunaSubmenu && dropdownArrow) {
            manajemenPenggunaDropdownToggle.addEventListener('click', (e) => {
                e.preventDefault();
                manajemenPenggunaSubmenu.classList.toggle('hidden');
                dropdownArrow.classList.toggle('rotate-180');
            });
        }

        const sidebarToggle = document.getElementById('sidebarToggle');
        const sidebar = document.getElementById('sidebar');
        const sidebarToggleIcon = document.querySelector('.sidebar-toggle-icon');
        
        function initializeSidebar() {
            const isMinimized = localStorage.getItem('sidebarMinimized') === 'true';
            if (isMinimized) {
                sidebar.classList.add('minimized');
                sidebarToggleIcon.setAttribute('d', 'M9 5l7 7-7 7');
            } else {
                sidebar.classList.remove('minimized');
                sidebarToggleIcon.setAttribute('d', 'M4 6h16M4 12h16M4 18h16');
            }
            sidebarToggle.addEventListener('click', toggleSidebar);
        }

        function toggleSidebar() {
            const isCurrentlyMinimized = sidebar.classList.contains('minimized');
            if (isCurrentlyMinimized) {
                sidebar.classList.remove('minimized'); // Memperbaiki logika: hapus kelas 'minimized' untuk memperluas
                sidebarToggleIcon.setAttribute('d', 'M4 6h16M4 12h16M4 18h16'); // Ubah ikon ke hamburger
                localStorage.setItem('sidebarMinimized', 'false'); // Perbarui status di local storage
            } else {
                sidebar.classList.add('minimized'); // Tambah kelas 'minimized' untuk menyusut
                sidebarToggleIcon.setAttribute('d', 'M9 5l7 7-7 7'); // Ubah ikon ke chevron kanan
                localStorage.setItem('sidebarMinimized', 'true'); // Perbarui status di local storage
            }
        }
        
        document.addEventListener('DOMContentLoaded', initializeSidebar);
    </script>
</body>
</html>
