<?php
// Konfigurasi Database (Ganti dengan detail database Anda)
$servername = "localhost"; // Ganti jika database Anda di host lain
$username = "smpm6723_scan";         // Ganti dengan username database Anda
$password = "hayangmodol2";           // Ganti dengan password database Anda
$dbname = "smpm6723_scan"; // Ganti dengan nama database Anda

// Buat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Periksa koneksi
if ($conn->connect_error) {
    die("Koneksi database gagal: " . $conn->connect_error);
}

// Fungsi untuk membersihkan input
function sanitize_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// Daftar kelas yang tersedia (harus sama dengan di daftarsiswa.php)
$available_classes = [
    "X1", "X2", "X3", "X4", "X5",
    "XI IPS1", "XI IPS2", "XI IPS3", "XI IPS4"
];

$students = [];

// Ambil SEMUA data siswa dari database karena filter akan dilakukan secara real-time di JavaScript
// Jika Anda memiliki kolom 'foto_path' di database, tambahkan di sini:
// $sql = "SELECT id, qr_code_content, nama, kelas, nomor_wa, foto_path FROM students ORDER BY kelas ASC, nama ASC";
$sql = "SELECT id, qr_code_content, nama, kelas, nomor_wa FROM students ORDER BY kelas ASC, nama ASC";

$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            // Jika Anda tidak memiliki kolom foto_path di database, gunakan placeholder ini:
            $row['foto_path'] = 'https://placehold.co/50x65/abcdef/ffffff?text=Foto'; // Placeholder foto siswa (lebih kecil)
            // Jika Anda memiliki kolom foto_path di database, gunakan ini jika kolom foto_path ada:
            // $row['foto_path'] = htmlspecialchars($row['foto_path']);
            $students[] = $row;
        }
    }
    $stmt->close();
} else {
    // Tangani kesalahan persiapan statement
    error_log("Gagal menyiapkan statement untuk mengambil siswa: " . $conn->error);
}

$conn->close();

// Tanggal hari ini untuk footer kartu
$today_date = date('d F Y');
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Kartu Siswa</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- QRious library for client-side QR code generation -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f2f5;
            color: #333;
        }
        .student-card-container {
            display: flex; /* Menggunakan flexbox untuk penataan kartu */
            flex-wrap: wrap; /* Mengizinkan kartu untuk melipat ke baris berikutnya */
            justify-content: center; /* Pusatkan kartu secara horizontal */
            gap: 1.5rem; /* Jarak antar kartu */
            padding: 1.5rem;
        }
        .student-card {
            background-color: white;
            border: 1px solid #e2e8f0; /* slate-200 */
            border-radius: 0.75rem; /* rounded-xl */
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06); /* shadow-lg */
            padding: 0.6rem; /* Padding lebih kecil untuk ruang horizontal */
            display: flex;
            flex-direction: row; /* Kunci: tata letak horizontal */
            align-items: flex-start; /* Sejajarkan item ke atas */
            width: 4in;   /* Target width for display and print */
            height: 2.5in; /* Target height for display and print */
            overflow: hidden; /* Sembunyikan overflow */
            position: relative; /* Untuk penentuan posisi absolut (jika diperlukan di masa mendatang) */
        }

        .card-left { /* Bagian kiri: Logo, Nama & Alamat Sekolah, Foto Siswa */
            display: flex;
            flex-direction: column;
            align-items: center; /* Pusatkan secara horizontal */
            flex-shrink: 0; /* Jangan ciutkan bagian ini */
            padding-right: 0.5rem;
            border-right: 1px dashed #e2e8f0; /* Garis pemisah opsional */
            width: 100px; /* Lebar tetap untuk kolom kiri */
        }
        .card-header-small {
            display: flex;
            flex-direction: column; /* Ubah menjadi kolom agar logo dan info sekolah vertikal */
            align-items: center; /* Pusatkan item header secara horizontal */
            gap: 0.1rem; /* Sangat kecil */
            margin-bottom: 0.5rem;
            width: 100%;
            text-align: center;
        }
        .school-logo {
            width: 35px; /* Ukuran logo */
            height: 35px;
            object-fit: contain;
            border-radius: 0.25rem;
            margin-bottom: 0.2rem; /* Spasi bawah logo */
        }
        .school-info {
            flex-grow: 1;
        }
        .school-name {
            font-weight: 700;
            font-size: 0.7rem; /* Adjusted for smaller space */
            color: #1a202c;
            line-height: 1.1;
        }
        .school-address {
            font-size: 0.6rem; /* Adjusted for smaller space */
            color: #4a5568;
        }
        .student-photo {
            width: 50px; /* Lebar foto siswa (lebih kecil) */
            height: 65px; /* Tinggi foto siswa (rasio potret, lebih kecil) */
            object-fit: cover;
            border-radius: 0.25rem;
            border: 1px solid #e2e8f0;
            margin-top: 0.5rem;
        }

        .card-right { /* Bagian kanan: Detail Siswa, QR Code, Tanda Tangan */
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            flex-grow: 1;
            padding-left: 0.5rem;
            text-align: left; /* Biarkan teks detail sejajar kiri */
        }
        .student-details-group {
            margin-bottom: 0.25rem;
        }
        .detail-label {
            font-size: 0.65rem; /* Disesuaikan */
            font-weight: 600;
            color: #4a5568;
            line-height: 1.1;
            margin-bottom: 0;
        }
        .detail-value {
            font-size: 0.75rem; /* Disesuaikan */
            color: #1a202c;
            margin-bottom: 0.1rem; /* Disesuaikan */
            line-height: 1.1;
        }

        /* Gaya untuk Nama Siswa yang Lebih Menonjol */
        .student-name-prominent {
            font-size: 1.05rem; /* Membuat nama lebih besar */
            font-weight: 800; /* Membuat nama lebih tebal */
            color: #000; /* Warna hitam penuh untuk menonjol */
            margin-bottom: 0.2rem; /* Tambahkan sedikit spasi di bawah nama */
            line-height: 1.2;
        }

        .qr-and-signature-area {
            display: flex;
            align-items: flex-end; /* Sejajarkan QR dan TTD ke bawah */
            justify-content: space-between;
            width: 100%;
            margin-top: 0.5rem; /* Spasi di atas area ini */
        }
        .qr-canvas {
            width: 75px !important; /* Ukuran QR lebih besar */
            height: 75px !important;
            border: 1px solid #ccc;
            border-radius: 0.25rem;
            flex-shrink: 0;
        }
        .signature-block {
            text-align: center;
            font-size: 0.55rem; /* Teks lebih kecil untuk blok tanda tangan */
            line-height: 1;
            flex-grow: 1;
            margin-left: 0.5rem;
            padding-top: 0.1rem; /* Beri sedikit padding atas */
        }
        .sig-title {
            font-weight: 600;
            margin-bottom: 0.05rem; /* Sangat kecil */
        }
        .principal-signature {
            width: 45px; /* Ukuran gambar tanda tangan lebih kecil */
            height: 20px;
            object-fit: contain;
            margin: 0.1rem auto; /* Pusatkan secara horizontal, disesuaikan */
            display: block;
        }
        .principal-name {
            font-weight: 600;
            font-size: 0.6rem; /* Disesuaikan */
            margin-top: 0.05rem;
        }

        /* Gaya Khusus Cetak: Minimal overrides untuk mencocokkan layar */
        @media print {
            body {
                background-color: white;
                margin: 0;
                padding: 0;
            }
            .no-print {
                display: none; /* Sembunyikan elemen yang tidak perlu dicetak */
            }
            .student-card-container {
                display: flex;
                flex-wrap: wrap;
                justify-content: flex-start;
                align-content: flex-start;
                gap: 0.75rem; /* Jarak antar kartu saat dicetak */
                padding: 0.25in; /* Padding lebih kecil untuk cetak */
            }
            .student-card {
                /* Dimensi ini sudah diatur dalam mode non-cetak, jadi tidak perlu override kecuali ada penskalaan cetak khusus */
                /* width: 4in; height: 2.5in; */
                box-shadow: none;
                border: 1px solid #000; /* Border jelas untuk cetak */
                page-break-inside: avoid; /* Hindari memisahkan kartu di antara halaman */
                margin-bottom: 0.5rem; /* Margin konsisten */
                /* padding: 0.4rem; */ /* Pertahankan padding konsisten dengan layar atau sesuaikan jika perlu */
            }
            @page {
                size: A4 landscape;
                margin: 0.5in; /* Pastikan margin cukup untuk dialog cetak browser */
            }
            /* Ukuran font sebagian besar diwarisi. Sesuaikan hanya jika perlu untuk keterbacaan cetak. */
            /* Sebagian besar override ukuran font cetak eksplisit dihapus untuk mendorong konsistensi */
        }
    </style>
</head>
<body class="bg-gradient-to-br from-blue-50 to-purple-100 min-h-screen">
    <div class="max-w-7xl mx-auto py-8">
        <h1 class="text-3xl font-extrabold text-center text-gray-800 mb-8 no-print">Kartu Siswa Siap Cetak</h1>
        <div class="text-center mb-8 no-print">
            <button onclick="window.print()" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded-lg shadow-md transition duration-300 ease-in-out focus:outline-none focus:ring-4 focus:ring-blue-500 focus:ring-opacity-50">
                <svg class="w-5 h-5 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17l2 2m-2-2l-2-2m2 2l-2 2m2-2h-4V8h-4V4h4V0h4v4h4v4h-4v4h4v4h-4zM7 7h-2V3H7v4zM3 3h-2V0H3v3zM1 1h-1V0h1v1z"></path></svg>
                Cetak Halaman Ini
            </button>
            <a href="daftarsiswa.php" class="ml-4 bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-6 rounded-lg shadow-md transition duration-300 ease-in-out focus:outline-none focus:ring-4 focus:ring-gray-400 focus:ring-opacity-50">
                Kembali
            </a>
        </div>

        <!-- Filter Controls for Print -->
        <div class="filter-controls no-print mb-8 p-4 bg-gray-100 rounded-lg shadow-inner">
            <h2 class="text-xl font-bold text-gray-800 mb-4">Opsi Cetak Filter</h2>
            <div class="flex flex-wrap items-end gap-4">
                <div class="flex-grow">
                    <label for="filterKelas" class="block text-gray-700 text-sm font-bold mb-1">Cetak per Kelas:</label>
                    <select id="filterKelas" class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-400">
                        <option value="">Semua Kelas</option>
                        <?php foreach ($available_classes as $class_option): ?>
                            <option value="<?php echo htmlspecialchars($class_option); ?>"><?php echo htmlspecialchars($class_option); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="flex-grow">
                    <label for="filterId" class="block text-gray-700 text-sm font-bold mb-1">Cari Nama/ID Siswa:</label>
                    <input type="text" id="filterId" placeholder="Cari Nama/ID Siswa..." class="shadow-sm appearance-none border rounded-lg w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-400">
                </div>
                <button id="resetFilterPrint" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-300 ease-in-out focus:outline-none focus:ring-4 focus:ring-gray-400 focus:ring-opacity-50">
                    Reset Filter
                </button>
            </div>
        </div>

        <?php if (empty($students)): ?>
            <p class="text-center text-gray-600 text-lg" id="noStudentsFound">Tidak ada data siswa yang ditemukan untuk dicetak.</p>
        <?php else: ?>
            <div class="student-card-container" id="studentCardContainer">
                <?php foreach ($students as $student): ?>
                    <div class="student-card" 
                         data-id="<?php echo htmlspecialchars($student['id']); ?>"
                         data-nama="<?php echo htmlspecialchars($student['nama']); ?>"
                         data-kelas="<?php echo htmlspecialchars($student['kelas']); ?>">
                        <!-- Bagian Kiri Kartu: Logo Sekolah & Foto Siswa -->
                        <div class="card-left">
                            <div class="card-header-small">
                                <img src="https://placehold.co/40x40/cccccc/333333?text=Logo" alt="Logo Sekolah" class="school-logo">
                                <div class="school-info">
                                    <p class="school-name">SMP Pasundan 8 Bandung</p>
                                    <p class="school-address">Jl. Kautamaan Istri No. 10, Bandung</p>
                                </div>
                            </div>
                            <img src="<?php echo $student['foto_path']; ?>" alt="Foto Siswa <?php echo htmlspecialchars($student['nama']); ?>" class="student-photo">
                        </div>
                        
                        <!-- Bagian Kanan Kartu: Data Siswa, QR Code & Tanda Tangan -->
                        <div class="card-right">
                            <div class="student-details-group">
                                <p class="detail-label">Nama:</p><p class="detail-value student-name-prominent"><?php echo htmlspecialchars($student['nama']); ?></p>
                                <p class="detail-label">ID:</p><p class="detail-value"><?php echo htmlspecialchars($student['id']); ?></p>
                                <p class="detail-label">Kelas:</p><p class="detail-value"><?php echo htmlspecialchars($student['kelas']); ?></p>
                                <?php if (!empty($student['nomor_wa'])): ?>
                                    <p class="detail-label">No. WA:</p><p class="detail-value"><?php echo htmlspecialchars($student['nomor_wa']); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="qr-and-signature-area">
                                <canvas class="qr-canvas" id="qr-<?php echo htmlspecialchars($student['id']); ?>" width="90" height="90"></canvas>
                                <div class="signature-block">
                                    <p class="sig-title">Kepala Sekolah,</p>
                                    <img src="https://placehold.co/60x30/cccccc/333333?text=TTD" alt="Tanda Tangan Kepala Sekolah" class="principal-signature">
                                    <p class="principal-name">(Nama Lengkap Kepala Sekolah)</p>
                                </div>
                            </div>
                        </div>
                        <!-- Hidden input to pass QR content to JavaScript -->
                        <input type="hidden" class="qr-content-data" data-id="<?php echo htmlspecialchars($student['id']); ?>" value="<?php echo htmlspecialchars($student['qr_code_content']); ?>">
                    </div>
                <?php endforeach; ?>
            </div>
            <p class="text-center text-gray-600 text-lg hidden" id="noStudentsFound">Tidak ada data siswa yang ditemukan untuk kriteria filter ini.</p>
        <?php endif; ?>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const qrContentElements = document.querySelectorAll('.qr-content-data');
            
            qrContentElements.forEach(input => {
                const studentId = input.dataset.id;
                const qrContent = input.value;
                const canvasId = `qr-${studentId}`;
                const canvasElement = document.getElementById(canvasId);

                if (canvasElement) {
                    new QRious({
                        element: canvasElement,
                        value: qrContent,
                        size: 90 // Ukuran QR code dalam piksel
                    });
                }
            });

            // Logika untuk kontrol filter cetak real-time
            const filterKelasDropdown = document.getElementById('filterKelas');
            const filterIdInput = document.getElementById('filterId'); // Mengganti nama ID karena sekarang untuk pencarian
            const studentCards = document.querySelectorAll('.student-card');
            const noStudentsFoundMessage = document.getElementById('noStudentsFound');
            const resetButton = document.getElementById('resetFilterPrint');

            function applyCardFilters() {
                const selectedClass = filterKelasDropdown.value;
                const searchTerm = filterIdInput.value.toLowerCase().trim(); // Case-insensitive search

                let visibleCardsCount = 0;
                studentCards.forEach(card => {
                    const studentClass = card.dataset.kelas;
                    const studentId = card.dataset.id.toLowerCase();
                    const studentName = card.dataset.nama.toLowerCase();

                    const matchesClass = (selectedClass === '' || studentClass === selectedClass);
                    const matchesSearch = (searchTerm === '' || studentId.includes(searchTerm) || studentName.includes(searchTerm));

                    if (matchesClass && matchesSearch) {
                        card.style.display = 'flex'; // Tampilkan kartu
                        visibleCardsCount++;
                    } else {
                        card.style.display = 'none'; // Sembunyikan kartu
                    }
                });

                // Tampilkan pesan jika tidak ada kartu yang cocok
                if (visibleCardsCount === 0) {
                    noStudentsFoundMessage.classList.remove('hidden');
                } else {
                    noStudentsFoundMessage.classList.add('hidden');
                }
            }

            // Panggil filter saat DOM dimuat untuk menerapkan filter awal (jika ada dari URL sebelumnya)
            // Namun, karena PHP tidak lagi memfilter, ini akan menampilkan semua secara default.
            // applyCardFilters(); // Tidak perlu lagi karena tidak ada filter dari URL yang perlu diterapkan di sisi klien saat load

            // Event listener untuk dropdown filter kelas (saat berubah)
            filterKelasDropdown.addEventListener('change', applyCardFilters);

            // Event listener untuk input pencarian (saat keyup)
            filterIdInput.addEventListener('keyup', applyCardFilters);

            // Event listener untuk tombol reset
            resetButton.addEventListener('click', () => {
                filterKelasDropdown.value = ''; // Reset dropdown
                filterIdInput.value = ''; // Reset input pencarian
                applyCardFilters(); // Terapkan filter kosong (tampilkan semua)
            });

            // Pastikan filter diterapkan jika ada parameter di URL saat pertama kali halaman dimuat
            const urlParams = new URLSearchParams(window.location.search);
            const initialKelas = urlParams.get('kelas');
            const initialId = urlParams.get('id'); // Ini akan digunakan sebagai nilai awal untuk input pencarian

            if (initialKelas) {
                filterKelasDropdown.value = initialKelas;
            }
            if (initialId) {
                filterIdInput.value = initialId;
            }
            // Setelah mengatur nilai awal, panggil applyCardFilters untuk menerapkan filter tersebut
            applyCardFilters();
        });
    </script>
</body>
</html>
