<?php
session_start();

// Simulasi Cek Autentikasi Admin
// Dalam aplikasi nyata, Anda harus memiliki tabel 'users' atau 'admins' di database
// dan memeriksa kredensial di halaman login admin (misal: admin_login.php).
// Untuk demo ini, kita asumsikan admin sudah login jika ada sesi 'admin_logged_in'.
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    // Redirect ke halaman login admin jika belum login
    // header("Location: admin_login.php");
    // exit();
    // Untuk tujuan demo, set session ini jika Anda ingin langsung mencoba
    $_SESSION['admin_logged_in'] = true;
    $_SESSION['admin_name'] = 'Administrator';
}

$admin_name = htmlspecialchars($_SESSION['admin_name'] ?? 'Admin');

// Tentukan halaman yang akan dimuat di iframe
$content_page = $_GET['page'] ?? 'home'; // Default ke 'home'

// Mapping halaman ke file yang sesuai
$page_map = [
    'home' => 'admin_home.html', // Buat file ini atau ganti dengan konten admin utama
    'pelajaran' => 'soal_pelajaran.php', // Placeholder
    'daftar_soal' => 'soal_daftar.php', // Placeholder
    'import_soal_word' => 'soal_import_word.php', // Placeholder
    'import_soal_excel' => 'soal_import_excel.php', // Placeholder
    'daftar_peserta' => 'daftarsiswa.php', // MENGARAHKAN KE daftarsiswa.php
    'import_daftar_peserta' => 'peserta_import.php', // Placeholder
    'cetak_kartu_ujian' => 'peserta_cetak_kartu.php', // Placeholder
    'logout' => 'admin_logout.php' // Akan menangani logout admin
];

$iframe_src = $page_map[$content_page] ?? $page_map['home'];

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar {
            width: 280px; /* Lebar sidebar tetap */
            flex-shrink: 0;
            transition: transform 0.3s ease-in-out;
            transform: translateX(0);
        }
        @media (max-width: 768px) { /* md breakpoint */
            .sidebar {
                transform: translateX(-100%); /* Sembunyikan sidebar di mobile */
                position: fixed;
                height: 100%;
                z-index: 100;
            }
            .sidebar.active {
                transform: translateX(0); /* Tampilkan sidebar di mobile */
            }
            .content-area {
                margin-left: 0 !important; /* Hapus margin di mobile */
            }
            .overlay {
                display: block; /* Tampilkan overlay di mobile saat sidebar aktif */
            }
        }
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 90;
            display: none; /* Sembunyikan secara default */
        }
        .nav-link.active {
            background-color: #4338ca; /* indigo-700 */
            color: #ffffff;
            font-weight: 600;
        }
        .dropdown-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out;
        }
        .dropdown-menu.active {
            max-height: 500px; /* Sesuaikan dengan tinggi maksimum yang mungkin dibutuhkan */
        }
        .iframe-container {
            width: 100%;
            height: calc(100vh - 64px); /* Full height minus header height */
            border: none;
        }
    </style>
</head>
<body class="flex bg-gray-100 min-h-screen">

    <!-- Overlay for mobile sidebar -->
    <div id="sidebarOverlay" class="overlay md:hidden"></div>

    <!-- Sidebar -->
    <aside id="sidebar" class="sidebar bg-indigo-800 text-white p-6 shadow-lg md:relative md:transform-none">
        <div class="flex items-center justify-between md:justify-center mb-8">
            <h2 class="text-2xl font-bold">Admin Panel</h2>
            <button id="closeSidebarBtn" class="text-white md:hidden">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
            </button>
        </div>
        
        <nav>
            <ul class="space-y-2">
                <li>
                    <a href="admin_dashboard.php?page=home" class="nav-link flex items-center p-3 rounded-lg hover:bg-indigo-700 transition duration-200">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg>
                        Home
                    </a>
                </li>
                
                <!-- Menu SOAL -->
                <li>
                    <button class="dropdown-toggle flex items-center justify-between w-full p-3 rounded-lg hover:bg-indigo-700 transition duration-200">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path></svg>
                            SOAL
                        </span>
                        <svg class="w-4 h-4 transform transition-transform duration-200 rotate-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                    </button>
                    <ul class="dropdown-menu ml-4 mt-1 space-y-1 bg-indigo-700 rounded-lg">
                        <li><a href="admin_dashboard.php?page=pelajaran" class="nav-link block p-3 rounded-lg hover:bg-indigo-600 transition duration-200">Pelajaran</a></li>
                        <li><a href="admin_dashboard.php?page=daftar_soal" class="nav-link block p-3 rounded-lg hover:bg-indigo-600 transition duration-200">Daftar Soal</a></li>
                        <li><a href="admin_dashboard.php?page=import_soal_word" class="nav-link block p-3 rounded-lg hover:bg-indigo-600 transition duration-200">Impor Soal Word</a></li>
                        <li><a href="admin_dashboard.php?page=import_soal_excel" class="nav-link block p-3 rounded-lg hover:bg-indigo-600 transition duration-200">Impor Soal Excel</a></li>
                    </ul>
                </li>

                <!-- Menu Data Peserta -->
                <li>
                    <button class="dropdown-toggle flex items-center justify-between w-full p-3 rounded-lg hover:bg-indigo-700 transition duration-200">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H2v-2a3 3 0 005.356-1.857M17 20v-2c0-.134.02-.265.059-.395m0 0A2 2 0 0118 10V6a2 2 0 00-2-2H8a2 2 0 00-2 2v4a2 2 0 01-.059.395M18 8a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                            Data Peserta
                        </span>
                        <svg class="w-4 h-4 transform transition-transform duration-200 rotate-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                    </button>
                    <ul class="dropdown-menu ml-4 mt-1 space-y-1 bg-indigo-700 rounded-lg">
                        <li><a href="admin_dashboard.php?page=daftar_peserta" class="nav-link block p-3 rounded-lg hover:bg-indigo-600 transition duration-200">Daftar Peserta</a></li>
                        <li><a href="admin_dashboard.php?page=import_daftar_peserta" class="nav-link block p-3 rounded-lg hover:bg-indigo-600 transition duration-200">Impor Daftar Peserta</a></li>
                        <li><a href="admin_dashboard.php?page=cetak_kartu_ujian" class="nav-link block p-3 rounded-lg hover:bg-indigo-600 transition duration-200">Cetak Kartu Ujian</a></li>
                    </ul>
                </li>

                <li>
                    <a href="admin_dashboard.php?page=logout" class="flex items-center p-3 rounded-lg hover:bg-red-600 transition duration-200 bg-red-700">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
                        Logout
                    </a>
                </li>
            </ul>
        </nav>
    </aside>

    <!-- Main Content Area -->
    <div class="flex-1 flex flex-col">
        <!-- Header -->
        <header class="bg-white p-4 shadow-md flex justify-between items-center z-50">
            <button id="openSidebarBtn" class="md:hidden text-gray-700">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
            </button>
            <h1 class="text-xl font-semibold text-gray-800">Selamat Datang, <?php echo $admin_name; ?>!</h1>
            <div class="hidden sm:block">
                <!-- Bisa ditambahkan info atau profil admin di sini -->
            </div>
        </header>

        <!-- Content Iframe -->
        <main class="flex-1 overflow-auto bg-gray-50 p-4">
            <iframe id="contentFrame" src="<?php echo htmlspecialchars($iframe_src); ?>" class="iframe-container rounded-lg shadow-inner"></iframe>
        </main>
    </div>

    <script>
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        const openSidebarBtn = document.getElementById('openSidebarBtn');
        const closeSidebarBtn = document.getElementById('closeSidebarBtn');
        const dropdownToggles = document.querySelectorAll('.dropdown-toggle');
        const contentFrame = document.getElementById('contentFrame');
        const navLinks = document.querySelectorAll('.nav-link');

        // Toggle sidebar for mobile
        openSidebarBtn.addEventListener('click', () => {
            sidebar.classList.add('active');
            sidebarOverlay.style.display = 'block';
        });

        closeSidebarBtn.addEventListener('click', () => {
            sidebar.classList.remove('active');
            sidebarOverlay.style.display = 'none';
        });

        sidebarOverlay.addEventListener('click', () => {
            sidebar.classList.remove('active');
            sidebarOverlay.style.display = 'none';
        });

        // Toggle dropdown menus
        dropdownToggles.forEach(toggle => {
            toggle.addEventListener('click', () => {
                const dropdownMenu = toggle.nextElementSibling;
                const arrowIcon = toggle.querySelector('svg:last-child');
                dropdownMenu.classList.toggle('active');
                arrowIcon.classList.toggle('rotate-180');
            });
        });

        // Set active class on current nav link and load content in iframe
        function setActiveNavLink() {
            // Get the current 'page' parameter from the iframe's URL
            const iframeUrl = new URL(contentFrame.src);
            const currentPageParam = iframeUrl.searchParams.get('page'); // This will be null if no 'page' param

            // Determine the active link based on the 'page' parameter or 'home' as default
            // Also handle the case where iframe src directly matches a file like 'daftarsiswa.php'
            let activePageIdentifier = currentPageParam || (iframeUrl.pathname.includes('daftarsiswa.php') ? 'daftar_peserta' : 'home');

            navLinks.forEach(link => {
                const linkUrl = new URL(link.href);
                const linkPageParam = linkUrl.searchParams.get('page'); // This will be null if no 'page' param

                // Check if the link's 'page' param matches the active page identifier
                // Or if the link's href pathname directly matches a file like 'daftarsiswa.php' and the identifier is 'daftar_peserta'
                if (linkPageParam === activePageIdentifier || (linkUrl.pathname.includes('daftarsiswa.php') && activePageIdentifier === 'daftar_peserta')) {
                    link.classList.add('active');
                    // Expand parent dropdown if active link is inside it
                    let parentUl = link.closest('.dropdown-menu');
                    if (parentUl) {
                        parentUl.classList.add('active');
                        let parentToggle = parentUl.previousElementSibling;
                        if (parentToggle && parentToggle.classList.contains('dropdown-toggle')) {
                            parentToggle.querySelector('svg:last-child').classList.add('rotate-180');
                        }
                    }
                } else {
                    link.classList.remove('active');
                }
            });
        }

        // Call setActiveNavLink when iframe content loads
        contentFrame.onload = setActiveNavLink;

        // Initial active state set (for direct page load)
        document.addEventListener('DOMContentLoaded', setActiveNavLink);
    </script>
</body>
</html>
