<?php
session_start();
include 'koneksi.php';

// Cek akses admin
if (!isset($_SESSION['role'])) { 
    header("Location: login.php");
    exit;
}

// --- [BARU] AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; // Default jika db kosong

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            // Pastikan path ini sesuai dengan struktur folder Anda
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// --- 1. LOGIKA JENIS PELANGGARAN ---

// Tambah Pelanggaran
if (isset($_POST['tambah_pelanggaran'])) {
    $nama = mysqli_real_escape_string($koneksi, $_POST['nama_pelanggaran']);
    $poin = intval($_POST['poin']); // Pastikan angka
    
    $sql = "INSERT INTO jenis_pelanggaran (nama_pelanggaran, poin_pengurang) VALUES ('$nama', '$poin')";
    if (mysqli_query($koneksi, $sql)) {
        echo "<script>alert('Jenis pelanggaran berhasil ditambahkan!'); window.location='admin_jenispoin.php';</script>";
    } else {
        echo "<script>alert('Gagal: " . mysqli_error($koneksi) . "');</script>";
    }
}

// Edit Pelanggaran
if (isset($_POST['edit_pelanggaran'])) {
    $id   = $_POST['id_pelanggaran'];
    $nama = mysqli_real_escape_string($koneksi, $_POST['nama_pelanggaran']);
    $poin = intval($_POST['poin']);
    
    $sql = "UPDATE jenis_pelanggaran SET nama_pelanggaran='$nama', poin_pengurang='$poin' WHERE id='$id'";
    if (mysqli_query($koneksi, $sql)) {
        echo "<script>alert('Data pelanggaran berhasil diupdate!'); window.location='admin_jenispoin.php';</script>";
    }
}

// Hapus Pelanggaran
if (isset($_GET['hapus_pelanggaran'])) {
    $id = $_GET['hapus_pelanggaran'];
    $sql = "DELETE FROM jenis_pelanggaran WHERE id='$id'";
    if (mysqli_query($koneksi, $sql)) {
        echo "<script>alert('Data berhasil dihapus!'); window.location='admin_jenispoin.php';</script>";
    }
}


// --- 2. LOGIKA JENIS REWARD ---

// Tambah Reward
if (isset($_POST['tambah_reward'])) {
    $nama = mysqli_real_escape_string($koneksi, $_POST['nama_reward']);
    $poin = intval($_POST['poin']);
    
    $sql = "INSERT INTO jenis_reward (nama_reward, poin_bonus) VALUES ('$nama', '$poin')";
    if (mysqli_query($koneksi, $sql)) {
        echo "<script>alert('Jenis reward berhasil ditambahkan!'); window.location='admin_jenispoin.php?tab=reward';</script>";
    } else {
        echo "<script>alert('Gagal: " . mysqli_error($koneksi) . "');</script>";
    }
}

// Edit Reward
if (isset($_POST['edit_reward'])) {
    $id   = $_POST['id_reward'];
    $nama = mysqli_real_escape_string($koneksi, $_POST['nama_reward']);
    $poin = intval($_POST['poin']);
    
    $sql = "UPDATE jenis_reward SET nama_reward='$nama', poin_bonus='$poin' WHERE id='$id'";
    if (mysqli_query($koneksi, $sql)) {
        echo "<script>alert('Data reward berhasil diupdate!'); window.location='admin_jenispoin.php?tab=reward';</script>";
    }
}

// Hapus Reward
if (isset($_GET['hapus_reward'])) {
    $id = $_GET['hapus_reward'];
    $sql = "DELETE FROM jenis_reward WHERE id='$id'";
    if (mysqli_query($koneksi, $sql)) {
        echo "<script>alert('Data berhasil dihapus!'); window.location='admin_jenispoin.php?tab=reward';</script>";
    }
}

// Logika Tab Aktif (agar saat refresh tetap di tab yang sama)
$active_tab = isset($_GET['tab']) && $_GET['tab'] == 'reward' ? 'reward' : 'pelanggaran';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master Poin - Admin Panel</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    
    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
        .sidebar { min-height: 100vh; background: white; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .nav-link.active { background-color: #e8f5e9; color: #198754; font-weight: bold; border-left: 4px solid #198754; }
        .nav-link { color: #555; transition: 0.3s; }
        .nav-link:hover { background-color: #f8f9fa; color: #198754; }
        .nav-tabs .nav-link.active { background-color: #fff; border-bottom-color: #fff; color: #198754; font-weight: bold; }
        .tab-content { background: #fff; border: 1px solid #dee2e6; border-top: none; border-radius: 0 0 5px 5px; padding: 20px; }
        .badge-poin-red { background-color: #fee2e2; color: #dc2626; border: 1px solid #fecaca; }
        .badge-poin-green { background-color: #dcfce7; color: #16a34a; border: 1px solid #bbf7d0; }

        /* [BARU] Style untuk Logo di Sidebar */
        .sidebar-header {
            text-align: center;
            padding: 20px 10px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        .school-logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar d-none d-md-block p-0">
            
            <!-- [BARU] BAGIAN LOGO & NAMA SEKOLAH -->
            <div class="sidebar-header">
                <img src="<?= $logo_sekolah ?>" alt="Logo Sekolah" class="school-logo" onerror="this.onerror=null; this.src='https://via.placeholder.com/80?text=Logo';">
                <h6 class="fw-bold text-success m-0"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Admin Panel</small>
            </div>

            <ul class="nav flex-column px-2">
                <li class="nav-item"><a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li class="nav-item"><a href="admin_pelanggaran.php" class="nav-link"><i class="bi bi-pencil-square me-2"></i>Input Poin</a></li>
                <li class="nav-item"><a href="adminguru.php" class="nav-link"><i class="bi bi-person-workspace me-2"></i>Data Guru</a></li>
                <li class="nav-item"><a href="admin_jadwa.php" class="nav-link"><i class="bi bi-calendar-week me-2"></i>Admin Jadwal</a></li>
                <li class="nav-item"><a href="admin_jenispoin.php" class="nav-link active"><i class="bi bi-list-check me-2"></i>Jenis Pelanggaran</a></li>
                 <li class="nav-item"><a href="admin_laporanpelanggaran.php" class="nav-link"><i class="bi bi-file-earmark-text me-2"></i>Laporan</a></li>
                 <li class="nav-item"><a href="pengaturan_sekolah.php" class="nav-link"><i class="bi bi-gear me-2"></i>Pengaturan Sekolah</a></li>
                <li class="nav-item"><a href="logout.php" class="nav-link text-danger mt-3"><i class="bi bi-box-arrow-left me-2"></i>Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-10 p-4">
            
            <!-- [BARU] HEADER RESPONSIVE -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold"><i class="bi bi-list-check me-2"></i>Master Data Poin</h4>
                <div class="d-block d-md-none">
                     <span class="fw-bold text-success"><?= $nama_sekolah ?></span>
                </div>
            </div>

            <!-- NAV TABS -->
            <ul class="nav nav-tabs" id="poinTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link <?= $active_tab == 'pelanggaran' ? 'active' : '' ?>" id="pelanggaran-tab" data-bs-toggle="tab" data-bs-target="#pelanggaran" type="button" role="tab">
                        <i class="bi bi-exclamation-triangle me-2"></i>Jenis Pelanggaran
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link <?= $active_tab == 'reward' ? 'active' : '' ?>" id="reward-tab" data-bs-toggle="tab" data-bs-target="#reward" type="button" role="tab">
                        <i class="bi bi-trophy me-2"></i>Jenis Reward
                    </button>
                </li>
            </ul>

            <div class="tab-content shadow-sm" id="poinTabContent">
                
                <!-- TAB 1: JENIS PELANGGARAN -->
                <div class="tab-pane fade <?= $active_tab == 'pelanggaran' ? 'show active' : '' ?>" id="pelanggaran" role="tabpanel">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="text-danger fw-bold mb-0">Daftar Pelanggaran & Poin Pengurang</h6>
                        <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambahPelanggaran">
                            <i class="bi bi-plus-lg me-1"></i> Tambah Pelanggaran
                        </button>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered align-middle datatable-init" style="width:100%">
                            <thead class="table-danger">
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Nama Pelanggaran</th>
                                    <th width="15%">Poin Pengurang</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                $q_jp = mysqli_query($koneksi, "SELECT * FROM jenis_pelanggaran ORDER BY poin_pengurang ASC");
                                while($jp = mysqli_fetch_assoc($q_jp)):
                                ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($jp['nama_pelanggaran']) ?></td>
                                    <td>
                                        <span class="badge badge-poin-red px-3 py-2 rounded-pill">
                                            -<?= $jp['poin_pengurang'] ?> Poin
                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" 
                                            data-bs-toggle="modal" data-bs-target="#modalEditPelanggaran"
                                            data-id="<?= $jp['id'] ?>"
                                            data-nama="<?= htmlspecialchars($jp['nama_pelanggaran']) ?>"
                                            data-poin="<?= $jp['poin_pengurang'] ?>"
                                            onclick="editPelanggaran(this)">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <a href="admin_jenispoin.php?hapus_pelanggaran=<?= $jp['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Hapus jenis pelanggaran ini?')">
                                            <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- TAB 2: JENIS REWARD -->
                <div class="tab-pane fade <?= $active_tab == 'reward' ? 'show active' : '' ?>" id="reward" role="tabpanel">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="text-success fw-bold mb-0">Daftar Prestasi & Poin Bonus</h6>
                        <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambahReward">
                            <i class="bi bi-plus-lg me-1"></i> Tambah Reward
                        </button>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered align-middle datatable-init" style="width:100%">
                            <thead class="table-success">
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Nama Reward / Prestasi</th>
                                    <th width="15%">Poin Bonus</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                $q_jr = mysqli_query($koneksi, "SELECT * FROM jenis_reward ORDER BY poin_bonus ASC");
                                while($jr = mysqli_fetch_assoc($q_jr)):
                                ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($jr['nama_reward']) ?></td>
                                    <td>
                                        <span class="badge badge-poin-green px-3 py-2 rounded-pill">
                                            +<?= $jr['poin_bonus'] ?> Poin
                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" 
                                            data-bs-toggle="modal" data-bs-target="#modalEditReward"
                                            data-id="<?= $jr['id'] ?>"
                                            data-nama="<?= htmlspecialchars($jr['nama_reward']) ?>"
                                            data-poin="<?= $jr['poin_bonus'] ?>"
                                            onclick="editReward(this)">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <a href="admin_jenispoin.php?hapus_reward=<?= $jr['id'] ?>&tab=reward" class="btn btn-sm btn-outline-danger" onclick="return confirm('Hapus jenis reward ini?')">
                                            <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- ================= MODAL PELANGGARAN ================= -->

<!-- Modal Tambah Pelanggaran -->
<div class="modal fade" id="modalTambahPelanggaran" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title fw-bold">Tambah Pelanggaran</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Nama Pelanggaran</label>
                        <input type="text" name="nama_pelanggaran" class="form-control" placeholder="Contoh: Terlambat Sekolah" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Poin Pengurang</label>
                        <input type="number" name="poin" class="form-control" placeholder="Contoh: 5" required min="1">
                        <small class="text-muted">Masukkan angka positif (tanpa tanda minus).</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="tambah_pelanggaran" class="btn btn-danger">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Pelanggaran -->
<div class="modal fade" id="modalEditPelanggaran" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold">Edit Pelanggaran</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id_pelanggaran" id="edit_id_pel">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Nama Pelanggaran</label>
                        <input type="text" name="nama_pelanggaran" id="edit_nama_pel" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Poin Pengurang</label>
                        <input type="number" name="poin" id="edit_poin_pel" class="form-control" required min="1">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="edit_pelanggaran" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- ================= MODAL REWARD ================= -->

<!-- Modal Tambah Reward -->
<div class="modal fade" id="modalTambahReward" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title fw-bold">Tambah Reward/Prestasi</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Nama Reward</label>
                        <input type="text" name="nama_reward" class="form-control" placeholder="Contoh: Juara Kelas" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Poin Bonus</label>
                        <input type="number" name="poin" class="form-control" placeholder="Contoh: 10" required min="1">
                        <small class="text-muted">Poin yang akan ditambahkan ke siswa.</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="tambah_reward" class="btn btn-success">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Reward -->
<div class="modal fade" id="modalEditReward" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold">Edit Reward</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id_reward" id="edit_id_rew">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Nama Reward</label>
                        <input type="text" name="nama_reward" id="edit_nama_rew" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Poin Bonus</label>
                        <input type="number" name="poin" id="edit_poin_rew" class="form-control" required min="1">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="edit_reward" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
        // Init DataTables
        $('.datatable-init').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json"
            }
        });
    });

    // Fungsi Isi Modal Edit Pelanggaran
    function editPelanggaran(btn) {
        document.getElementById('edit_id_pel').value = btn.getAttribute('data-id');
        document.getElementById('edit_nama_pel').value = btn.getAttribute('data-nama');
        document.getElementById('edit_poin_pel').value = btn.getAttribute('data-poin');
    }

    // Fungsi Isi Modal Edit Reward
    function editReward(btn) {
        document.getElementById('edit_id_rew').value = btn.getAttribute('data-id');
        document.getElementById('edit_nama_rew').value = btn.getAttribute('data-nama');
        document.getElementById('edit_poin_rew').value = btn.getAttribute('data-poin');
    }
</script>

</body>
</html>