<?php
session_start();
include 'koneksi.php';

// Cek akses admin
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

// --- [BARU] AJAX HANDLER UNTUK FILTER SISWA REALTIME ---
if (isset($_POST['action']) && $_POST['action'] == 'get_siswa_by_kelas') {
    $kelas_selected = $_POST['kelas'];
    
    $query_str = "SELECT id, nama, kelas FROM students";
    if (!empty($kelas_selected)) {
        $query_str .= " WHERE kelas = '$kelas_selected'";
    }
    $query_str .= " ORDER BY nama ASC";
    
    $q_siswa = mysqli_query($koneksi, $query_str);
    
    echo '<option value="">-- Semua Siswa --</option>';
    while ($s = mysqli_fetch_assoc($q_siswa)) {
        echo '<option value="' . $s['id'] . '">' . $s['nama'] . ' (' . $s['kelas'] . ')</option>';
    }
    exit;
}

// --- AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; 
$alamat_sekolah = "Jl. Contoh No. 1, Kota Bandung";
$kepala_sekolah = "Nama Kepala Sekolah";
$nuptk_ks = "-";
$ttd_ks = "";

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        $alamat_sekolah = !empty($d_sekolah['alamat_sekolah']) ? $d_sekolah['alamat_sekolah'] : $alamat_sekolah;
        $kepala_sekolah = !empty($d_sekolah['nama_kepala_sekolah']) ? $d_sekolah['nama_kepala_sekolah'] : $kepala_sekolah;
        $nuptk_ks = !empty($d_sekolah['nuptk_kepala_sekolah']) ? $d_sekolah['nuptk_kepala_sekolah'] : $nuptk_ks;
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
        if (!empty($d_sekolah['ttd_kepala_sekolah'])) {
            $ttd_ks = 'admin/uploads/' . $d_sekolah['ttd_kepala_sekolah'];
        }
    }
}

// --- LOGIKA FILTER ---
$tgl_awal     = isset($_GET['tgl_awal']) ? $_GET['tgl_awal'] : date('Y-m-01');
$tgl_akhir    = isset($_GET['tgl_akhir']) ? $_GET['tgl_akhir'] : date('Y-m-d');
$filter_kelas = isset($_GET['kelas']) ? $_GET['kelas'] : '';
$filter_siswa = isset($_GET['siswa']) ? $_GET['siswa'] : '';
// Filter Baru: Status Data
$status_data  = isset($_GET['status_data']) ? $_GET['status_data'] : 'melanggar'; // Default: melanggar

// --- BUILD QUERY ---
if ($status_data == 'semua') {
    // QUERY UNTUK SEMUA SISWA (LEFT JOIN)
    // Menampilkan siswa meskipun tidak ada pelanggaran di range tanggal tersebut
    $base_query = "SELECT r.tanggal, s.nama, s.kelas, s.sisa_poin, j.nama_pelanggaran, j.poin_pengurang, u.nama_lengkap
                   FROM students s
                   LEFT JOIN riwayat_pelanggaran r ON s.id = r.student_id AND DATE(r.tanggal) BETWEEN '$tgl_awal' AND '$tgl_akhir'
                   LEFT JOIN jenis_pelanggaran j ON r.jenis_pelanggaran_id = j.id
                   LEFT JOIN users u ON r.guru_id = u.id
                   WHERE 1=1";
    
    if (!empty($filter_kelas)) {
        $base_query .= " AND s.kelas = '$filter_kelas'";
    }
    if (!empty($filter_siswa)) {
        $base_query .= " AND s.id = '$filter_siswa'";
    }
    // Urutkan berdasarkan Kelas lalu Nama, agar data rapi
    $base_query .= " ORDER BY s.kelas ASC, s.nama ASC, r.tanggal DESC";

} else {
    // QUERY DEFAULT (INNER JOIN)
    // Hanya menampilkan siswa yang melanggar di range tanggal tersebut
    $base_query = "SELECT r.tanggal, s.nama, s.kelas, s.sisa_poin, j.nama_pelanggaran, j.poin_pengurang, u.nama_lengkap
                   FROM riwayat_pelanggaran r
                   JOIN students s ON r.student_id = s.id
                   JOIN jenis_pelanggaran j ON r.jenis_pelanggaran_id = j.id
                   JOIN users u ON r.guru_id = u.id
                   WHERE DATE(r.tanggal) BETWEEN '$tgl_awal' AND '$tgl_akhir'";

    if (!empty($filter_kelas)) {
        $base_query .= " AND s.kelas = '$filter_kelas'";
    }
    if (!empty($filter_siswa)) {
        $base_query .= " AND r.student_id = '$filter_siswa'";
    }
    $base_query .= " ORDER BY r.tanggal DESC";
}

// --- LOGIKA EXPORT ---
if (isset($_GET['export'])) {
    $type = $_GET['export'];
    $filename = "Laporan_" . ($status_data == 'semua' ? "Semua_Siswa_" : "Pelanggaran_") . date('Ymd_His');

    if (ob_get_level()) ob_end_clean();

    $logo_src = '';
    if (file_exists($logo_sekolah)) {
        $type_img = pathinfo($logo_sekolah, PATHINFO_EXTENSION);
        $data_img = file_get_contents($logo_sekolah);
        $logo_src = 'data:image/' . $type_img . ';base64,' . base64_encode($data_img);
    }

    $ttd_src = '';
    if (!empty($ttd_ks) && file_exists($ttd_ks)) {
        $type_ttd = pathinfo($ttd_ks, PATHINFO_EXTENSION);
        $data_ttd = file_get_contents($ttd_ks);
        $ttd_src = 'data:image/' . $type_ttd . ';base64,' . base64_encode($data_ttd);
    }

    if ($type == 'excel') {
        header("Content-Type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=$filename.xls");
    } elseif ($type == 'word') {
        header("Content-Type: application/vnd.ms-word");
        header("Content-Disposition: attachment; filename=$filename.doc");
    }
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: 'Times New Roman', Times, serif; font-size: 12pt; }
            .kop-table { width: 100%; border-bottom: 3px double #000; margin-bottom: 20px; }
            .kop-logo { width: 100px; text-align: center; }
            .kop-text { text-align: center; }
            .kop-nama { font-size: 20pt; font-weight: bold; text-transform: uppercase; margin: 0; }
            .kop-alamat { font-size: 11pt; margin: 5px 0 0 0; }
            .table-data { width: 100%; border-collapse: collapse; margin-top: 10px; }
            .table-data th, .table-data td { border: 1px solid black; padding: 6px; font-size: 11pt; vertical-align: middle; }
            .table-data th { background-color: #e0e0e0; text-align: center; font-weight: bold; }
            .ttd-container { width: 100%; margin-top: 40px; }
            .ttd-box { float: right; width: 250px; text-align: center; }
        </style>
    </head>
    <body>

    <table class="kop-table" cellpadding="5" cellspacing="0">
        <tr>
            <td class="kop-logo" valign="middle">
                <?php if (!empty($logo_src)): ?>
                    <img src="<?= $logo_src ?>" width="90" height="auto" alt="Logo">
                <?php endif; ?>
            </td>
            <td class="kop-text" valign="middle">
                <div class="kop-nama"><?= $nama_sekolah ?></div>
                <div class="kop-alamat"><?= $alamat_sekolah ?></div>
                <div style="font-size: 10pt; margin-top: 2px;">Laporan Monitoring Siswa</div>
            </td>
            <td width="10%"></td>
        </tr>
    </table>

    <h3 style="text-align: center; margin-bottom: 5px;">DATA MONITORING SISWA</h3>
    <div style="text-align: center; font-size: 11pt; margin-bottom: 20px;">
        Periode: <?= date('d/m/Y', strtotime($tgl_awal)) ?> s.d. <?= date('d/m/Y', strtotime($tgl_akhir)) ?>
        <?= !empty($filter_kelas) ? "<br>Kelas: $filter_kelas" : "" ?>
        <br>Status Data: <?= ($status_data == 'semua') ? 'Semua Siswa' : 'Hanya yang Melanggar' ?>
    </div>

    <table class="table-data">
        <thead>
            <tr>
                <th width="5%">No</th>
                <th width="15%">Tanggal</th>
                <th>Nama Siswa</th>
                <th width="10%">Kelas</th>
                <th>Pelanggaran</th>
                <th width="10%">Poin</th>
                <th width="10%">Sisa</th>
                <th>Pelapor</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $no = 1;
            $result = mysqli_query($koneksi, $base_query);
            if (mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    $tanggal = !empty($row['tanggal']) ? date('d/m/Y', strtotime($row['tanggal'])) : '-';
                    $pelanggaran = !empty($row['nama_pelanggaran']) ? $row['nama_pelanggaran'] : '-';
                    $poin = !empty($row['poin_pengurang']) ? "-{$row['poin_pengurang']}" : '-';
                    $color = !empty($row['poin_pengurang']) ? 'color:red;' : '';
                    $pelapor = !empty($row['nama_lengkap']) ? $row['nama_lengkap'] : '-';

                    echo "<tr>";
                    echo "<td align='center'>{$no}</td>";
                    echo "<td align='center'>{$tanggal}</td>";
                    echo "<td>{$row['nama']}</td>";
                    echo "<td align='center'>{$row['kelas']}</td>";
                    echo "<td>{$pelanggaran}</td>";
                    echo "<td align='center' style='{$color}'>{$poin}</td>";
                    echo "<td align='center'><strong>{$row['sisa_poin']}</strong></td>";
                    echo "<td>{$pelapor}</td>";
                    echo "</tr>";
                    $no++;
                }
            } else {
                echo "<tr><td colspan='8' align='center'>Tidak ada data ditemukan.</td></tr>";
            }
            ?>
        </tbody>
    </table>

    <?php if ($type == 'word'): ?>
        <div class="ttd-container">
            <div class="ttd-box">
                <p>
                    Bandung, <?= date('d F Y') ?><br>
                    Mengetahui,<br>
                    Kepala Sekolah
                </p>
               
                <p style="text-decoration: underline; font-weight: bold; margin-bottom: 0;">
                    <?= $kepala_sekolah ?>
                </p>
                <p style="margin-top: 2px;">NUPTK. <?= $nuptk_ks ?></p>
            </div>
            <div style="clear: both;"></div>
        </div>
    <?php endif; ?>

    </body>
    </html>
    <?php
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Pelanggaran - Admin</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    
    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
        .sidebar { min-height: 100vh; background: white; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .nav-link.active { background-color: #e8f5e9; color: #198754; font-weight: bold; border-left: 4px solid #198754; }
        .nav-link { color: #555; transition: 0.3s; }
        .nav-link:hover { background-color: #f8f9fa; color: #198754; }
        .sidebar-header { text-align: center; padding: 20px 10px; border-bottom: 1px solid #eee; margin-bottom: 20px; }
        .school-logo { width: 80px; height: 80px; object-fit: contain; margin-bottom: 10px; }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar d-none d-md-block p-0">
            <div class="sidebar-header">
                <img src="<?= $logo_sekolah ?>" alt="Logo Sekolah" class="school-logo" onerror="this.onerror=null; this.src='https://via.placeholder.com/80?text=Logo';">
                <h6 class="fw-bold text-success m-0"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Admin Panel</small>
            </div>
            <ul class="nav flex-column px-2">
                <li class="nav-item"><a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li class="nav-item"><a href="admin_pelanggaran.php" class="nav-link"><i class="bi bi-pencil-square me-2"></i>Input Poin</a></li>
                <li class="nav-item"><a href="adminguru.php" class="nav-link"><i class="bi bi-person-workspace me-2"></i>Data Guru</a></li>
                <li class="nav-item"><a href="admin_jadwa.php" class="nav-link"><i class="bi bi-calendar-week me-2"></i>Admin Jadwal</a></li>
                <li class="nav-item"><a href="admin_jenispoin.php" class="nav-link"><i class="bi bi-list-check me-2"></i>Jenis Pelanggaran</a></li>
                 <li class="nav-item"><a href="admin_laporanpelanggaran.php" class="nav-link active"><i class="bi bi-file-earmark-text me-2"></i>Laporan</a></li>
                 <li class="nav-item"><a href="pengaturan_sekolah.php" class="nav-link"><i class="bi bi-gear me-2"></i>Pengaturan Sekolah</a></li>
                <li class="nav-item"><a href="logout.php" class="nav-link text-danger mt-3"><i class="bi bi-box-arrow-left me-2"></i>Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-10 p-4">
            
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold"><i class="bi bi-file-earmark-text me-2"></i>Laporan Pelanggaran Siswa</h4>
                <div class="d-block d-md-none">
                     <span class="fw-bold text-success"><?= $nama_sekolah ?></span>
                </div>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-header bg-white py-3">
                    <h6 class="fw-bold mb-0 text-secondary"><i class="bi bi-filter me-2"></i>Filter & Export Data</h6>
                </div>
                <div class="card-body">
                    <form method="GET" action="">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label fw-bold small">Tanggal Awal</label>
                                <input type="date" name="tgl_awal" class="form-control" value="<?= $tgl_awal ?>">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label fw-bold small">Tanggal Akhir</label>
                                <input type="date" name="tgl_akhir" class="form-control" value="<?= $tgl_akhir ?>">
                            </div>
                            
                            <div class="col-md-3">
                                <label class="form-label fw-bold small">Filter Kelas</label>
                                <select name="kelas" class="form-select select2-simple">
                                    <option value="">-- Semua Kelas --</option>
                                    <?php
                                    $q_kelas = mysqli_query($koneksi, "SELECT DISTINCT kelas FROM students ORDER BY kelas ASC");
                                    while($k = mysqli_fetch_assoc($q_kelas)):
                                        $selected = ($filter_kelas == $k['kelas']) ? 'selected' : '';
                                    ?>
                                        <option value="<?= $k['kelas'] ?>" <?= $selected ?>><?= $k['kelas'] ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label fw-bold small">Status Data</label>
                                <select name="status_data" class="form-select">
                                    <option value="melanggar" <?= $status_data == 'melanggar' ? 'selected' : '' ?>>Hanya yang Melanggar</option>
                                    <option value="semua" <?= $status_data == 'semua' ? 'selected' : '' ?>>Semua Siswa (Lengkap)</option>
                                </select>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label fw-bold small">Filter Siswa (Spesifik)</label>
                                <select name="siswa" class="form-select select2-siswa">
                                    <option value="">-- Semua Siswa --</option>
                                    <?php
                                    $query_awal_siswa = "SELECT id, nama, kelas FROM students";
                                    if(!empty($filter_kelas)){
                                        $query_awal_siswa .= " WHERE kelas = '$filter_kelas'";
                                    }
                                    $query_awal_siswa .= " ORDER BY nama ASC";
                                    $q_siswa = mysqli_query($koneksi, $query_awal_siswa);
                                    
                                    while($s = mysqli_fetch_assoc($q_siswa)):
                                        $selected = ($filter_siswa == $s['id']) ? 'selected' : '';
                                        $display = $s['nama'] . " (" . $s['kelas'] . ")";
                                    ?>
                                        <option value="<?= $s['id'] ?>" <?= $selected ?>><?= $display ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>

                            <div class="col-md-12 d-flex justify-content-between align-items-center mt-3">
                                <button type="submit" class="btn btn-primary px-4"><i class="bi bi-search me-1"></i> Tampilkan Data</button>
                                
                                <div class="btn-group">
                                    <button type="submit" name="export" value="excel" class="btn btn-success">
                                        <i class="bi bi-file-earmark-spreadsheet me-1"></i> Export Excel
                                    </button>
                                    <button type="submit" name="export" value="word" class="btn btn-primary" style="background-color: #2b5797; border-color: #2b5797;">
                                        <i class="bi bi-file-earmark-word me-1"></i> Export Word
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card shadow-sm border-0 mt-4">
                <div class="card-body">
                    <h6 class="fw-bold text-center mb-4">
                        Preview Laporan <br>
                        <small class="text-muted fw-normal">
                            <?= date('d/m/Y', strtotime($tgl_awal)) ?> - <?= date('d/m/Y', strtotime($tgl_akhir)) ?>
                            <?= !empty($filter_kelas) ? "| Kelas: $filter_kelas" : "" ?>
                            | <?= ($status_data == 'semua') ? 'Semua Siswa' : 'Hanya Melanggar' ?>
                        </small>
                    </h6>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped align-middle">
                            <thead class="table-dark">
                                <tr>
                                    <th>No</th>
                                    <th>Tanggal</th>
                                    <th>Nama Siswa</th>
                                    <th>Kelas</th>
                                    <th>Jenis Pelanggaran</th>
                                    <th>Pengurangan</th>
                                    <th>Sisa Poin</th>
                                    <th>Guru Pelapor</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                $result = mysqli_query($koneksi, $base_query);
                                
                                if (mysqli_num_rows($result) > 0) {
                                    while ($rv = mysqli_fetch_assoc($result)) {
                                        // Handle NULL data jika pilih "Semua Siswa"
                                        $tanggal = !empty($rv['tanggal']) ? date('d/m/Y H:i', strtotime($rv['tanggal'])) : '-';
                                        $pelanggaran = !empty($rv['nama_pelanggaran']) ? $rv['nama_pelanggaran'] : '-';
                                        $poin = !empty($rv['poin_pengurang']) ? "-{$rv['poin_pengurang']}" : '-';
                                        $class_poin = !empty($rv['poin_pengurang']) ? 'text-danger fw-bold' : 'text-muted';
                                        $pelapor = !empty($rv['nama_lengkap']) ? $rv['nama_lengkap'] : '-';

                                        echo "<tr>";
                                        echo "<td align='center'>{$no}</td>";
                                        echo "<td align='center'>{$tanggal}</td>";
                                        echo "<td>{$rv['nama']}</td>";
                                        echo "<td align='center'>{$rv['kelas']}</td>";
                                        echo "<td>{$pelanggaran}</td>";
                                        echo "<td class='{$class_poin} text-center'>{$poin}</td>";
                                        echo "<td align='center'><strong>{$rv['sisa_poin']}</strong></td>";
                                        echo "<td>{$pelapor}</td>";
                                        echo "</tr>";
                                        $no++;
                                    }
                                } else {
                                    echo "<tr><td colspan='8' class='text-center py-4 text-muted'>Tidak ada data ditemukan sesuai filter.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2-simple').select2({ theme: 'bootstrap-5', width: '100%' });
        $('.select2-siswa').select2({ theme: 'bootstrap-5', width: '100%', placeholder: 'Cari nama siswa...', allowClear: true });

        $('select[name="kelas"]').on('change', function() {
            var kelas = $(this).val();
            var $siswaSelect = $('select[name="siswa"]');
            $siswaSelect.prop('disabled', true).html('<option>Memuat data...</option>');
            $.ajax({
                url: 'admin_laporanpelanggaran.php',
                type: 'POST',
                data: { action: 'get_siswa_by_kelas', kelas: kelas },
                success: function(response) {
                    $siswaSelect.html(response).prop('disabled', false).trigger('change'); 
                },
                error: function() {
                    alert('Gagal mengambil data siswa. Silakan coba lagi.');
                    $siswaSelect.prop('disabled', false).html('<option value="">-- Semua Siswa --</option>');
                }
            });
        });
    });
</script>
</body>
</html>