<?php
session_start();
include 'koneksi.php';

// 1. Cek Akses
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_admin = $_SESSION['user_id'];
$pesan = "";
$tipe_pesan = "";

// --- [BARU] AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; // Default jika db kosong

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            // Pastikan path ini sesuai dengan struktur folder Anda
            // Jika file ini ada di dalam folder 'admin', mungkin perlu disesuaikan menjadi 'uploads/' saja
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// --- FUNGSI UPDATE POIN & HAPUS DATA ---
if (isset($_GET['hapus_pelanggaran'])) {
    $id_riwayat = $_GET['hapus_pelanggaran'];
    
    // Ambil data dulu untuk mengembalikan poin
    $q_old = mysqli_query($koneksi, "SELECT r.student_id, r.jenis_pelanggaran_id, j.poin_pengurang 
                                     FROM riwayat_pelanggaran r 
                                     JOIN jenis_pelanggaran j ON r.jenis_pelanggaran_id = j.id 
                                     WHERE r.id = '$id_riwayat'");
    $d_old = mysqli_fetch_assoc($q_old);
    
    if ($d_old) {
        $poin_balik = $d_old['poin_pengurang'];
        $id_siswa = $d_old['student_id'];
        
        // 1. Hapus Data
        $del = mysqli_query($koneksi, "DELETE FROM riwayat_pelanggaran WHERE id = '$id_riwayat'");
        // 2. Kembalikan Poin Siswa (+)
        $upd = mysqli_query($koneksi, "UPDATE students SET sisa_poin = sisa_poin + $poin_balik WHERE id = '$id_siswa'");
        
        if ($del && $upd) {
            echo "<script>alert('Data pelanggaran dihapus & poin dikembalikan!'); window.location='admin.php';</script>";
        }
    }
}

if (isset($_GET['hapus_reward'])) {
    $id_riwayat = $_GET['hapus_reward'];
    
    $q_old = mysqli_query($koneksi, "SELECT r.student_id, j.poin_bonus 
                                     FROM riwayat_reward r 
                                     JOIN jenis_reward j ON r.jenis_reward_id = j.id 
                                     WHERE r.id = '$id_riwayat'");
    $d_old = mysqli_fetch_assoc($q_old);
    
    if ($d_old) {
        $poin_tarik = $d_old['poin_bonus'];
        $id_siswa = $d_old['student_id'];
        
        // 1. Hapus Data
        $del = mysqli_query($koneksi, "DELETE FROM riwayat_reward WHERE id = '$id_riwayat'");
        // 2. Tarik Poin Siswa (-)
        $upd = mysqli_query($koneksi, "UPDATE students SET sisa_poin = sisa_poin - $poin_tarik WHERE id = '$id_siswa'");
        
        if ($del && $upd) {
            echo "<script>alert('Data reward dihapus & poin ditarik kembali!'); window.location='admin.php';</script>";
        }
    }
}

// --- PROSES INPUT PELANGGARAN ---
if (isset($_POST['simpan_pelanggaran'])) {
    $student_id = $_POST['student_id'];
    $jenis_id   = $_POST['jenis_pelanggaran_id'];
    $tanggal    = $_POST['tanggal_input'];
    
    $q_jenis = mysqli_query($koneksi, "SELECT poin_pengurang FROM jenis_pelanggaran WHERE id = '$jenis_id'");
    $d_jenis = mysqli_fetch_assoc($q_jenis);
    $poin = $d_jenis['poin_pengurang'];

    // Kurangi Poin
    $update_siswa = mysqli_query($koneksi, "UPDATE students SET sisa_poin = sisa_poin - $poin WHERE id = '$student_id'");
    
    if ($update_siswa) {
        $insert = mysqli_query($koneksi, "INSERT INTO riwayat_pelanggaran (student_id, guru_id, jenis_pelanggaran_id, tanggal) VALUES ('$student_id', '$id_admin', '$jenis_id', '$tanggal')");
        if ($insert) {
            $pesan = "Pelanggaran berhasil disimpan.";
            $tipe_pesan = "danger";
        }
    }
}

// --- PROSES INPUT REWARD ---
if (isset($_POST['simpan_reward'])) {
    $student_id = $_POST['student_id'];
    $jenis_id   = $_POST['jenis_reward_id'];
    $tanggal    = $_POST['tanggal_input'];
    
    $q_jenis = mysqli_query($koneksi, "SELECT poin_bonus FROM jenis_reward WHERE id = '$jenis_id'");
    $d_jenis = mysqli_fetch_assoc($q_jenis);
    $poin = $d_jenis['poin_bonus'];

    // Tambah Poin
    $update_siswa = mysqli_query($koneksi, "UPDATE students SET sisa_poin = sisa_poin + $poin WHERE id = '$student_id'");
    
    if ($update_siswa) {
        $insert = mysqli_query($koneksi, "INSERT INTO riwayat_reward (student_id, guru_id, jenis_reward_id, tanggal) VALUES ('$student_id', '$id_admin', '$jenis_id', '$tanggal')");
        if ($insert) {
            $pesan = "Reward berhasil disimpan.";
            $tipe_pesan = "success";
        }
    }
}

// --- DATA UMUM ---
$q_siswa_all = mysqli_query($koneksi, "SELECT id, nama, kelas, sisa_poin FROM students ORDER BY kelas ASC, nama ASC");
$arr_siswa = [];
while($row = mysqli_fetch_assoc($q_siswa_all)) { $arr_siswa[] = $row; }
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Input & Riwayat</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Select2 & DataTables -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
        .sidebar { min-height: 100vh; background: white; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .nav-link.active { background-color: #e8f5e9; color: #198754; font-weight: bold; border-left: 4px solid #198754; }
        .nav-link { color: #555; transition: 0.3s; }
        .nav-link:hover { background-color: #f8f9fa; color: #198754; }
        .nav-tabs .nav-link.active { background-color: #fff; border-bottom-color: #fff; color: #198754; font-weight: bold; }
        .tab-content { background: #fff; border: 1px solid #dee2e6; border-top: none; border-radius: 0 0 5px 5px; padding: 20px; }
        
        /* Style untuk Logo di Sidebar */
        .sidebar-header {
            text-align: center;
            padding: 20px 10px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        .school-logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar d-none d-md-block p-0">
            
            <!-- [BARU] BAGIAN LOGO & NAMA SEKOLAH -->
            <div class="sidebar-header">
                <img src="<?= $logo_sekolah ?>" alt="Logo Sekolah" class="school-logo" onerror="this.onerror=null; this.src='https://via.placeholder.com/80?text=Logo';">
                <h6 class="fw-bold text-success m-0"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Admin Panel</small>
            </div>

            <ul class="nav flex-column px-2">
                <li class="nav-item"><a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li class="nav-item"><a href="admin_pelanggaran.php" class="nav-link active"><i class="bi bi-pencil-square me-2"></i>Input Poin</a></li>
                <li class="nav-item"><a href="adminguru.php" class="nav-link"><i class="bi bi-person-workspace me-2"></i>Data Guru</a></li>
                 <li class="nav-item"><a href="admin_jadwa.php" class="nav-link"><i class="bi bi-calendar-week me-2"></i>Admin Jadwal</a></li>
                <li class="nav-item"><a href="admin_jenispoin.php" class="nav-link"><i class="bi bi-list-check me-2"></i>Jenis Pelanggaran</a></li>
                 <li class="nav-item"><a href="admin_laporanpelanggaran.php" class="nav-link"><i class="bi bi-file-earmark-text me-2"></i>Laporan</a></li>
                 <li class="nav-item"><a href="pengaturan_sekolah.php" class="nav-link"><i class="bi bi-gear me-2"></i>Pengaturan Sekolah</a></li>
                <li class="nav-item"><a href="logout.php" class="nav-link text-danger mt-3"><i class="bi bi-box-arrow-left me-2"></i>Logout</a></li>
            </ul>
        </div>
        
        <!-- MAIN CONTENT -->
        <div class="col-md-10 p-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold"><i class="bi bi-pencil-square me-2"></i>Manajemen Pelanggaran & Reward</h4>
                <div class="d-block d-md-none">
                     <!-- Mobile Logo (Opsional) -->
                     <span class="fw-bold text-success"><?= $nama_sekolah ?></span>
                </div>
            </div>

            <?php if ($pesan != ""): ?>
                <div class="alert alert-<?= $tipe_pesan ?> alert-dismissible fade show" role="alert">
                    <?= $pesan ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- NAV TABS -->
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="pelanggaran-tab" data-bs-toggle="tab" data-bs-target="#pelanggaran" type="button" role="tab"><i class="bi bi-exclamation-triangle me-2"></i>Input Pelanggaran</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="reward-tab" data-bs-toggle="tab" data-bs-target="#reward" type="button" role="tab"><i class="bi bi-trophy me-2"></i>Input Reward</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="riwayat-tab" data-bs-toggle="tab" data-bs-target="#riwayat" type="button" role="tab"><i class="bi bi-clock-history me-2"></i>Data Riwayat</button>
                </li>
            </ul>

            <div class="tab-content shadow-sm" id="myTabContent">
                
                <!-- TAB 1: INPUT PELANGGARAN -->
                <div class="tab-pane fade show active" id="pelanggaran" role="tabpanel">
                    <form method="POST">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Tanggal & Jam Kejadian</label>
                                <input type="datetime-local" name="tanggal_input" class="form-control" value="<?= date('Y-m-d\TH:i') ?>" required>
                                <small class="text-muted">Bisa diubah jika input data susulan.</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Pilih Siswa</label>
                                <select name="student_id" class="form-select select-siswa" required>
                                    <option value="">-- Cari Siswa --</option>
                                    <?php foreach($arr_siswa as $s): ?>
                                        <option value="<?= $s['id'] ?>"><?= $s['nama'] ?> (<?= $s['kelas'] ?>) - Poin: <?= $s['sisa_poin'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-12 mb-3">
                                <label class="form-label fw-bold">Jenis Pelanggaran</label>
                                <select name="jenis_pelanggaran_id" class="form-select select-basic" required>
                                    <option value="">-- Pilih Jenis Pelanggaran --</option>
                                    <?php 
                                    $q_jp = mysqli_query($koneksi, "SELECT * FROM jenis_pelanggaran ORDER BY poin_pengurang ASC");
                                    while($jp = mysqli_fetch_assoc($q_jp)): ?>
                                        <option value="<?= $jp['id'] ?>"><?= $jp['nama_pelanggaran'] ?> ( -<?= $jp['poin_pengurang'] ?> Poin)</option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="col-12 text-end">
                                <button type="submit" name="simpan_pelanggaran" class="btn btn-danger px-4"><i class="bi bi-save me-2"></i>Simpan Pelanggaran</button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- TAB 2: INPUT REWARD -->
                <div class="tab-pane fade" id="reward" role="tabpanel">
                    <form method="POST">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Tanggal & Jam</label>
                                <input type="datetime-local" name="tanggal_input" class="form-control" value="<?= date('Y-m-d\TH:i') ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Pilih Siswa</label>
                                <select name="student_id" class="form-select select-siswa" required>
                                    <option value="">-- Cari Siswa --</option>
                                    <?php foreach($arr_siswa as $s): ?>
                                        <option value="<?= $s['id'] ?>"><?= $s['nama'] ?> (<?= $s['kelas'] ?>) - Poin: <?= $s['sisa_poin'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-12 mb-3">
                                <label class="form-label fw-bold">Jenis Reward/Prestasi</label>
                                <select name="jenis_reward_id" class="form-select select-basic" required>
                                    <option value="">-- Pilih Reward --</option>
                                    <?php 
                                    $q_jr = mysqli_query($koneksi, "SELECT * FROM jenis_reward ORDER BY poin_bonus ASC");
                                    while($jr = mysqli_fetch_assoc($q_jr)): ?>
                                        <option value="<?= $jr['id'] ?>"><?= $jr['nama_reward'] ?> ( +<?= $jr['poin_bonus'] ?> Poin)</option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="col-12 text-end">
                                <button type="submit" name="simpan_reward" class="btn btn-success px-4"><i class="bi bi-save me-2"></i>Simpan Reward</button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- TAB 3: DATA RIWAYAT -->
                <div class="tab-pane fade" id="riwayat" role="tabpanel">
                    
                    <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active btn-sm" data-bs-toggle="pill" data-bs-target="#pills-pelanggaran">Riwayat Pelanggaran</button>
                        </li>
                        <li class="nav-item ms-2">
                            <button class="nav-link btn-sm" data-bs-toggle="pill" data-bs-target="#pills-reward">Riwayat Reward</button>
                        </li>
                    </ul>

                    <div class="tab-content">
                        <!-- TABEL PELANGGARAN -->
                        <div class="tab-pane fade show active" id="pills-pelanggaran">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered datatable-init" style="width:100%">
                                    <thead class="table-danger">
                                        <tr>
                                            <th>Waktu Kejadian</th>
                                            <th>Siswa</th>
                                            <th>Kelas</th>
                                            <th>Pelanggaran</th>
                                            <th>Poin</th>
                                            <th>Oleh</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $q_rp = mysqli_query($koneksi, "
                                            SELECT r.id, r.tanggal, s.nama, s.kelas, j.nama_pelanggaran, j.poin_pengurang, u.nama_lengkap
                                            FROM riwayat_pelanggaran r
                                            JOIN students s ON r.student_id = s.id
                                            JOIN jenis_pelanggaran j ON r.jenis_pelanggaran_id = j.id
                                            JOIN users u ON r.guru_id = u.id
                                            ORDER BY r.tanggal DESC
                                        ");
                                        while($rp = mysqli_fetch_assoc($q_rp)):
                                        ?>
                                        <tr>
                                            <td><?= date('d/m/Y H:i', strtotime($rp['tanggal'])) ?></td>
                                            <td><?= $rp['nama'] ?></td>
                                            <td><?= $rp['kelas'] ?></td>
                                            <td><?= $rp['nama_pelanggaran'] ?></td>
                                            <td class="text-danger fw-bold">-<?= $rp['poin_pengurang'] ?></td>
                                            <td><?= $rp['nama_lengkap'] ?></td>
                                            <td>
                                                <a href="admin.php?hapus_pelanggaran=<?= $rp['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Yakin hapus? Poin siswa akan dikembalikan.')"><i class="bi bi-trash"></i></a>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- TABEL REWARD -->
                        <div class="tab-pane fade" id="pills-reward">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered datatable-init" style="width:100%">
                                    <thead class="table-success">
                                        <tr>
                                            <th>Waktu Input</th>
                                            <th>Siswa</th>
                                            <th>Kelas</th>
                                            <th>Reward/Prestasi</th>
                                            <th>Poin</th>
                                            <th>Oleh</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $q_rr = mysqli_query($koneksi, "
                                            SELECT r.id, r.tanggal, s.nama, s.kelas, j.nama_reward, j.poin_bonus, u.nama_lengkap
                                            FROM riwayat_reward r
                                            JOIN students s ON r.student_id = s.id
                                            JOIN jenis_reward j ON r.jenis_reward_id = j.id
                                            JOIN users u ON r.guru_id = u.id
                                            ORDER BY r.tanggal DESC
                                        ");
                                        while($rr = mysqli_fetch_assoc($q_rr)):
                                        ?>
                                        <tr>
                                            <td><?= date('d/m/Y H:i', strtotime($rr['tanggal'])) ?></td>
                                            <td><?= $rr['nama'] ?></td>
                                            <td><?= $rr['kelas'] ?></td>
                                            <td><?= $rr['nama_reward'] ?></td>
                                            <td class="text-success fw-bold">+<?= $rr['poin_bonus'] ?></td>
                                            <td><?= $rr['nama_lengkap'] ?></td>
                                            <td>
                                                <a href="admin.php?hapus_reward=<?= $rr['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Yakin hapus? Poin tambahan siswa akan ditarik kembali.')"><i class="bi bi-trash"></i></a>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
        // Init Select2
        $('.select-siswa').select2({
            theme: 'bootstrap-5',
            width: '100%',
            placeholder: 'Cari Nama Siswa...'
        });
        $('.select-basic').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });

        // Init DataTables
        $('.datatable-init').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json"
            },
            "order": [[ 0, "desc" ]] 
        });
    });
</script>
</body>
</html>