<?php
session_start();
require_once 'config.php';

// --- KONFIGURASI WA GATEWAY ---
define('WABLAS_DOMAIN', 'https://jogja.wablas.com');
define('WABLAS_API_KEY', 'mEu2VduS3iokmYIgaMm0mRc2DvZg6SjozrLecV52EZaMVvCZwRNl51E');
define('WABLAS_TOKEN_SECRET', 'V4k4NH7r'); 

// --- CEK SESI ADMIN ---
if (!isset($_SESSION['role'])) { // Sesuaikan dengan logic login Anda
    header("Location: login.php");
    exit;
}

$message = "";
$msg_type = "";

// --- FUNGSI KIRIM WA (WABLAS) ---
function sendWaNotification($conn, $token_baru) {
    // 1. Ambil semua nomor HP Guru/User
    // Pastikan kolom 'nomor_hp' ada di tabel 'users'
    $query = $conn->query("SELECT nomor_hp FROM users WHERE nomor_hp IS NOT NULL AND nomor_hp != ''");
    
    $target_numbers = [];
    while ($row = $query->fetch_assoc()) {
        $hp = trim($row['nomor_hp']);
        // Bersihkan format nomor jika perlu (misal ganti 08 jadi 628)
        if (substr($hp, 0, 1) == '0') {
            $hp = '62' . substr($hp, 1);
        }
        $target_numbers[] = $hp;
    }

    if (empty($target_numbers)) {
        return "Tidak ada nomor HP tujuan ditemukan.";
    }

    // Ubah array nomor menjadi string dipisahkan koma
    $phone_list = implode(',', $target_numbers);

    // 2. Siapkan Pesan
    $pesan = "📢 *UPDATE TOKEN UJIAN*\n\n";
    $pesan .= "Token ujian telah diperbarui.\n";
    $pesan .= "Token Baru: *$token_baru*\n";
    $pesan .= "Waktu: " . date('d-m-Y H:i') . "\n\n";
    $pesan .= "_Harap informasikan kepada siswa._";

    // 3. Kirim via Curl ke Wablas
    $curl = curl_init();
    $data = [
        'phone' => $phone_list,
        'message' => $pesan,
        'secret' => false, // Set true jika ingin encrypted message priority
        'retry' => false,
        'isGroup' => false,
    ];

    curl_setopt($curl, CURLOPT_HTTPHEADER, [
        "Authorization: " . WABLAS_API_KEY,
        "x-token: " . WABLAS_TOKEN_SECRET, // Kadang diperlukan header tambahan
        "Content-Type: application/json"
    ]);
    curl_setopt($curl, CURLOPT_URL, WABLAS_DOMAIN . "/api/send-message");
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
    
    $result = curl_exec($curl);
    $error = curl_error($curl);
    curl_close($curl);

    if ($error) {
        return "Gagal kirim WA: $error";
    }
    return "Notifikasi WA terkirim.";
}

// --- HANDLE FORM SUBMIT ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_settings'])) {
    $new_token = strtoupper(trim($_POST['token']));
    $mode = $_POST['token_mode']; // 'manual' atau 'auto'
    $minutes = (int)$_POST['auto_minutes'];

    if ($mode == 'auto' && $minutes < 1) {
        $message = "Durasi otomatis minimal 1 menit.";
        $msg_type = "error";
    } elseif (!empty($new_token)) {
        
        // Update database
        $stmt = $conn->prepare("UPDATE exam_settings SET exam_token = ?, token_mode = ?, auto_refresh_minutes = ?, last_generated_at = NOW() WHERE id = 1");
        $stmt->bind_param("ssi", $new_token, $mode, $minutes);
        
        if ($stmt->execute()) {
            $message = "Pengaturan berhasil disimpan!";
            $msg_type = "success";

            // Kirim Notifikasi WA
            $wa_status = sendWaNotification($conn, $new_token);
            $message .= " (" . $wa_status . ")";

        } else {
            $message = "Database Error: " . $conn->error;
            $msg_type = "error";
        }
        $stmt->close();
    } else {
        $message = "Token tidak boleh kosong.";
        $msg_type = "error";
    }
}

// --- AMBIL DATA SAAT INI ---
$current_token = "";
$last_update = "";
$current_mode = "manual";
$current_minutes = 15;

$result = $conn->query("SELECT exam_token, last_generated_at, token_mode, auto_refresh_minutes FROM exam_settings WHERE id = 1 LIMIT 1");
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $current_token = $row['exam_token'];
    $last_update = $row['last_generated_at'];
    // Cek jika kolom baru sudah ada (untuk backward compatibility jika lupa alter table)
    $current_mode = isset($row['token_mode']) ? $row['token_mode'] : 'manual';
    $current_minutes = isset($row['auto_refresh_minutes']) ? $row['auto_refresh_minutes'] : 15;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atur Token Ujian</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <!-- Icons (Lucide) -->
    <script src="https://unpkg.com/lucide@latest"></script>

    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: linear-gradient(135deg, #4f46e5 0%, #06b6d4 100%);
            background-attachment: fixed;
            overflow-x: hidden;
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">

    <div class="glass-card w-full max-w-lg rounded-3xl p-8 relative overflow-hidden shadow-2xl">
        
        <div class="text-center mb-6">
            <div class="mx-auto w-14 h-14 bg-indigo-100 rounded-full flex items-center justify-center mb-3">
                <i data-lucide="shield-check" class="w-7 h-7 text-indigo-600"></i>
            </div>
            <h2 class="text-2xl font-bold text-gray-800">Manajemen Token</h2>
            <p class="text-gray-500 text-sm">Pengaturan token akses ujian & notifikasi</p>
        </div>

        <?php if ($message): ?>
            <div class="mb-5 p-4 rounded-xl text-sm font-medium flex items-center gap-2 <?php echo $msg_type == 'success' ? 'bg-green-100 text-green-700 border border-green-200' : 'bg-red-100 text-red-700 border border-red-200'; ?>">
                <i data-lucide="<?php echo $msg_type == 'success' ? 'check-circle' : 'alert-circle'; ?>" class="w-5 h-5 flex-shrink-0"></i>
                <span><?php echo $message; ?></span>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            
            <!-- Pilihan Mode -->
            <div class="grid grid-cols-2 gap-3 mb-6 p-1 bg-gray-100 rounded-xl">
                <label class="cursor-pointer">
                    <input type="radio" name="token_mode" value="manual" class="peer sr-only" <?php echo $current_mode == 'manual' ? 'checked' : ''; ?> onchange="toggleMode()">
                    <div class="text-center py-2 rounded-lg text-sm font-semibold text-gray-500 peer-checked:bg-white peer-checked:text-indigo-600 peer-checked:shadow-sm transition-all flex justify-center items-center gap-2">
                        <i data-lucide="hand" class="w-4 h-4"></i> Manual
                    </div>
                </label>
                <label class="cursor-pointer">
                    <input type="radio" name="token_mode" value="auto" class="peer sr-only" <?php echo $current_mode == 'auto' ? 'checked' : ''; ?> onchange="toggleMode()">
                    <div class="text-center py-2 rounded-lg text-sm font-semibold text-gray-500 peer-checked:bg-white peer-checked:text-indigo-600 peer-checked:shadow-sm transition-all flex justify-center items-center gap-2">
                        <i data-lucide="clock" class="w-4 h-4"></i> Otomatis
                    </div>
                </label>
            </div>

            <!-- Input Token Utama -->
            <div class="mb-4">
                <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Token Saat Ini</label>
                <div class="relative group">
                    <input type="text" name="token" id="tokenInput" value="<?php echo htmlspecialchars($current_token); ?>" 
                           class="w-full pl-12 pr-4 py-4 rounded-xl border border-gray-200 bg-white focus:ring-2 focus:ring-indigo-500 font-mono text-3xl tracking-[0.2em] font-bold text-indigo-700 text-center uppercase shadow-inner" 
                           placeholder="TOKEN" required>
                    <i data-lucide="key" class="absolute left-4 top-5 w-6 h-6 text-gray-300"></i>
                    
                    <!-- Tombol Generate hanya muncul jika manual (diatur via JS) atau user ingin memaksa ganti -->
                    <button type="button" onclick="generateToken()" class="absolute right-2 top-2 bottom-2 px-3 bg-gray-50 hover:bg-gray-100 text-gray-600 rounded-lg border border-gray-200 transition-colors" title="Acak Token">
                        <i data-lucide="refresh-cw" class="w-5 h-5"></i>
                    </button>
                </div>
            </div>

            <!-- Pengaturan Otomatis (Hidden by default) -->
            <div id="autoSettings" class="mb-6 <?php echo $current_mode == 'auto' ? '' : 'hidden'; ?>">
                <div class="bg-indigo-50 border border-indigo-100 rounded-xl p-4">
                    <label class="block text-sm font-semibold text-indigo-900 mb-2">Ganti Token Setiap (Menit):</label>
                    <div class="flex items-center gap-3">
                        <input type="number" name="auto_minutes" value="<?php echo $current_minutes; ?>" min="1" max="1440"
                               class="w-24 p-2 rounded-lg border-indigo-200 focus:ring-indigo-500 text-center font-bold text-indigo-700">
                        <span class="text-sm text-indigo-600">Menit</span>
                    </div>
                    <p class="text-xs text-indigo-500 mt-2 leading-relaxed">
                        <i data-lucide="info" class="w-3 h-3 inline"></i> 
                        Token akan diperbarui otomatis oleh sistem saat siswa mengakses ujian jika durasi telah habis. Notifikasi WA akan dikirim saat perubahan terjadi.
                    </p>
                </div>
            </div>

            <div class="flex flex-col gap-3 mt-6">
                <button type="submit" name="update_settings" class="w-full py-3.5 px-4 bg-indigo-600 text-white font-bold rounded-xl hover:bg-indigo-700 shadow-lg shadow-indigo-500/30 hover:-translate-y-0.5 transition-all flex justify-center items-center gap-2">
                    <i data-lucide="save" class="w-5 h-5"></i> Simpan Pengaturan & Kirim WA
                </button>
                
                <?php if($last_update): ?>
                    <p class="text-xs text-center text-gray-400 mt-2">
                        Terakhir diperbarui: <?php echo date('d M Y H:i', strtotime($last_update)); ?>
                    </p>
                <?php endif; ?>
            </div>

        </form>
        
        <div class="mt-6 text-center">
             <a href="dashboard.php" class="text-sm text-gray-500 hover:text-indigo-600 font-medium inline-flex items-center gap-1 transition-colors">
                <i data-lucide="arrow-left" class="w-4 h-4"></i> Kembali ke Dashboard
            </a>
        </div>

    </div>

    <script>
        lucide.createIcons();
        
        function toggleMode() {
            const mode = document.querySelector('input[name="token_mode"]:checked').value;
            const autoSettings = document.getElementById('autoSettings');
            const tokenInput = document.getElementById('tokenInput');

            if (mode === 'auto') {
                autoSettings.classList.remove('hidden');
                // tokenInput.setAttribute('readonly', true); // Optional: jika ingin token tidak bisa diedit saat auto
            } else {
                autoSettings.classList.add('hidden');
                tokenInput.removeAttribute('readonly');
            }
        }

        function generateToken() {
            const chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
            let result = '';
            for (let i = 0; i < 6; i++) {
                result += chars.charAt(Math.floor(Math.random() * chars.length));
            }
            const input = document.getElementById('tokenInput');
            input.value = result;
            
            // Visual feedback
            input.classList.add('text-green-600', 'scale-105');
            setTimeout(() => {
                input.classList.remove('text-green-600', 'scale-105');
            }, 200);
        }
    </script>
</body>
</html>