<?php
session_start();
include 'koneksi.php';

// --- 1. DOWNLOAD TEMPLATE CSV OTOMATIS (Logic harus paling atas) ---
if (isset($_GET['action']) && $_GET['action'] == 'download_template') {
    if (ob_get_level()) ob_end_clean();
    
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="template_guru_'.date('Ymd').'.csv"');
    
    $output = fopen('php://output', 'w');
    // Header Kolom
    fputcsv($output, array('Username', 'Password', 'Nama Lengkap', 'Mata Pelajaran', 'Nomor HP', 'Tanggal Lahir (YYYY-MM-DD)', 'Alamat'));
    // Data Dummy
    fputcsv($output, array('guru01', '123456', 'Ahmad Santoso', 'Matematika', '08123456789', '1985-08-17', 'Jl. Merdeka No. 45, Jakarta'));
    fputcsv($output, array('guru02', 'guru2024', 'Siti Aminah', 'Bahasa Inggris', '08567890123', '1990-12-01', 'Jl. Sudirman No. 10, Bandung'));
    
    fclose($output);
    exit;
}

// Cek akses admin
// Sesuaikan kondisi ini dengan session role di sistem Anda
if (!isset($_SESSION['role'])) { 
    header("Location: login.php");
    exit;
}

// --- [BARU] AMBIL DATA PENGATURAN SEKOLAH (Ditambahkan sesuai permintaan) ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; // Default jika db kosong

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            // Pastikan path ini sesuai dengan struktur folder Anda
            // Jika file ini ada di dalam folder 'admin', sesuaikan pathnya
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// --- 2. PROSES TAMBAH GURU ---
if (isset($_POST['tambah_guru'])) {
    $nama           = mysqli_real_escape_string($koneksi, $_POST['nama']);
    $username       = mysqli_real_escape_string($koneksi, $_POST['username']);
    $password       = mysqli_real_escape_string($koneksi, $_POST['password']); 
    $hp             = mysqli_real_escape_string($koneksi, $_POST['hp']);
    $mapel          = mysqli_real_escape_string($koneksi, $_POST['mata_pelajaran']);
    $tanggal_lahir  = mysqli_real_escape_string($koneksi, $_POST['tanggal_lahir']);
    $alamat         = mysqli_real_escape_string($koneksi, $_POST['alamat']);

    // Upload Foto
    $foto = $_FILES['foto']['name'];
    $foto_baru = "";
    if(!empty($foto)){
        $tmp = $_FILES['foto']['tmp_name'];
        $foto_baru = date('dmYHis') . '_' . $foto;
        $path = "uploads/" . $foto_baru;
        move_uploaded_file($tmp, $path);
    }

    $cek_user = mysqli_query($koneksi, "SELECT * FROM users WHERE username='$username'");
    if (mysqli_num_rows($cek_user) > 0) {
        echo "<script>alert('Username sudah digunakan!'); window.location='adminguru.php';</script>";
    } else {
        $sql = "INSERT INTO users (username, password, nama_lengkap, role, mata_pelajaran, nomor_hp, tanggal_lahir, alamat, foto) 
                VALUES ('$username', '$password', '$nama', 'guru', '$mapel', '$hp', '$tanggal_lahir', '$alamat', '$foto_baru')";
        
        if (mysqli_query($koneksi, $sql)) {
            echo "<script>alert('Guru berhasil ditambahkan!'); window.location='adminguru.php';</script>";
        } else {
            echo "<script>alert('Gagal database: " . mysqli_error($koneksi) . "');</script>";
        }
    }
}

// --- 3. PROSES EDIT GURU ---
if (isset($_POST['edit_guru'])) {
    $id             = $_POST['id_user'];
    $nama           = mysqli_real_escape_string($koneksi, $_POST['nama']);
    $username       = mysqli_real_escape_string($koneksi, $_POST['username']);
    $hp             = mysqli_real_escape_string($koneksi, $_POST['hp']);
    $mapel          = mysqli_real_escape_string($koneksi, $_POST['mata_pelajaran']);
    $tanggal_lahir  = mysqli_real_escape_string($koneksi, $_POST['tanggal_lahir']);
    $alamat         = mysqli_real_escape_string($koneksi, $_POST['alamat']);
    
    // Password (Update jika diisi)
    $password_query = "";
    if(!empty($_POST['password'])) {
        $password = mysqli_real_escape_string($koneksi, $_POST['password']);
        $password_query = ", password='$password'";
    }

    // Foto (Update jika ada upload baru)
    $foto_query = "";
    if(!empty($_FILES['foto']['name'])) {
        $foto = $_FILES['foto']['name'];
        $tmp = $_FILES['foto']['tmp_name'];
        $foto_baru = date('dmYHis') . '_' . $foto;
        $path = "uploads/" . $foto_baru;
        if(move_uploaded_file($tmp, $path)){
            $foto_query = ", foto='$foto_baru'";
        }
    }

    $sql = "UPDATE users SET 
            nama_lengkap='$nama', 
            username='$username', 
            mata_pelajaran='$mapel', 
            nomor_hp='$hp', 
            tanggal_lahir='$tanggal_lahir', 
            alamat='$alamat' 
            $password_query 
            $foto_query
            WHERE id='$id'";

    if (mysqli_query($koneksi, $sql)) {
        echo "<script>alert('Data Guru berhasil diperbarui!'); window.location='adminguru.php';</script>";
    } else {
        echo "<script>alert('Gagal update: " . mysqli_error($koneksi) . "');</script>";
    }
}

// --- 4. PROSES IMPORT CSV ---
if (isset($_POST['import_guru'])) {
    if(is_uploaded_file($_FILES['file_csv']['tmp_name'])){
        $csvFile = fopen($_FILES['file_csv']['tmp_name'], 'r');
        fgetcsv($csvFile); // Skip header

        $sukses = 0;
        $gagal = 0;

        while(($line = fgetcsv($csvFile)) !== FALSE){
            $username   = mysqli_real_escape_string($koneksi, $line[0]);
            $password   = mysqli_real_escape_string($koneksi, $line[1]);
            $nama       = mysqli_real_escape_string($koneksi, $line[2]);
            $mapel      = mysqli_real_escape_string($koneksi, $line[3]);
            $hp         = mysqli_real_escape_string($koneksi, $line[4]);
            $tgl_lahir  = mysqli_real_escape_string($koneksi, $line[5]);
            $alamat     = mysqli_real_escape_string($koneksi, $line[6]);

            $cek = mysqli_query($koneksi, "SELECT id FROM users WHERE username='$username'");
            if(mysqli_num_rows($cek) == 0 && !empty($username)){
                $sql = "INSERT INTO users (username, password, nama_lengkap, role, mata_pelajaran, nomor_hp, tanggal_lahir, alamat) 
                        VALUES ('$username', '$password', '$nama', 'guru', '$mapel', '$hp', '$tgl_lahir', '$alamat')";
                if(mysqli_query($koneksi, $sql)){
                    $sukses++;
                } else {
                    $gagal++;
                }
            } else {
                $gagal++;
            }
        }
        fclose($csvFile);
        echo "<script>alert('Import Selesai! Sukses: $sukses, Gagal/Duplikat: $gagal'); window.location='adminguru.php';</script>";
    }
}

// --- 5. HAPUS GURU ---
if (isset($_GET['hapus'])) {
    $id_guru = $_GET['hapus'];
    $del = mysqli_query($koneksi, "DELETE FROM users WHERE id='$id_guru' AND role='guru'");
    if($del){
        echo "<script>alert('Data guru berhasil dihapus.'); window.location='adminguru.php';</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Guru - Admin Panel</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Select2 & DataTables (Gaya Admin.php) -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    
    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
        .sidebar { min-height: 100vh; background: white; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .nav-link.active { background-color: #e8f5e9; color: #198754; font-weight: bold; border-left: 4px solid #198754; }
        .nav-link { color: #555; transition: 0.3s; }
        .nav-link:hover { background-color: #f8f9fa; color: #198754; }
        .nav-tabs .nav-link.active { background-color: #fff; border-bottom-color: #fff; color: #198754; font-weight: bold; }
        .tab-content { background: #fff; border: 1px solid #dee2e6; border-top: none; border-radius: 0 0 5px 5px; padding: 20px; }
        .avatar-small { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 1px solid #ddd; }
        
        /* Style untuk Logo di Sidebar */
        .sidebar-header {
            text-align: center;
            padding: 20px 10px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        .school-logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar d-none d-md-block p-0">
            
            <!-- [BARU] BAGIAN LOGO & NAMA SEKOLAH -->
            <div class="sidebar-header">
                <img src="<?= $logo_sekolah ?>" alt="Logo Sekolah" class="school-logo" onerror="this.onerror=null; this.src='https://via.placeholder.com/80?text=Logo';">
                <h6 class="fw-bold text-success m-0"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Admin Panel</small>
            </div>

            <ul class="nav flex-column px-2">
                <li class="nav-item"><a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li class="nav-item"><a href="admin_pelanggaran.php" class="nav-link"><i class="bi bi-pencil-square me-2"></i>Input Poin</a></li>
                <li class="nav-item"><a href="adminguru.php" class="nav-link active"><i class="bi bi-person-workspace me-2"></i>Data Guru</a></li>
                <li class="nav-item"><a href="admin_jadwa.php" class="nav-link"><i class="bi bi-calendar-week me-2"></i>Admin Jadwal</a></li>
                <li class="nav-item"><a href="admin_jenispoin.php" class="nav-link"><i class="bi bi-list-check me-2"></i>Jenis Pelanggaran</a></li>
                 <li class="nav-item"><a href="admin_laporanpelanggaran.php" class="nav-link"><i class="bi bi-file-earmark-text me-2"></i>Laporan</a></li>
                 <li class="nav-item"><a href="pengaturan_sekolah.php" class="nav-link"><i class="bi bi-gear me-2"></i>Pengaturan Sekolah</a></li>
                <li class="nav-item"><a href="logout.php" class="nav-link text-danger mt-3"><i class="bi bi-box-arrow-left me-2"></i>Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-10 p-4">
            <!-- [BARU] HEADER RESPONSIVE -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold"><i class="bi bi-person-workspace me-2"></i>Manajemen Data Guru</h4>
                <div class="d-block d-md-none">
                     <span class="fw-bold text-success"><?= $nama_sekolah ?></span>
                </div>
            </div>

            <!-- NAV TABS -->
            <ul class="nav nav-tabs" id="guruTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="daftar-tab" data-bs-toggle="tab" data-bs-target="#daftar" type="button" role="tab"><i class="bi bi-list-ul me-2"></i>Daftar Guru</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="tambah-tab" data-bs-toggle="tab" data-bs-target="#tambah" type="button" role="tab"><i class="bi bi-plus-circle me-2"></i>Tambah Manual</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="import-tab" data-bs-toggle="tab" data-bs-target="#import" type="button" role="tab"><i class="bi bi-file-earmark-spreadsheet me-2"></i>Import CSV</button>
                </li>
            </ul>

            <div class="tab-content shadow-sm" id="guruTabContent">
                
                <!-- TAB 1: DAFTAR GURU -->
                <div class="tab-pane fade show active" id="daftar" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered align-middle datatable-init" style="width:100%">
                            <thead class="table-success">
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="5%">Foto</th>
                                    <th>Nama Lengkap</th>
                                    <th>Mapel</th>
                                    <th>Kontak</th>
                                    <th>Username</th>
                                    <th width="10%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                $q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE role='guru' ORDER BY nama_lengkap ASC");
                                while($g = mysqli_fetch_assoc($q_guru)):
                                    $foto = !empty($g['foto']) ? 'uploads/'.$g['foto'] : 'https://via.placeholder.com/100?text=Guru';
                                ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td class="text-center"><img src="<?= $foto ?>" class="avatar-small"></td>
                                    <td><?= htmlspecialchars($g['nama_lengkap']) ?></td>
                                    <td><span class="badge bg-light text-dark border"><?= htmlspecialchars($g['mata_pelajaran']) ?></span></td>
                                    <td><?= htmlspecialchars($g['nomor_hp']) ?></td>
                                    <td><code><?= htmlspecialchars($g['username']) ?></code></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" 
                                            data-bs-toggle="modal" data-bs-target="#modalEditGuru"
                                            data-id="<?= $g['id'] ?>"
                                            data-nama="<?= htmlspecialchars($g['nama_lengkap']) ?>"
                                            data-username="<?= htmlspecialchars($g['username']) ?>"
                                            data-hp="<?= htmlspecialchars($g['nomor_hp']) ?>"
                                            data-mapel="<?= htmlspecialchars($g['mata_pelajaran']) ?>"
                                            data-tgl="<?= htmlspecialchars($g['tanggal_lahir']) ?>"
                                            data-alamat="<?= htmlspecialchars($g['alamat']) ?>"
                                            onclick="isiModalEdit(this)">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <a href="adminguru.php?hapus=<?= $g['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Yakin hapus guru ini?')">
                                            <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- TAB 2: TAMBAH GURU MANUAL -->
                <div class="tab-pane fade" id="tambah" role="tabpanel">
                    <form method="POST" enctype="multipart/form-data">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Nama Lengkap</label>
                                <input type="text" name="nama" class="form-control" required placeholder="Gelar lengkap">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Mata Pelajaran</label>
                                <select name="mata_pelajaran" class="form-select select-basic" required>
                                    <option value="">Pilih Mapel</option>
                                    <option value="Matematika">Matematika</option>
                                    <option value="Bahasa Indonesia">Bahasa Indonesia</option>
                                    <option value="Bahasa Inggris">Bahasa Inggris</option>
                                    <option value="Fisika">Fisika</option>
                                    <option value="Biologi">Biologi</option>
                                    <option value="Kimia">Kimia</option>
                                    <option value="Sejarah">Sejarah</option>
                                    <option value="Penjaskes">Penjaskes</option>
                                    <option value="Seni Budaya">Seni Budaya</option>
                                    <option value="Agama">Agama</option>
                                    <option value="PKN">PKN</option>
                                    <option value="BK">BK</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Username</label>
                                <input type="text" name="username" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Password</label>
                                <input type="text" name="password" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Nomor HP</label>
                                <input type="number" name="hp" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold small">Tanggal Lahir</label>
                                <input type="date" name="tanggal_lahir" class="form-control">
                            </div>
                            <div class="col-12">
                                <label class="form-label fw-bold small">Alamat</label>
                                <textarea name="alamat" class="form-control" rows="2"></textarea>
                            </div>
                            <div class="col-12">
                                <label class="form-label fw-bold small">Foto Profil</label>
                                <input type="file" name="foto" class="form-control" accept="image/*">
                            </div>
                            <div class="col-12 text-end mt-4">
                                <button type="submit" name="tambah_guru" class="btn btn-success px-4"><i class="bi bi-save me-2"></i>Simpan Guru</button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- TAB 3: IMPORT CSV -->
                <div class="tab-pane fade" id="import" role="tabpanel">
                    <div class="row justify-content-center py-4">
                        <div class="col-md-6 text-center">
                            <i class="bi bi-file-earmark-spreadsheet text-success display-1"></i>
                            <h5 class="fw-bold mt-3">Import Data Guru Massal</h5>
                            <p class="text-muted small">Gunakan file CSV untuk menambahkan banyak guru sekaligus.</p>
                            
                            <div class="d-grid gap-2 col-8 mx-auto mb-4">
                                <a href="?action=download_template" class="btn btn-outline-success btn-sm">
                                    <i class="bi bi-download me-1"></i> Download Template CSV
                                </a>
                            </div>

                            <form method="POST" enctype="multipart/form-data" class="text-start border p-4 rounded bg-light">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Upload File CSV</label>
                                    <input type="file" name="file_csv" class="form-control" accept=".csv" required>
                                </div>
                                <div class="d-grid">
                                    <button type="submit" name="import_guru" class="btn btn-primary">
                                        <i class="bi bi-upload me-2"></i> Import Sekarang
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- MODAL EDIT GURU -->
<div class="modal fade" id="modalEditGuru" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold">Edit Data Guru</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" name="id_user" id="edit_id">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold small">Nama Lengkap</label>
                            <input type="text" name="nama" id="edit_nama" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold small">Mata Pelajaran</label>
                            <select name="mata_pelajaran" id="edit_mapel" class="form-select" required>
                                <option value="Matematika">Matematika</option>
                                <option value="Bahasa Indonesia">Bahasa Indonesia</option>
                                <option value="Bahasa Inggris">Bahasa Inggris</option>
                                <option value="Fisika">Fisika</option>
                                <option value="Biologi">Biologi</option>
                                <option value="Kimia">Kimia</option>
                                <option value="Sejarah">Sejarah</option>
                                <option value="Penjaskes">Penjaskes</option>
                                <option value="Seni Budaya">Seni Budaya</option>
                                <option value="Agama">Agama</option>
                                <option value="PKN">PKN</option>
                                <option value="BK">BK</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold small">Username</label>
                            <input type="text" name="username" id="edit_username" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold small">Password Baru <span class="text-muted fw-normal">(Opsional)</span></label>
                            <input type="text" name="password" class="form-control" placeholder="Isi jika ingin ganti password">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold small">Nomor HP</label>
                            <input type="number" name="hp" id="edit_hp" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold small">Tanggal Lahir</label>
                            <input type="date" name="tanggal_lahir" id="edit_tgl" class="form-control">
                        </div>
                        <div class="col-12">
                            <label class="form-label fw-bold small">Alamat</label>
                            <textarea name="alamat" id="edit_alamat" class="form-control" rows="2"></textarea>
                        </div>
                        <div class="col-12">
                            <label class="form-label fw-bold small">Ganti Foto Profil</label>
                            <input type="file" name="foto" class="form-control" accept="image/*">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="edit_guru" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
        // Init DataTables (Fitur Search & Pagination Otomatis)
        $('.datatable-init').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json"
            }
        });
        
        // Init Select2
        $('.select-basic').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
    });

    // Fungsi Isi Modal Edit
    function isiModalEdit(btn) {
        document.getElementById('edit_id').value = btn.getAttribute('data-id');
        document.getElementById('edit_nama').value = btn.getAttribute('data-nama');
        document.getElementById('edit_username').value = btn.getAttribute('data-username');
        document.getElementById('edit_hp').value = btn.getAttribute('data-hp');
        document.getElementById('edit_mapel').value = btn.getAttribute('data-mapel');
        document.getElementById('edit_tgl').value = btn.getAttribute('data-tgl');
        document.getElementById('edit_alamat').value = btn.getAttribute('data-alamat');
    }
</script>
</body>
</html>