<?php
session_start();

// Aktifkan pelaporan kesalahan PHP untuk debugging. Hapus atau set ke 0 di produksi.
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Pastikan path ini benar untuk file koneksi database Anda
require_once 'config.php'; 

if (!isset($_SESSION['student_id'])) {
    header("Location: index.php?message=" . urlencode("Sesi Anda telah berakhir. Silakan login kembali.") . "&type=error");
    exit();
}

// === UPDATE STATUS ONLINE ===
if (isset($_SESSION['student_id'])) {
    $id_siswa_aktif = $_SESSION['student_id'];
    if(isset($conn)) {
        $conn->query("UPDATE students SET last_activity = NOW() WHERE id = '$id_siswa_aktif'");
    }
}

// Ambil data siswa
$student_id = htmlspecialchars($_SESSION['student_id']);
$student_name = htmlspecialchars($_SESSION['student_name']);
$student_class = htmlspecialchars($_SESSION['student_class']);
$current_device_id = session_id(); 

if (!$conn) {
    die("Kesalahan Fatal: Koneksi database tidak tersedia.");
}

// Ambil nama sekolah
$nama_sekolah_title = 'Nama Sekolah'; 
$query_setting = $conn->query("SELECT nama_sekolah FROM setting WHERE id = 1");
if ($query_setting && $query_setting->num_rows > 0) {
    $setting_data_for_title = $query_setting->fetch_assoc();
    $nama_sekolah_title = htmlspecialchars($setting_data_for_title['nama_sekolah']);
}

// Logika Deteksi Logout (Single Device)
$stmt = $conn->prepare("SELECT last_logged_in_device_id FROM students WHERE id = ?");
if ($stmt) {
    $stmt->bind_param("s", $_SESSION['student_id']);
    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $student_data_db = $result->fetch_assoc();
        $stmt->close(); 

        if (empty($student_data_db['last_logged_in_device_id']) || $student_data_db['last_logged_in_device_id'] !== $current_device_id) {
            session_unset();
            session_destroy();
            $conn->close();
            header("Location: index.php?message=" . urlencode("Sesi berakhir atau login di perangkat lain.") . "&type=error");
            exit();
        }
    } else {
        session_unset();
        session_destroy();
        header("Location: index.php?message=" . urlencode("Error sesi.") . "&type=error");
        exit();
    }
} else {
    session_unset();
    session_destroy();
    header("Location: index.php?message=" . urlencode("Error sistem.") . "&type=error");
    exit();
}
?><!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $nama_sekolah_title ?> - Ujian Online</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=JetBrains+Mono:wght@400;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-bg: #111827;
            --success-color: #10b981;
            --danger-color: #ef4444;
        }

        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            margin: 0;
            padding: 0;
            overflow: hidden;
            background-color: var(--primary-bg);
            color: #f3f4f6;
            display: flex;
            flex-direction: column;
            height: 100vh;
            user-select: none;
        }

        /* Header Styles */
        header {
            background: rgba(31, 41, 55, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .id-container {
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            transition: all 0.2s ease;
        }

        .id-container:hover {
            background-color: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.2);
        }

        .digital-font { font-family: 'JetBrains Mono', monospace; }

        .status-dot { height: 8px; width: 8px; border-radius: 50%; display: inline-block; }
        .status-online { background-color: var(--success-color); box-shadow: 0 0 8px var(--success-color); }
        .status-offline { background-color: var(--danger-color); box-shadow: 0 0 8px var(--danger-color); }

        #exam-iframe {
            width: 100%;
            height: calc(100vh - 72px);
            border: none;
            flex-grow: 1;
            background: white;
            transition: filter 0.2s;
        }

        /* Overlay Styles */
        .overlay, .rules-overlay { 
            position: fixed; inset: 0;
            background: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(5px);
            display: none; justify-content: center; align-items: center;
            z-index: 2000; animation: fadeIn 0.3s ease-out; padding: 20px;
        }

        .overlay-content, .rules-content { 
            background: #1f2937; padding: 40px; border-radius: 16px;
            max-width: 550px; width: 100%;
            box-shadow: 0 20px 25px -5px rgba(0,0,0,0.5);
            border: 1px solid rgba(255,255,255,0.1);
            text-align: center; position: relative; overflow: hidden;
        }

        .overlay-content::before, .rules-content::before {
            content: ''; position: absolute; top: 0; left: 0; width: 100%; height: 4px;
        }
        .overlay-content::before { background: linear-gradient(90deg, #ef4444, #f59e0b); }
        .rules-content::before { background: linear-gradient(90deg, #3b82f6, #10b981); }

        .rule-list { list-style: none; padding: 0; margin: 20px 0; text-align: left; }
        .rule-list li {
            margin-bottom: 12px; padding: 12px;
            background: rgba(255, 255, 255, 0.03);
            border-radius: 8px; display: flex; align-items: center; font-size: 0.95rem;
        }
        .rule-icon { margin-right: 12px; font-size: 1.2rem; }

        button.primary-btn {
            background: linear-gradient(to right, #3b82f6, #2563eb);
            color: white; border: none; padding: 12px 30px; border-radius: 8px;
            font-weight: 600; font-size: 1rem; cursor: pointer; width: 100%;
            transition: transform 0.2s;
        }
        button.primary-btn:hover { transform: translateY(-2px); }

        /* Toast Popup */
        .popup-message {
            position: fixed; top: 20px; left: 50%;
            transform: translateX(-50%) translateY(-100px);
            background-color: var(--success-color);
            color: white; padding: 12px 24px; border-radius: 50px;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.3);
            z-index: 3000; font-weight: 600; display: flex; align-items: center; gap: 10px;
            opacity: 0; transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            pointer-events: none; max-width: 90%; text-align: center;
        }
        .popup-message.show { transform: translateX(-50%) translateY(0); opacity: 1; }
        .popup-message svg { width: 24px; height: 24px; flex-shrink: 0; }

        /* Animation Keyframes */
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        @keyframes spin-once { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .animate-spin-once { animation: spin-once 0.5s ease-in-out; }
    </style>
</head>
<body id="mainBody">

    <input type="hidden" id="realStudentId" value="<?php echo $student_id; ?>">

    <header class="flex justify-between items-center h-[72px] px-6 shadow-lg z-50 transition-all" id="mainHeader">
        <div class="flex items-center space-x-4">
            <div class="flex flex-col">
                <span class="text-xs text-gray-400 font-medium uppercase tracking-wider">Siswa</span>
                <span class="text-base font-bold text-white tracking-tight"><?php echo $student_name; ?></span>
            </div>
        </div>

        <div class="hidden md:flex flex-col items-center justify-center text-gray-300">
             <div id="digitalClock" class="digital-font text-2xl font-bold text-white tracking-widest">00:00:00</div>
             <div id="digitalDate" class="text-xs text-gray-500 uppercase tracking-wide">Memuat...</div>
        </div>

        <div class="flex items-center gap-4">
            <div class="flex items-center gap-3 bg-gray-800/50 px-3 py-1.5 rounded-lg border border-gray-700">
                <div class="flex items-center gap-1.5">
                    <div id="networkIndicator" class="status-dot status-online"></div>
                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.111 16.404a5.5 5.5 0 017.778 0M12 20h.01m-7.08-7.071c3.904-3.905 10.236-3.905 14.141 0M1.394 9.393c5.857-5.857 15.355-5.857 21.213 0"></path></svg>
                </div>
                <div class="flex items-center gap-1.5" id="batteryContainer">
                    <span id="batteryLevel" class="text-xs font-mono text-gray-400">--%</span>
                    <svg id="batteryIcon" class="w-4 h-4 text-green-500" fill="currentColor" viewBox="0 0 20 20"><path d="M4 4a2 2 0 00-2 2v1h16V6a2 2 0 00-2-2H4z"></path><path fill-rule="evenodd" d="M18 9H2v5a2 2 0 002 2h12a2 2 0 002-2V9zM4 13a1 1 0 011-1h1a1 1 0 110 2H5a1 1 0 01-1-1zm5-1a1 1 0 100 2h1a1 1 0 100-2H9z" clip-rule="evenodd"></path></svg>
                </div>
            </div>

            <div class="id-container flex items-center px-4 py-2 gap-3 group">
                <div class="flex flex-col text-right">
                    <span class="text-[10px] text-gray-400 uppercase font-bold tracking-widest">ID Ujian</span>
                    <span class="text-sm font-mono font-bold text-gray-500 tracking-wider">******</span>
                </div>
                <div class="h-8 w-[1px] bg-gray-700"></div>
                <button id="copyQrCodeBtn" class="flex items-center justify-center p-2 rounded-full hover:bg-blue-500/20 text-gray-400 hover:text-blue-400 transition-all duration-300 active:scale-95" title="Salin ID Ujian">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-2M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v2M8 8H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-2m-8 0H8m4 0h2m-4 0a2 2 0 01-2 2h2a2 2 0 012-2z"/></svg>
                </button>
            </div>
        </div>
    </header>

    <iframe id="exam-iframe" src="https://smkpasundan3.com/JUJUR/cbt" allowfullscreen></iframe>

    <button id="refreshFrameBtn" class="fixed bottom-6 right-6 z-40 bg-gray-800/80 hover:bg-blue-600 text-white p-3 rounded-full shadow-[0_0_15px_rgba(0,0,0,0.5)] border border-gray-600/50 backdrop-blur-sm transition-all duration-300 group" title="Refresh Soal (Jika Error)">
        <svg id="refreshIcon" class="w-6 h-6 text-gray-200 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
        </svg>
    </button>
    <div id="popupMessage" class="popup-message">
        <svg id="popupIcon" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
        <span id="popupText" class="text-sm">Notifikasi</span>
    </div>

    <div class="overlay" id="cheatingOverlay">
        <div class="overlay-content border-red-500/30">
            <div class="mb-4 text-red-500"><svg class="w-16 h-16 mx-auto animate-bounce" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg></div>
            <h1 class="text-2xl font-bold text-white mb-2">Pelanggaran Terdeteksi!</h1>
            <p id="cheatingMessage" class="text-gray-300 mb-6">Aktivitas mencurigakan.</p>
            <div class="text-sm text-gray-500">Redirecting...</div>
        </div>
    </div>

    <div class="rules-overlay" id="rulesOverlay">
        <div class="rules-content">
            <div class="mb-4 text-blue-500"><svg class="w-12 h-12 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg></div>
            <h1 class="text-2xl font-bold text-white mb-1">Tata Tertib Ujian</h1>
            <p class="text-gray-400 mb-6 text-sm">Keamanan aktif penuh dalam <strong>5 Menit</strong>.</p>
            <ul class="rule-list">
                <li><span class="rule-icon">🖥️</span> <span>Wajib <strong>Layar Penuh</strong>.</span></li>
                <li><span class="rule-icon">🚫</span> <span>Dilarang <strong>Screenshot</strong> / Pindah Tab.</span></li>
            </ul>
            <button id="agreeRulesBtn" class="primary-btn">Siap, Mulai Ujian! 🚀</button>
        </div>
    </div>

    <script>
        const examIframe = document.getElementById('exam-iframe');
        const cheatingOverlay = document.getElementById('cheatingOverlay');
        const cheatingMessage = document.getElementById('cheatingMessage');
        const rulesOverlay = document.getElementById('rulesOverlay');
        const agreeRulesBtn = document.getElementById('agreeRulesBtn');
        const copyQrCodeBtn = document.getElementById('copyQrCodeBtn');
        const realStudentId = document.getElementById('realStudentId'); 
        const popupMessage = document.getElementById('popupMessage');
        const popupText = document.getElementById('popupText');
        const popupIcon = document.getElementById('popupIcon');

        // Status Elements
        const digitalClock = document.getElementById('digitalClock');
        const digitalDate = document.getElementById('digitalDate');
        const batteryLevel = document.getElementById('batteryLevel');
        const batteryIcon = document.getElementById('batteryIcon');
        const networkIndicator = document.getElementById('networkIndicator');

        // --- NEW: REFRESH BUTTON LOGIC ---
        const refreshFrameBtn = document.getElementById('refreshFrameBtn');
        const refreshIcon = document.getElementById('refreshIcon');

        refreshFrameBtn.addEventListener('click', () => {
            // Animasi Putar Icon
            refreshIcon.classList.add('animate-spin-once');
            setTimeout(() => {
                refreshIcon.classList.remove('animate-spin-once');
            }, 500); // Sesuai durasi CSS animation

            // Refresh hanya iframenya, bukan halaman induk
            try {
                if(examIframe.contentWindow) {
                    examIframe.contentWindow.location.reload();
                    showPopupMessage("Memuat ulang soal...", "warning");
                }
            } catch (e) {
                // Fallback jika blocked frame origin, reset src
                const currentSrc = examIframe.src;
                examIframe.src = currentSrc;
                showPopupMessage("Memuat ulang soal...", "warning");
            }
        });
        // ---------------------------------

        let lastActivityTime = Date.now();
        const activityTimeout = 1800000; 
        const SECURITY_DELAY_MS = 300000; // 5 Menit
        let securityActive = false;

        // Clock
        function updateClock() {
            const now = new Date();
            digitalClock.textContent = now.toLocaleTimeString('id-ID', { hour12: false });
            digitalDate.textContent = now.toLocaleDateString('id-ID', { weekday: 'long', day: 'numeric', month: 'long', year: 'numeric' });
        }
        setInterval(updateClock, 1000); updateClock();

        // Battery
        if ('getBattery' in navigator) {
            navigator.getBattery().then(function(battery) {
                function updateBatteryInfo() {
                    const level = Math.round(battery.level * 100);
                    batteryLevel.textContent = level + "%";
                    batteryIcon.classList.toggle('text-red-500', level <= 20);
                    batteryIcon.classList.toggle('text-green-500', level > 20);
                }
                updateBatteryInfo(); battery.addEventListener('levelchange', updateBatteryInfo);
            });
        }

        // Network
        window.addEventListener('online', () => {
            networkIndicator.className = 'status-dot status-online';
            showPopupMessage("Koneksi Internet Pulih", "success");
        });
        window.addEventListener('offline', () => {
            networkIndicator.className = 'status-dot status-offline';
            showPopupMessage("Koneksi Terputus!", "error");
        });

        // Notifications
        function showPopupMessage(message, type = 'success') {
            popupText.textContent = message;
            popupMessage.className = 'popup-message';
            
            if(type === 'error') {
                popupMessage.style.backgroundColor = '#ef4444';
                popupIcon.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>';
            } else if (type === 'warning') {
                popupMessage.style.backgroundColor = '#f59e0b';
                popupIcon.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>';
            } else {
                popupMessage.style.backgroundColor = '#10b981';
                popupIcon.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path>';
            }
            
            void popupMessage.offsetWidth;
            popupMessage.classList.add('show');
            setTimeout(() => popupMessage.classList.remove('show'), 4000);
        }

        // Copy ID
        if (copyQrCodeBtn) {
            copyQrCodeBtn.addEventListener('click', () => {
                const textToCopy = realStudentId.value.trim();
                const successMsg = "ID Tersalin! Paste di Username & Password.";
                if (navigator.clipboard && window.isSecureContext) {
                    navigator.clipboard.writeText(textToCopy).then(() => showPopupMessage(successMsg)).catch(() => fallbackCopyText(textToCopy, successMsg));
                } else {
                    fallbackCopyText(textToCopy, successMsg);
                }
            });
        }

        function fallbackCopyText(text, successMsg) {
            const ta = document.createElement('textarea'); ta.value = text;
            document.body.appendChild(ta); ta.select();
            try { document.execCommand('copy'); showPopupMessage(successMsg); } 
            catch (err) { showPopupMessage("Gagal menyalin ID.", "error"); }
            document.body.removeChild(ta);
        }

        // Security Violation Handler
        function showCheatingOverlayAndLogout(message) {
            if (!securityActive) return;
            if (navigator.clipboard) navigator.clipboard.writeText("PELANGGARAN");
            cheatingMessage.textContent = message;
            cheatingOverlay.style.display = "flex";
            document.body.style.pointerEvents = 'none'; 
            if (window.securityInterval) clearInterval(window.securityInterval);
            setTimeout(() => { window.location.href = "index.php?message=" + encodeURIComponent(message) + "&type=error"; }, 2000); 
        }

        function enterFullscreen() {
            if (!document.fullscreenElement) {
                document.documentElement.requestFullscreen().catch(err => console.log(err));
            }
        }

        document.addEventListener('fullscreenchange', () => {
            if (securityActive && !document.fullscreenElement) {
                window.location.href = "index.php?message=" + encodeURIComponent("Keluar Fullscreen = Diskualifikasi.") + "&type=error";
            }
        });

        window.addEventListener('load', () => rulesOverlay.style.display = "flex");

        agreeRulesBtn.addEventListener('click', () => {
            rulesOverlay.style.display = "none";
            enterFullscreen();
            showPopupMessage("Mode Persiapan: Aman dalam 5 Menit.", "warning");
            setTimeout(() => {
                securityActive = true;
                activateSecurity();
                showPopupMessage("⚠️ PERHATIAN: Keamanan Ujian AKTIF!", "error");
            }, SECURITY_DELAY_MS); 
        });

        function activateSecurity() {
            document.addEventListener('contextmenu', e => e.preventDefault());
            window.addEventListener('blur', () => document.title = "KEMBALI KE UJIAN!");
            window.addEventListener('focus', () => document.title = "<?= $nama_sekolah_title ?> - Ujian Online");
            document.addEventListener('visibilitychange', () => {
                if (document.hidden) showCheatingOverlayAndLogout("Dilarang membuka tab lain!");
            });

            document.addEventListener('keydown', (e) => {
                if (e.key === 'PrintScreen') {
                    e.preventDefault(); navigator.clipboard.writeText('');
                    showCheatingOverlayAndLogout("Screenshot dilarang!");
                    return false;
                }
                if ((e.ctrlKey || e.metaKey) && ['p','s','u'].includes(e.key.toLowerCase())) {
                    e.preventDefault(); showCheatingOverlayAndLogout("Shortcut dilarang!");
                }
            });

            const checkScreen = () => {
                const threshold = 160;
                if ((window.outerWidth - window.innerWidth > threshold) || (window.outerHeight - window.innerHeight > threshold)) {
                    showCheatingOverlayAndLogout("Tutup Inspect Element!");
                }
            };

            ['mousemove', 'keydown', 'click', 'scroll'].forEach(evt => document.addEventListener(evt, () => lastActivityTime = Date.now()));

            window.securityInterval = setInterval(() => {
                checkScreen();
                if (Date.now() - lastActivityTime > activityTimeout) showCheatingOverlayAndLogout("Sesi habis (tidak aktif).");
            }, 2000);
        }

        examIframe.addEventListener('load', () => { if (examIframe.contentWindow) examIframe.contentWindow.focus(); });
    </script>
</body>
</html>