<?php
session_start();
include 'koneksi.php';

// Cek akses admin
if (!isset($_SESSION['role'])) {
    // Jika request via AJAX tapi session mati, hentikan
    if (isset($_GET['ajax'])) { exit("Session expired. Silakan login ulang."); }
    header("Location: login.php");
    exit;
}

// ==========================================
// BAGIAN 1: HANDLE REQUEST AJAX
// (Bagian ini hanya berjalan saat dipanggil Javascript)
// ==========================================
if (isset($_GET['ajax']) && $_GET['ajax'] == '1') {
    
    // --- LOGIKA FILTER DARI AJAX ---
    $filter_kelas = isset($_GET['kelas']) ? $_GET['kelas'] : '';
    $search_query = isset($_GET['q']) ? $_GET['q'] : '';

    // --- BUILD QUERY ---
    $base_query = "SELECT id, qr_code_content, nama, password, kelas, ruangan, foto, nomor_wa, 
                   last_logged_in_device_id, last_activity, poin_sekarang, sisa_poin 
                   FROM students WHERE 1=1";

    if (!empty($filter_kelas)) {
        $base_query .= " AND kelas = '" . mysqli_real_escape_string($koneksi, $filter_kelas) . "'";
    }

    if (!empty($search_query)) {
        $safe_search = mysqli_real_escape_string($koneksi, $search_query);
        $base_query .= " AND (nama LIKE '%$safe_search%' OR qr_code_content LIKE '%$safe_search%')";
    }

    $base_query .= " ORDER BY kelas ASC, nama ASC";

    $result = mysqli_query($koneksi, $base_query);
    $no = 1;

    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            // Foto handling
            $foto_path = !empty($row['foto']) ? 'uploads/siswa/'.$row['foto'] : 'assets/img/default-user.png';
            $last_act = !empty($row['last_activity']) ? date('d/m/Y H:i', strtotime($row['last_activity'])) : '<span class="text-muted small">Belum aktif</span>';
            $poin_color = ($row['sisa_poin'] < 50) ? 'text-danger' : 'text-success';

            echo "<tr>";
            echo "<td class='text-center fw-bold text-muted'>{$no}</td>";
            echo "<td class='text-center'>
                    <img src='{$foto_path}' class='avatar-img' onerror=\"this.onerror=null;this.src='https://via.placeholder.com/40?text=Siswa';\">
                  </td>";
            echo "<td>
                    <div class='fw-bold'>{$row['nama']}</div>
                    <small class='text-muted'><i class='bi bi-qr-code me-1'></i>{$row['qr_code_content']}</small>
                  </td>";
            echo "<td>
                    <span class='badge bg-primary bg-opacity-10 text-primary'>{$row['kelas']}</span>
                    <div class='small text-muted mt-1'>R. {$row['ruangan']}</div>
                  </td>";
            echo "<td>
                    <div class='small'><i class='bi bi-key me-1 text-warning'></i>Pass: <code>{$row['password']}</code></div>
                    <div class='small mt-1'><i class='bi bi-whatsapp me-1 text-success'></i>{$row['nomor_wa']}</div>
                  </td>";
            echo "<td class='text-center'>
                    <div class='fw-bold {$poin_color}' style='font-size: 1.1em;'>{$row['sisa_poin']}</div>
                    <small class='text-muted' style='font-size: 0.7em;'>Current: {$row['poin_sekarang']}</small>
                  </td>";
            echo "<td>
                    <div class='small fw-bold'>{$last_act}</div>
                    <span class='badge bg-secondary device-badge text-truncate' title='{$row['last_logged_in_device_id']}'>
                        <i class='bi bi-phone me-1'></i>{$row['last_logged_in_device_id']}
                    </span>
                  </td>";
            echo "<td class='text-center'>
                    <a href='edit_siswa.php?id={$row['id']}' class='btn btn-sm btn-outline-primary me-1' title='Edit'><i class='bi bi-pencil'></i></a>
                    <a href='admin_datasiswa.php?hapus={$row['id']}' class='btn btn-sm btn-outline-danger' title='Hapus' onclick=\"return confirm('Yakin ingin menghapus data siswa ini?');\"><i class='bi bi-trash'></i></a>
                  </td>";
            echo "</tr>";
            $no++;
        }
    } else {
        echo "<tr><td colspan='8' class='text-center py-5 text-muted'>
                <i class='bi bi-search display-6 d-block mb-3'></i>
                Data siswa tidak ditemukan.
              </td></tr>";
    }
    
    // PENTING: Stop eksekusi agar HTML di bawah tidak ikut ter-render saat request AJAX
    exit; 
}


// ==========================================
// BAGIAN 2: TAMPILAN HALAMAN UTAMA (HTML)
// (Bagian ini berjalan saat halaman dibuka biasa)
// ==========================================

// --- AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; 

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// --- LOGIKA HAPUS SISWA ---
if (isset($_GET['hapus'])) {
    $id_hapus = $_GET['hapus'];
    $q_foto = mysqli_query($koneksi, "SELECT foto FROM students WHERE id='$id_hapus'");
    $d_foto = mysqli_fetch_assoc($q_foto);
    if (!empty($d_foto['foto']) && file_exists('uploads/siswa/'.$d_foto['foto'])) {
        unlink('uploads/siswa/'.$d_foto['foto']);
    }
    
    $del = mysqli_query($koneksi, "DELETE FROM students WHERE id='$id_hapus'");
    if ($del) {
        echo "<script>alert('Data siswa berhasil dihapus!'); window.location='admin_datasiswa.php';</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Siswa - Admin Panel</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    
    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
        .sidebar { min-height: 100vh; background: white; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .nav-link.active { background-color: #e8f5e9; color: #198754; font-weight: bold; border-left: 4px solid #198754; }
        .nav-link { color: #555; transition: 0.3s; }
        .nav-link:hover { background-color: #f8f9fa; color: #198754; }
        .sidebar-header { text-align: center; padding: 20px 10px; border-bottom: 1px solid #eee; margin-bottom: 20px; }
        .school-logo { width: 80px; height: 80px; object-fit: contain; margin-bottom: 10px; }
        .avatar-img { width: 40px; height: 40px; object-fit: cover; border-radius: 50%; border: 1px solid #dee2e6; }
        .device-badge { font-size: 0.75rem; max-width: 150px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: inline-block; }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar d-none d-md-block p-0">
            <div class="sidebar-header">
                <img src="<?= $logo_sekolah ?>" alt="Logo Sekolah" class="school-logo" onerror="this.onerror=null; this.src='https://via.placeholder.com/80?text=Logo';">
                <h6 class="fw-bold text-success m-0"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Admin Panel</small>
            </div>
            <ul class="nav flex-column px-2">
                <li class="nav-item"><a href="dashboard.php" class="nav-link"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li class="nav-item"><a href="admin_datasiswa.php" class="nav-link active"><i class="bi bi-people-fill me-2"></i>Data Siswa</a></li>
                <li class="nav-item"><a href="admin_pelanggaran.php" class="nav-link"><i class="bi bi-pencil-square me-2"></i>Input Poin</a></li>
                <li class="nav-item"><a href="adminguru.php" class="nav-link"><i class="bi bi-person-workspace me-2"></i>Data Guru</a></li>
                <li class="nav-item"><a href="admin_jadwa.php" class="nav-link"><i class="bi bi-calendar-week me-2"></i>Admin Jadwal</a></li>
                <li class="nav-item"><a href="admin_jenispoin.php" class="nav-link"><i class="bi bi-list-check me-2"></i>Jenis Pelanggaran</a></li>
                <li class="nav-item"><a href="admin_laporanpelanggaran.php" class="nav-link"><i class="bi bi-file-earmark-text me-2"></i>Laporan</a></li>
                <li class="nav-item"><a href="pengaturan_sekolah.php" class="nav-link"><i class="bi bi-gear me-2"></i>Pengaturan Sekolah</a></li>
                <li class="nav-item"><a href="logout.php" class="nav-link text-danger mt-3"><i class="bi bi-box-arrow-left me-2"></i>Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-10 p-4">
            
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold"><i class="bi bi-people-fill me-2"></i>Manajemen Data Siswa</h4>
                <div class="d-block d-md-none">
                     <span class="fw-bold text-success"><?= $nama_sekolah ?></span>
                </div>
            </div>

            <!-- FILTER CARD -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-white py-3">
                    <h6 class="fw-bold mb-0 text-secondary"><i class="bi bi-filter me-2"></i>Filter Data Real-time</h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label fw-bold small">Filter Kelas</label>
                            <select id="filter_kelas" class="form-select select2-simple">
                                <option value="">-- Semua Kelas --</option>
                                <?php
                                $q_kelas = mysqli_query($koneksi, "SELECT DISTINCT kelas FROM students ORDER BY kelas ASC");
                                while($k = mysqli_fetch_assoc($q_kelas)):
                                ?>
                                    <option value="<?= $k['kelas'] ?>"><?= $k['kelas'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label fw-bold small">Cari Nama / QR Code</label>
                            <input type="text" id="keyword_pencarian" class="form-control" placeholder="Ketik nama atau scan kode QR..." autocomplete="off">
                        </div>
                    </div>
                </div>
            </div>

            <!-- DATA TABLE CARD -->
            <div class="card shadow-sm border-0 position-relative">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover align-middle mb-0">
                            <thead class="table-success text-nowrap">
                                <tr>
                                    <th class="text-center" width="5%">No</th>
                                    <th class="text-center" width="8%">Foto</th>
                                    <th>Nama Siswa & QR</th>
                                    <th>Kelas / Ruang</th>
                                    <th>Kredensial</th>
                                    <th class="text-center">Poin</th>
                                    <th>Aktivitas Terakhir</th>
                                    <th class="text-center">Aksi</th>
                                </tr>
                            </thead>
                            <tbody id="tabel-siswa-body">
                                <!-- Data akan dimuat otomatis oleh AJAX -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        // Init Select2
        $('.select2-simple').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });

        // FUNGSI LOAD DATA AJAX
        function loadData() {
            var kelas = $('#filter_kelas').val();
            var keyword = $('#keyword_pencarian').val();
            
            // Perhatikan URL: admin_datasiswa.php?ajax=1
            // Kita mengirim request ke FILE INI SENDIRI
            $.ajax({
                url: 'admin_datasiswa.php?ajax=1',
                type: 'GET',
                data: {
                    kelas: kelas,
                    q: keyword
                },
                success: function(response) {
                    $('#tabel-siswa-body').html(response);
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error: " + error);
                }
            });
        }

        // Panggil fungsi saat halaman pertama dibuka
        loadData();

        // Event Listeners
        $('#keyword_pencarian').on('keyup', function() { loadData(); });
        $('#filter_kelas').on('change', function() { loadData(); });
    });
</script>
</body>
</html>