<?php
session_start();
include 'koneksi.php';

// Cek akses admin
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

// --- [BARU] AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; // Default jika db kosong

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            // Pastikan path ini sesuai dengan struktur folder Anda
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// --- 1. AMBIL DATA STATISTIK UTAMA ---
// Total Siswa
$q_siswa = mysqli_query($koneksi, "SELECT COUNT(*) as total FROM students");
$d_siswa = mysqli_fetch_assoc($q_siswa);
$total_siswa = $d_siswa['total'];

// Total Guru
$q_guru = mysqli_query($koneksi, "SELECT COUNT(*) as total FROM users WHERE role='guru'");
$d_guru = mysqli_fetch_assoc($q_guru);
$total_guru = $d_guru['total'];

// Total Pelanggaran Bulan Ini (Tambahan Statistik)
$bulan_ini = date('Y-m');
$q_pelanggaran = mysqli_query($koneksi, "SELECT COUNT(*) as total FROM riwayat_pelanggaran WHERE DATE_FORMAT(tanggal, '%Y-%m') = '$bulan_ini'");
$d_pelanggaran = mysqli_fetch_assoc($q_pelanggaran);
$total_pelanggaran_bulan_ini = $d_pelanggaran['total'];


// --- 2. DATA UNTUK GRAFIK KELAS (Top 5 Kelas Paling Sering Melanggar) ---
$query_chart = "
    SELECT s.kelas, COUNT(r.id) as jumlah_pelanggaran 
    FROM riwayat_pelanggaran r 
    JOIN students s ON r.student_id = s.id 
    GROUP BY s.kelas 
    ORDER BY jumlah_pelanggaran DESC 
    LIMIT 10
";
$res_chart = mysqli_query($koneksi, $query_chart);

$chart_labels = [];
$chart_data   = [];

while($row = mysqli_fetch_assoc($res_chart)) {
    $chart_labels[] = $row['kelas'];
    $chart_data[]   = $row['jumlah_pelanggaran'];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Monitoring Poin</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
        .sidebar { min-height: 100vh; background: white; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .nav-link.active { background-color: #e8f5e9; color: #198754; font-weight: bold; border-left: 4px solid #198754; }
        .nav-link { color: #555; transition: 0.3s; }
        .nav-link:hover { background-color: #f8f9fa; color: #198754; }
        .card-stat { border: none; border-radius: 10px; transition: transform 0.2s; }
        .card-stat:hover { transform: translateY(-5px); }
        .icon-box { width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; border-radius: 10px; font-size: 24px; }
        
        /* [BARU] Style untuk Logo di Sidebar */
        .sidebar-header {
            text-align: center;
            padding: 20px 10px;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
        }
        .school-logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar d-none d-md-block p-0">
            
            <!-- [BARU] BAGIAN LOGO & NAMA SEKOLAH -->
            <div class="sidebar-header">
                <img src="<?= $logo_sekolah ?>" alt="Logo Sekolah" class="school-logo" onerror="this.onerror=null; this.src='https://via.placeholder.com/80?text=Logo';">
                <h6 class="fw-bold text-success m-0"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Admin Panel</small>
            </div>

            <ul class="nav flex-column px-2">
                <li class="nav-item"><a href="dashboard.php" class="nav-link active"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                <li class="nav-item"><a href="admin_pelanggaran.php" class="nav-link"><i class="bi bi-pencil-square me-2"></i>Input Poin</a></li>
                <li class="nav-item"><a href="adminguru.php" class="nav-link"><i class="bi bi-person-workspace me-2"></i>Data Guru</a></li>
                <li class="nav-item"><a href="admin_jadwa.php" class="nav-link"><i class="bi bi-calendar-week me-2"></i>Admin Jadwal</a></li>
                <li class="nav-item"><a href="admin_jenispoin.php" class="nav-link"><i class="bi bi-list-check me-2"></i>Jenis Pelanggaran</a></li>
                 <li class="nav-item"><a href="admin_laporanpelanggaran.php" class="nav-link"><i class="bi bi-file-earmark-text me-2"></i>Laporan</a></li>
                 <li class="nav-item"><a href="pengaturan_sekolah.php" class="nav-link"><i class="bi bi-gear me-2"></i>Pengaturan Sekolah</a></li>
                <li class="nav-item"><a href="logout.php" class="nav-link text-danger mt-3"><i class="bi bi-box-arrow-left me-2"></i>Logout</a></li>
            </ul>
        </div>
        
        <!-- MAIN CONTENT -->
        <div class="col-md-10 p-4">
            
            <!-- [BARU] HEADER RESPONSIVE -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold">Dashboard Monitoring</h4>
                <div class="d-block d-md-none">
                     <span class="fw-bold text-success"><?= $nama_sekolah ?></span>
                </div>
            </div>

            <!-- 1. KARTU STATISTIK -->
            <div class="row g-3 mb-4">
                <!-- Total Siswa -->
                <div class="col-md-4">
                    <div class="card card-stat shadow-sm h-100">
                        <div class="card-body d-flex align-items-center">
                            <div class="icon-box bg-primary bg-opacity-10 text-primary me-3">
                                <i class="bi bi-people-fill"></i>
                            </div>
                            <div>
                                <h6 class="text-muted mb-0 small text-uppercase">Total Siswa</h6>
                                <h3 class="fw-bold mb-0"><?= $total_siswa ?></h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Total Guru -->
                <div class="col-md-4">
                    <div class="card card-stat shadow-sm h-100">
                        <div class="card-body d-flex align-items-center">
                            <div class="icon-box bg-success bg-opacity-10 text-success me-3">
                                <i class="bi bi-person-badge-fill"></i>
                            </div>
                            <div>
                                <h6 class="text-muted mb-0 small text-uppercase">Total Guru</h6>
                                <h3 class="fw-bold mb-0"><?= $total_guru ?></h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pelanggaran Bulan Ini -->
                <div class="col-md-4">
                    <div class="card card-stat shadow-sm h-100">
                        <div class="card-body d-flex align-items-center">
                            <div class="icon-box bg-danger bg-opacity-10 text-danger me-3">
                                <i class="bi bi-exclamation-triangle-fill"></i>
                            </div>
                            <div>
                                <h6 class="text-muted mb-0 small text-uppercase">Pelanggaran (<?= date('M Y') ?>)</h6>
                                <h3 class="fw-bold mb-0"><?= $total_pelanggaran_bulan_ini ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- 2. CONTENT AREA: GRAFIK & SISWA BERMASALAH -->
            <div class="row g-4">
                
                <!-- GRAFIK KELAS -->
                <div class="col-lg-7">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-header bg-white py-3">
                            <h6 class="fw-bold m-0 text-dark"><i class="bi bi-bar-chart-fill me-2"></i>Kelas Paling Banyak Melanggar</h6>
                        </div>
                        <div class="card-body">
                            <canvas id="kelasChart" style="max-height: 350px;"></canvas>
                        </div>
                    </div>
                </div>

                <!-- TOP 10 SISWA POIN TERENDAH -->
                <div class="col-lg-5">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <h6 class="fw-bold m-0 text-danger"><i class="bi bi-person-exclamation me-2"></i>10 Siswa Poin Terendah</h6>
                            <span class="badge bg-danger">Perhatian</span>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover align-middle mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th class="ps-3">Nama Siswa</th>
                                            <th>Kelas</th>
                                            <th class="text-center">Sisa Poin</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        // Query Top 10 Siswa (Sisa Poin Ascending)
                                        $q_top = mysqli_query($koneksi, "SELECT nama, kelas, sisa_poin FROM students ORDER BY sisa_poin ASC LIMIT 10");
                                        
                                        if (mysqli_num_rows($q_top) > 0) {
                                            while($st = mysqli_fetch_assoc($q_top)) {
                                                // Warna baris jika poin kritis (misal dibawah 50)
                                                $bg_class = ($st['sisa_poin'] <= 25) ? 'bg-danger bg-opacity-10' : '';
                                                $text_class = ($st['sisa_poin'] <= 50) ? 'text-danger fw-bold' : 'text-dark fw-bold';
                                                
                                                echo "<tr class='$bg_class'>";
                                                echo "<td class='ps-3'>" . htmlspecialchars($st['nama']) . "</td>";
                                                echo "<td>" . htmlspecialchars($st['kelas']) . "</td>";
                                                echo "<td class='text-center $text_class'>" . $st['sisa_poin'] . "</td>";
                                                echo "</tr>";
                                            }
                                        } else {
                                            echo "<tr><td colspan='3' class='text-center py-3 text-muted'>Data siswa kosong.</td></tr>";
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer bg-white text-center border-0">
                            <small class="text-muted">Data diurutkan dari poin terkecil.</small>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- Script Chart.js -->
<script>
    const ctx = document.getElementById('kelasChart').getContext('2d');
    const kelasChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?= json_encode($chart_labels) ?>,
            datasets: [{
                label: 'Jumlah Pelanggaran',
                data: <?= json_encode($chart_data) ?>,
                backgroundColor: 'rgba(25, 135, 84, 0.6)', // Warna Hijau (sesuai tema)
                borderColor: 'rgba(25, 135, 84, 1)',
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });
</script>

</body>
</html>