<?php
session_start();
include 'koneksi.php';

// 1. Cek akses guru
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];

// --- AMBIL DATA USER (GURU) ---
$q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
$guru = mysqli_fetch_assoc($q_guru);

// --- AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; 

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if (mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// Setup Foto Profil
$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}

// --- LOGIKA JADWAL ---
// Mengambil data jadwal guru yang login, diurutkan berdasarkan hari (Senin-Minggu) dan jam mulai
$query_jadwal = "
    SELECT * FROM jadwal_mengajar 
    WHERE id_guru = '$id_guru' 
    ORDER BY FIELD(hari, 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu', 'Minggu'), jam_mulai ASC
";
$result_jadwal = mysqli_query($koneksi, $query_jadwal);

// Grouping data by Hari untuk tampilan yang rapi
$jadwal_by_day = [];
if ($result_jadwal) {
    while ($row = mysqli_fetch_assoc($result_jadwal)) {
        $jadwal_by_day[$row['hari']][] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jadwal Mengajar - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        /* --- CSS GLOBAL --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- JADWAL CARD STYLE --- */
        .day-header {
            border-left: 5px solid #198754;
            padding-left: 15px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        .day-title { font-weight: 700; font-size: 1.2rem; color: #333; margin: 0; }
        .day-badge { background-color: #e8f5e9; color: #198754; font-size: 0.8rem; padding: 5px 10px; border-radius: 20px; margin-left: 10px; }

        .schedule-item {
            transition: transform 0.2s;
            border: 1px solid #f0f0f0;
        }
        .schedule-item:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            border-color: #198754;
        }
        .time-box {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 8px;
            text-align: center;
            min-width: 85px;
        }
        .time-start { font-weight: bold; font-size: 1.1rem; color: #198754; line-height: 1; }
        .time-end { font-size: 0.8rem; color: #6c757d; }

        /* --- MOBILE BOTTOM NAV --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Guru</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
                <small class="text-muted">Guru</small>
            </li>
            <li><a class="dropdown-item" href="profil.php"><i class="bi bi-person me-2"></i> Profil</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="absenguru.php" class="nav-link"><i class="bi bi-camera-fill"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="koperasi.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                
                <!-- Menu Jadwal Aktif -->
                <li class="nav-item"><a href="jadwal.php" class="nav-link active"><i class="bi bi-calendar-week"></i> Jadwal</a></li>
                
                <li class="nav-item"><a href="guru_reset.php" class="nav-link"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                <li class="nav-item"><a href="soal2.php" class="nav-link"><i class="bi bi-file-earmark-text-fill"></i> Bank Soal</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold mb-0">Jadwal Mengajar</h4>
                <div class="text-muted small">
                    <i class="bi bi-clock me-1"></i> Tahun Ajaran Aktif
                </div>
            </div>

            <!-- JADWAL CONTAINER -->
            <?php if (empty($jadwal_by_day)): ?>
                <div class="text-center py-5 text-muted">
                    <div class="mb-3"><i class="bi bi-calendar-x display-1 opacity-25"></i></div>
                    <h5>Belum ada jadwal mengajar.</h5>
                    <p class="small">Hubungi kurikulum jika jadwal belum tampil.</p>
                </div>
            <?php else: ?>
                
                <div class="row">
                    <?php foreach ($jadwal_by_day as $hari => $data_jadwal): ?>
                        <div class="col-12 mb-4">
                            <div class="card border-0 shadow-sm rounded-4 h-100">
                                <div class="card-body">
                                    
                                    <!-- Header Hari -->
                                    <div class="day-header">
                                        <h5 class="day-title"><?= $hari ?></h5>
                                        <span class="day-badge"><?= count($data_jadwal) ?> Jam Pelajaran</span>
                                    </div>

                                    <!-- List Jadwal Hari Ini -->
                                    <div class="row g-3">
                                        <?php foreach ($data_jadwal as $j): ?>
                                            <div class="col-md-6 col-lg-4">
                                                <div class="schedule-item p-3 rounded-3 bg-white d-flex align-items-center">
                                                    
                                                    <!-- Box Waktu -->
                                                    <div class="time-box me-3 shadow-sm border">
                                                        <div class="time-start"><?= date('H:i', strtotime($j['jam_mulai'])) ?></div>
                                                        <div class="time-end"><?= date('H:i', strtotime($j['jam_selesai'])) ?></div>
                                                    </div>

                                                    <!-- Info Mapel -->
                                                    <div class="flex-grow-1 overflow-hidden">
                                                        <h6 class="fw-bold mb-1 text-truncate text-dark"><?= htmlspecialchars($j['mata_pelajaran']) ?></h6>
                                                        <div class="d-flex align-items-center text-muted small">
                                                            <span class="badge bg-light text-dark border me-2">
                                                                <i class="bi bi-people-fill me-1"></i> <?= $j['kelas'] ?>
                                                            </span>
                                                            <span class="text-truncate">
                                                                <i class="bi bi-geo-alt-fill me-1 text-danger"></i> <?= $j['ruangan'] ?>
                                                            </span>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

            <?php endif; ?>

        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item active">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <a href="pelanggaran.php" class="mobile-nav-item">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Poin</span>
    </a>
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="absenguru.php" class="mobile-nav-fab">
            <i class="bi bi-camera-fill"></i>
        </a>
        <div class="mobile-nav-text-fab">Absen</div>
    </div>
    <a href="profil.php" class="mobile-nav-item">
        <i class="bi bi-person-fill"></i>
        <span>Profil</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>