<?php
session_start();
include 'koneksi.php';

// Atur Timezone Wajib Sama dengan proses_absen.php
date_default_timezone_set('Asia/Jakarta');

// --- AJAX: REQUEST TOKEN QR BARU (SERVER SIDE) ---
if (isset($_GET['ajax_token'])) {
    // Logika ini HARUS SAMA PERSIS dengan proses_absen.php
    $now = new DateTime();
    $minute = (int)$now->format('i');
    $roundedMinute = $minute - ($minute % 2); // Bulatkan ke bawah kelipatan 2
    
    $t = clone $now;
    $t->setTime($t->format('H'), $roundedMinute, 0);

    // Format tanggal 'Y-n-j' (contoh: 2024-5-21) harus sama dengan proses_absen.php
    $keyString = "SECRET_KEY_SEKOLAH_" . $t->format('Y-n-j') . "_" . $t->format('H:i');
    
    echo base64_encode($keyString);
    exit;
}

// --- AJAX: REQUEST DATA GURU YANG SUDAH ABSEN ---
if (isset($_GET['ajax_data'])) {
    $today = date('Y-m-d');
    
    // Query join ke tabel users untuk ambil nama & foto
    $query = "SELECT a.*, u.nama_lengkap, u.foto 
              FROM absensi_guru a 
              JOIN users u ON a.id_guru = u.id 
              WHERE a.tanggal = '$today' 
              ORDER BY a.waktu_absen DESC";
              
    $result = mysqli_query($koneksi, $query);
    
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            // Fallback foto jika kosong
            $foto = !empty($row['foto']) ? 'uploads/'.$row['foto'] : 'https://ui-avatars.com/api/?name='.urlencode($row['nama_lengkap']).'&background=random';
            
            echo '
            <div class="col-md-4 mb-3 fade-in">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body d-flex align-items-center">
                        <img src="'.$foto.'" class="rounded-circle me-3 border" style="width: 60px; height: 60px; object-fit: cover;">
                        <div>
                            <h6 class="fw-bold mb-1 text-dark">'.$row['nama_lengkap'].'</h6>
                            <span class="badge bg-success bg-opacity-10 text-success border border-success px-2">
                                <i class="bi bi-check-circle-fill me-1"></i> '.$row['waktu_absen'].' WIB
                            </span>
                        </div>
                    </div>
                </div>
            </div>';
        }
    } else {
        echo '
        <div class="col-12 text-center py-5">
            <div class="text-muted opacity-50 mb-3">
                <i class="bi bi-qr-code-scan" style="font-size: 4rem;"></i>
            </div>
            <h5 class="text-muted fw-normal">Belum ada data absensi hari ini</h5>
            <p class="small text-muted">Silakan scan QR Code di samping untuk melakukan presensi.</p>
        </div>';
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Monitor Absensi Guru</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Library QR Code -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <style>
        body { background-color: #f8f9fa; font-family: 'Segoe UI', sans-serif; overflow-x: hidden; }
        
        /* Layout Sidebar & Content */
        .sidebar-qr {
            background: #ffffff;
            min-height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            width: 380px;
            z-index: 100;
            padding: 2rem;
            border-right: 1px solid #dee2e6;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .content-area {
            margin-left: 380px;
            padding: 2rem 3rem;
            min-height: 100vh;
        }

        /* Styling QR Code Box */
        .qr-wrapper {
            background: white;
            padding: 20px;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
            border: 1px solid #edf2f7;
            margin: 25px 0;
            position: relative;
        }
        
        /* Animasi Timer Bar */
        .timer-bar {
            height: 6px;
            width: 100%;
            background: #e9ecef;
            border-radius: 10px;
            overflow: hidden;
            margin-top: 20px;
        }
        .timer-progress {
            height: 100%;
            background: linear-gradient(90deg, #0d6efd, #0dcaf0);
            width: 100%;
            transition: width 1s linear;
        }

        /* Animasi Masuk Card */
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Responsif untuk Tablet/HP */
        @media (max-width: 992px) {
            .sidebar-qr {
                position: relative;
                width: 100%;
                min-height: auto;
                padding: 3rem 1rem;
                border-right: none;
                border-bottom: 1px solid #dee2e6;
            }
            .content-area {
                margin-left: 0;
                padding: 2rem 1rem;
            }
        }
    </style>
</head>
<body>

<!-- SIDEBAR KIRI: QR CODE GENERATOR -->
<div class="sidebar-qr text-center">
    <div class="mb-4">
        <h3 class="fw-bold text-dark mb-1">Absensi Guru</h3>
        <p class="text-muted">SMK Negeri Contoh</p>
    </div>

    <!-- Kotak QR Code -->
    <div class="qr-wrapper">
        <div id="qrcode"></div>
        <!-- Overlay Loading saat refresh QR -->
        <div id="qr-loading" class="position-absolute top-0 start-0 w-100 h-100 bg-white d-flex align-items-center justify-content-center" style="display: none; border-radius: 20px; opacity: 0.8;">
            <div class="spinner-border text-primary" role="status"></div>
        </div>
    </div>

    <div class="w-100 px-4 mt-2">
        <div class="d-flex justify-content-between small fw-bold text-secondary mb-2">
            <span>Refresh Otomatis</span>
            <span id="timer-text">120s</span>
        </div>
        <div class="timer-bar">
            <div class="timer-progress" id="progress-bar"></div>
        </div>
    </div>
    
    <div class="mt-4 p-3 rounded bg-light border small text-start w-100">
        <div class="d-flex gap-2">
            <i class="bi bi-shield-check text-success fs-5"></i>
            <div>
                <strong class="d-block text-dark">Sistem Keamanan Aktif</strong>
                <span class="text-muted">QR Code diperbarui otomatis mengikuti waktu server agar tidak bisa dipalsukan.</span>
            </div>
        </div>
    </div>
</div>

<!-- CONTENT KANAN: LIST KEHADIRAN -->
<div class="content-area">
    <div class="d-flex justify-content-between align-items-center mb-4 pb-3 border-bottom">
        <div>
            <h2 class="fw-bold mb-0 text-dark">Kehadiran Hari Ini</h2>
            <p class="text-muted mb-0"><?= date('l, d F Y') ?></p>
        </div>
        <div class="text-end">
            <h1 class="fw-bold text-primary display-4 mb-0" id="clock">00:00:00</h1>
            <small class="text-muted fw-bold">WIB (Server Time)</small>
        </div>
    </div>

    <div class="row g-4" id="daftar-guru">
        <!-- Data dimuat via AJAX -->
        <div class="col-12 text-center py-5">
            <div class="spinner-grow text-primary" role="status"></div>
            <p class="mt-3 text-muted">Menghubungkan ke server...</p>
        </div>
    </div>
</div>

<script>
    // Inisialisasi QR Code Library
    let qrcodeObj = new QRCode(document.getElementById("qrcode"), {
        width: 220,
        height: 220,
        colorDark : "#000000",
        colorLight : "#ffffff",
        correctLevel : QRCode.CorrectLevel.H
    });

    const REFRESH_INTERVAL = 120; // Detik (2 menit)
    let timeLeft = REFRESH_INTERVAL;

    // --- FUNGSI UPDATE QR (FETCH DARI SERVER) ---
    function updateQR() {
        // Tampilkan loading tipis di atas QR
        // document.getElementById('qr-loading').style.display = 'flex';

        fetch('guru_piket.php?ajax_token=1')
            .then(response => response.text())
            .then(token => {
                console.log("Token from server:", token); // Debugging
                qrcodeObj.clear();
                qrcodeObj.makeCode(token);
                
                // Reset Timer
                timeLeft = REFRESH_INTERVAL;
                // document.getElementById('qr-loading').style.display = 'none';
            })
            .catch(err => console.error("Gagal mengambil token:", err));
    }

    // --- FUNGSI UPDATE DATA ABSEN ---
    function loadDataAbsen() {
        fetch('guru_piket.php?ajax_data=1')
            .then(response => response.text())
            .then(data => {
                document.getElementById('daftar-guru').innerHTML = data;
            });
    }

    // --- FUNGSI TIMER VISUAL ---
    function updateTimer() {
        timeLeft--;
        document.getElementById('timer-text').innerText = timeLeft + 's';
        
        const percentage = (timeLeft / REFRESH_INTERVAL) * 100;
        document.getElementById('progress-bar').style.width = percentage + '%';

        // Jika waktu habis, ambil token baru dari server
        if (timeLeft <= 0) {
            updateQR();
        }
    }

    // --- JAM DIGITAL POJOK KANAN (Agar user tau jam server) ---
    function updateClock() {
        const now = new Date();
        // Format waktu lokal (bisa jadi beda dikit sama server, tapi cukup untuk visual)
        // Idealnya fetch jam server, tapi untuk display detik ini cukup
        const timeString = now.toLocaleTimeString('id-ID', { hour12: false });
        document.getElementById('clock').innerText = timeString;
    }

    // --- INISIALISASI ---
    updateQR();      // Jalankan pertama kali
    loadDataAbsen(); // Jalankan pertama kali

    // --- INTERVAL ---
    setInterval(updateTimer, 1000);      // Hitung mundur tiap detik
    setInterval(loadDataAbsen, 5000);    // Cek data absen tiap 5 detik
    setInterval(updateClock, 1000);      // Update jam digital
</script>

</body>
</html>