<?php
session_start();
include 'koneksi.php';

// 1. Cek akses guru
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];
$pesan = ""; 
$tipe_pesan = "";

// --- [AJAX] FITUR RIWAYAT REWARD SISWA ---
if (isset($_GET['ajax_history'])) {
    $siswa_id = mysqli_real_escape_string($koneksi, $_GET['ajax_history']);
    
    // Ambil data siswa
    $q_s = mysqli_query($koneksi, "SELECT nama, kelas, sisa_poin FROM students WHERE id = '$siswa_id'");
    $d_s = mysqli_fetch_assoc($q_s);
    
    // Ambil riwayat reward siswa ini
    $query_detail = "
        SELECT r.tanggal, j.nama_reward, j.poin_bonus, u.nama_lengkap as nama_guru
        FROM riwayat_reward r
        JOIN jenis_reward j ON r.jenis_reward_id = j.id
        JOIN users u ON r.guru_id = u.id
        WHERE r.student_id = '$siswa_id'
        ORDER BY r.tanggal DESC
    ";
    $res_detail = mysqli_query($koneksi, $query_detail);

    // Output HTML untuk Modal (Desain Disesuaikan)
    echo '<div class="alert alert-success mb-3 shadow-sm border-0">';
    echo '<h6 class="fw-bold mb-1">' . $d_s['nama'] . '</h6>';
    echo '<span class="text-muted small">' . $d_s['kelas'] . '</span>';
    echo '<div class="mt-2">Total Poin: <span class="badge bg-success rounded-pill">' . $d_s['sisa_poin'] . '</span></div>';
    echo '</div>';

    echo '<div class="table-responsive">';
    echo '<table class="table table-sm table-borderless table-striped align-middle">';
    echo '<thead class="table-light"><tr><th>Tanggal</th><th>Reward</th><th>Poin</th></tr></thead>';
    echo '<tbody>';
    
    if (mysqli_num_rows($res_detail) > 0) {
        while ($row = mysqli_fetch_assoc($res_detail)) {
            echo '<tr>';
            echo '<td class="small text-muted">' . date('d/m/y', strtotime($row['tanggal'])) . '</td>';
            echo '<td class="small">' . $row['nama_reward'] . '</td>';
            echo '<td class="text-success fw-bold">+' . $row['poin_bonus'] . '</td>';
            echo '</tr>';
        }
    } else {
        echo '<tr><td colspan="3" class="text-center text-muted small py-3">Belum ada catatan prestasi.</td></tr>';
    }
    
    echo '</tbody></table></div>';
    exit; 
}
// -----------------------------------------------------------------

// --- AMBIL DATA USER ---
$q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
$guru = mysqli_fetch_assoc($q_guru);

// --- PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; 

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if (mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}

// --- FILTER KELAS ---
$q_kelas_list = mysqli_query($koneksi, "SELECT DISTINCT kelas FROM students ORDER BY kelas ASC");
$selected_kelas = isset($_GET['kelas']) ? $_GET['kelas'] : '';

// --- PROSES INPUT REWARD ---
if (isset($_POST['simpan_reward'])) {
    $student_id = $_POST['student_id'];
    $jenis_id   = $_POST['jenis_reward_id'];
    
    $q_jenis = mysqli_query($koneksi, "SELECT poin_bonus FROM jenis_reward WHERE id = '$jenis_id'");
    $d_jenis = mysqli_fetch_assoc($q_jenis);
    $poin_tambah = $d_jenis['poin_bonus'];

    // Update Poin (+)
    $update_siswa = mysqli_query($koneksi, "UPDATE students SET sisa_poin = sisa_poin + $poin_tambah WHERE id = '$student_id'");
    
    if ($update_siswa) {
        $tgl = date('Y-m-d H:i:s');
        $insert = mysqli_query($koneksi, "INSERT INTO riwayat_reward (student_id, guru_id, jenis_reward_id, tanggal) VALUES ('$student_id', '$id_guru', '$jenis_id', '$tgl')");

        if ($insert) {
            $pesan = "Reward berhasil diberikan! Poin bertambah +$poin_tambah.";
            $tipe_pesan = "success";
        } else {
            $pesan = "Gagal mencatat riwayat.";
            $tipe_pesan = "danger";
        }
    } else {
        $pesan = "Gagal update database siswa.";
        $tipe_pesan = "danger";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Input Reward - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    
    <style>
        /* --- CSS GLOBAL (SAMA DENGAN HOME.PHP) --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- MOBILE BOTTOM NAV (ANDROID STYLE) --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        /* --- Custom UI untuk Input Reward --- */
        .card-custom {
            border: none;
            border-radius: 12px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            background: white;
        }
        
        /* List Item untuk Search */
        .item-row { transition: all 0.2s; cursor: pointer; }
        .item-row:hover { background-color: #f8f9fa; border-color: #198754 !important; }
        .item-row input:checked + .item-text { font-weight: bold; color: #198754; }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Reward</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
                <small class="text-muted">Guru</small>
            </li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR (Menu sama dengan home.php, tapi aktif di Reward) -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="guru_scanqr.php" class="nav-link"><i class="bi bi-qr-code-scan"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="koperasi.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                <li class="nav-item"><a href="guru_reset.php" class="nav-link"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                
                <!-- MENU INI AKTIF -->
                <li class="nav-item"><a href="reward.php" class="nav-link active"><i class="bi bi-trophy-fill"></i> Reward Siswa</a></li>
                
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="fw-bold text-success mb-0"><i class="bi bi-trophy-fill me-2"></i>Reward & Prestasi</h5>
                <span class="badge bg-white text-success shadow-sm border px-3 py-2 rounded-pill d-none d-md-inline-block">
                    <i class="bi bi-calendar-event me-1"></i> <?= date('d F Y') ?>
                </span>
            </div>

            <?php if ($pesan != ""): ?>
                <div class="alert alert-<?= $tipe_pesan ?> alert-dismissible fade show shadow-sm border-0 rounded-3 mb-4" role="alert">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-check-circle-fill fs-4 me-3"></i>
                        <div><?= $pesan ?></div>
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row g-4">
                
                <!-- KOLOM KIRI: FORM INPUT -->
                <div class="col-lg-6">
                    <div class="card card-custom h-100">
                        <div class="card-header bg-white border-0 pt-4 pb-0 px-4">
                            <h6 class="fw-bold text-secondary text-uppercase small ls-1 mb-0">Form Input</h6>
                        </div>
                        <div class="card-body p-4">
                            
                            <!-- FILTER KELAS -->
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted">Filter Kelas</label>
                                <select class="form-select bg-light border-0" onchange="window.location.href='?kelas='+this.value">
                                    <option value="">-- Tampilkan Semua --</option>
                                    <?php while($k = mysqli_fetch_assoc($q_kelas_list)): ?>
                                        <option value="<?= $k['kelas'] ?>" <?= ($selected_kelas == $k['kelas']) ? 'selected' : '' ?>>
                                            <?= $k['kelas'] ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>

                            <form action="" method="POST">
                                <!-- PILIH SISWA -->
                                <div class="mb-3">
                                    <label class="form-label fw-bold small text-muted">Cari Nama Siswa</label>
                                    <select id="select-siswa" name="student_id" class="form-select" required>
                                        <option value="">-- Cari Siswa --</option>
                                        <?php
                                        // Modifikasi Query Berdasarkan Filter Kelas
                                        $sql_siswa = "SELECT id, nama, kelas, sisa_poin FROM students";
                                        if ($selected_kelas != '') {
                                            $kelas_safe = mysqli_real_escape_string($koneksi, $selected_kelas);
                                            $sql_siswa .= " WHERE kelas = '$kelas_safe'";
                                        }
                                        $sql_siswa .= " ORDER BY nama ASC";
                                        
                                        $q_siswa = mysqli_query($koneksi, $sql_siswa);
                                        while ($s = mysqli_fetch_assoc($q_siswa)) {
                                            echo "<option value='" . $s['id'] . "'>" . $s['nama'] . " (" . $s['kelas'] . ") - Poin: " . $s['sisa_poin'] . "</option>";
                                        }
                                        ?>
                                    </select>
                                    
                                    <!-- TOMBOL DETAIL SISWA -->
                                    <button type="button" id="btn-lihat-detail" class="btn btn-sm btn-light text-primary w-100 mt-2 border-0 fw-bold" disabled>
                                        <i class="bi bi-eye me-1"></i> Cek Riwayat Reward
                                    </button>
                                </div>

                                <!-- PILIH REWARD -->
                                <div class="mb-4">
                                    <label class="form-label fw-bold small text-muted">Pilih Prestasi/Reward</label>
                                    
                                    <!-- SEARCH REWARD -->
                                    <div class="input-group mb-2">
                                        <span class="input-group-text bg-light border-0"><i class="bi bi-search"></i></span>
                                        <input type="text" id="search-item" class="form-control bg-light border-0" placeholder="Cari reward...">
                                    </div>

                                    <div id="list-item" class="d-grid gap-2 pe-1" style="max-height: 250px; overflow-y: auto;">
                                        <?php
                                        // Query ini aman dijalankan meski tabel baru dibuat tanpa foreign key
                                        $q_reward = mysqli_query($koneksi, "SELECT * FROM jenis_reward ORDER BY poin_bonus ASC");
                                        while ($j = mysqli_fetch_assoc($q_reward)) :
                                        ?>
                                            <label class="item-row btn btn-outline-light text-dark text-start d-flex justify-content-between align-items-center border px-3 py-2 rounded-3">
                                                <div class="d-flex align-items-center">
                                                    <input type="radio" name="jenis_reward_id" value="<?= $j['id'] ?>" class="form-check-input me-3 mt-0" required>
                                                    <span class="item-text small"><?= $j['nama_reward'] ?></span>
                                                </div>
                                                <span class="badge bg-success bg-opacity-10 text-success rounded-pill">+<?= $j['poin_bonus'] ?></span>
                                            </label>
                                        <?php endwhile; ?>
                                    </div>
                                </div>

                                <button type="submit" name="simpan_reward" class="btn btn-success w-100 py-2 fw-bold shadow-sm rounded-pill">
                                    <i class="bi bi-save me-2"></i> Simpan Data
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- KOLOM KANAN: RIWAYAT GLOBAL -->
                <div class="col-lg-6">
                    <div class="card card-custom h-100">
                        <div class="card-header bg-white border-0 pt-4 pb-0 px-4">
                            <h6 class="fw-bold text-secondary text-uppercase small ls-1 mb-0">Input Terakhir</h6>
                        </div>
                        <div class="card-body p-0 pt-3">
                            <div class="table-responsive">
                                <table class="table table-hover align-middle mb-0">
                                    <thead class="bg-light text-secondary small">
                                        <tr>
                                            <th class="ps-4 border-0 rounded-start">Waktu</th>
                                            <th class="border-0">Siswa</th>
                                            <th class="border-0 rounded-end">Reward</th>
                                        </tr>
                                    </thead>
                                    <tbody class="border-top-0">
                                        <?php
                                        // Query tetap aman
                                        $query_history = "
                                            SELECT r.tanggal, s.nama as nama_siswa, s.kelas, j.nama_reward, j.poin_bonus
                                            FROM riwayat_reward r
                                            JOIN students s ON r.student_id = s.id
                                            JOIN jenis_reward j ON r.jenis_reward_id = j.id
                                            WHERE r.guru_id = '$id_guru' 
                                            ORDER BY r.tanggal DESC LIMIT 5
                                        ";
                                        $res_history = mysqli_query($koneksi, $query_history);
                                        
                                        if ($res_history && mysqli_num_rows($res_history) > 0) {
                                            while ($h = mysqli_fetch_assoc($res_history)) {
                                                echo "<tr>";
                                                echo "<td class='ps-4 small text-muted'>" . date('d/m H:i', strtotime($h['tanggal'])) . "</td>";
                                                echo "<td><span class='fw-bold small'>" . $h['nama_siswa'] . "</span><br><small class='text-muted' style='font-size:10px'>" . $h['kelas'] . "</small></td>";
                                                echo "<td><div class='text-truncate' style='max-width:120px; font-size:12px'>" . $h['nama_reward'] . "</div><span class='badge bg-success text-white py-1 px-2 rounded-pill' style='font-size:10px'>+" . $h['poin_bonus'] . "</span></td>";
                                                echo "</tr>";
                                            }
                                        } else {
                                            echo "<tr><td colspan='3' class='text-center py-5 text-muted small'><i class='bi bi-inbox fs-1 d-block opacity-25 mb-2'></i>Belum ada input reward.</td></tr>";
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div> <!-- End Row -->

        </div>
    </div>
</div>

<!-- MODAL DETAIL RIWAYAT SISWA -->
<div class="modal fade" id="modalDetailSiswa" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content border-0 rounded-4 shadow">
            <div class="modal-header border-0 pb-0">
                <h5 class="modal-title fw-bold text-success"><i class="bi bi-person-lines-fill me-2"></i>Detail Siswa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="modal-content-body">
                <div class="text-center py-5">
                    <div class="spinner-border text-success" role="status"></div>
                    <p class="mt-2 small text-muted">Sedang memuat data...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    
    <!-- Link ke Reward (Aktif) -->
    <a href="reward.php" class="mobile-nav-item active">
        <i class="bi bi-trophy-fill"></i>
        <span>Reward</span>
    </a>
    
    <!-- TOMBOL TENGAH: SCAN QR -->
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="guru_scanqr.php" class="mobile-nav-fab">
            <i class="bi bi-qr-code-scan"></i>
        </a>
        <div class="mobile-nav-text-fab">Scan</div>
    </div>

    <a href="pelanggaran.php" class="mobile-nav-item">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Sanksi</span>
    </a>
    
    <a href="profile.php" class="mobile-nav-item">
        <i class="bi bi-person-fill"></i>
        <span>Profil</span>
    </a>
</nav>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        // Init Select2 dengan tema Bootstrap 5
        $('#select-siswa').select2({
            theme: 'bootstrap-5',
            placeholder: "Ketik nama siswa...",
            allowClear: true,
            width: '100%'
        });

        // --- SCRIPT PENCARIAN REWARD (Fix Toggle Display) ---
        $('#search-item').on('keyup input', function() {
            var value = $(this).val().toLowerCase();
            $('#list-item .item-row').each(function() {
                var text = $(this).text().toLowerCase();
                // Gunakan d-none untuk hide, dan d-flex untuk show agar layout flex terjaga
                if (text.indexOf(value) > -1) {
                    $(this).removeClass('d-none').addClass('d-flex');
                } else {
                    $(this).addClass('d-none').removeClass('d-flex');
                }
            });
        });

        // Enable tombol Detail jika siswa dipilih
        $('#select-siswa').on('change', function() {
            var siswaId = $(this).val();
            if (siswaId) {
                $('#btn-lihat-detail').removeAttr('disabled').removeClass('btn-light text-primary').addClass('btn-primary text-white shadow-sm');
            } else {
                $('#btn-lihat-detail').attr('disabled', 'disabled').removeClass('btn-primary text-white shadow-sm').addClass('btn-light text-primary');
            }
        });

        // Klik tombol Detail -> Buka Modal -> Ajax Load Data
        $('#btn-lihat-detail').click(function() {
            var siswaId = $('#select-siswa').val();
            if(!siswaId) return;

            var myModal = new bootstrap.Modal(document.getElementById('modalDetailSiswa'));
            myModal.show();

            // Loading state
            $('#modal-content-body').html('<div class="text-center py-5"><div class="spinner-border text-success"></div><p class="mt-2 small text-muted">Mengambil data...</p></div>');

            $.ajax({
                url: 'reward.php', 
                type: 'GET',
                data: { ajax_history: siswaId },
                success: function(response) {
                    $('#modal-content-body').html(response);
                },
                error: function() {
                    $('#modal-content-body').html('<div class="alert alert-danger m-3">Gagal mengambil data. Periksa koneksi internet.</div>');
                }
            });
        });
    });
</script>
</body>
</html>