<?php
session_start();
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Scan Absensi Guru</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    
    <style>
        /* Reset Body agar Full Screen */
        html, body {
            height: 100%;
            width: 100%;
            margin: 0;
            padding: 0;
            background-color: #000;
            overflow: hidden; /* Mencegah scroll */
            font-family: 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
        }

        /* Container Kamera Full Screen */
        #reader {
            width: 100%;
            height: 100%;
            position: absolute;
            top: 0;
            left: 0;
            z-index: 1;
        }

        /* HACK PENTING: Memaksa elemen Video dari library untuk Full Screen (Cover) */
        #reader video {
            width: 100% !important;
            height: 100% !important;
            object-fit: cover !important; /* Kunci agar tidak gepeng/setengah */
            border-radius: 0 !important;
        }

        /* Overlay Gelap Transparan (Atas) */
        .overlay-top {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            padding: 20px;
            background: linear-gradient(180deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0) 100%);
            z-index: 10;
            text-align: center;
            color: white;
        }

        /* Overlay Gelap Transparan (Bawah) - Opsional untuk estetik */
        .overlay-bottom {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 100px;
            background: linear-gradient(0deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0) 100%);
            z-index: 10;
        }

        /* Area Fokus (Kotak Tengah) */
        .scan-area-guide {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 280px;
            height: 280px;
            z-index: 5;
            /* Membuat area di luar kotak menjadi gelap */
            box-shadow: 0 0 0 100vmax rgba(0, 0, 0, 0.5);
            border-radius: 20px;
        }

        /* Garis Sudut (Corner Borders) */
        .corner {
            position: absolute;
            width: 40px;
            height: 40px;
            border-color: #0d6efd; /* Warna Biru Bootstrap Primary */
            border-style: solid;
            transition: all 0.3s ease;
        }
        
        .top-left { top: 0; left: 0; border-width: 4px 0 0 4px; border-top-left-radius: 20px; }
        .top-right { top: 0; right: 0; border-width: 4px 4px 0 0; border-top-right-radius: 20px; }
        .bottom-left { bottom: 0; left: 0; border-width: 0 0 4px 4px; border-bottom-left-radius: 20px; }
        .bottom-right { bottom: 0; right: 0; border-width: 0 4px 4px 0; border-bottom-right-radius: 20px; }

        /* Animasi Garis Laser (Scanning Line) */
        .laser-line {
            position: absolute;
            width: 100%;
            height: 2px;
            background-color: #0d6efd;
            box-shadow: 0 0 10px #0d6efd;
            top: 0;
            left: 0;
            animation: scan 2s infinite linear;
        }

        @keyframes scan {
            0% { top: 0%; opacity: 0; }
            10% { opacity: 1; }
            90% { opacity: 1; }
            100% { top: 100%; opacity: 0; }
        }

        /* Tombol Kembali */
        .btn-back-custom {
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(5px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
            padding: 8px 25px;
            border-radius: 50px;
            text-decoration: none;
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            margin-top: 10px;
        }
        .btn-back-custom:hover {
            background: rgba(255, 255, 255, 0.4);
            color: white;
        }

        /* Pesan Loading */
        .loading-container {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 20;
            text-align: center;
            width: 80%;
        }
        
        .loading-text {
            color: white;
            margin-top: 10px;
            font-weight: 500;
        }

        /* Sembunyikan elemen bawaan library yang mengganggu */
        #reader__dashboard_section_csr span, 
        #reader__dashboard_section_swaplink {
            display: none !important;
        }
    </style>
</head>
<body>

    <!-- UI Navigasi Atas -->
    <div class="overlay-top">
        <h5 class="fw-bold mb-0">Scan Absensi</h5>
        <p class="small text-white-50 mb-0">Arahkan kamera ke QR Code</p>
        <a href="home.php" class="btn-back-custom">
            <i class="bi bi-chevron-left"></i> Kembali
        </a>
    </div>

    <!-- UI Overlay Bawah (Pemanis) -->
    <div class="overlay-bottom"></div>

    <!-- Area Kotak Fokus -->
    <div class="scan-area-guide">
        <div class="corner top-left"></div>
        <div class="corner top-right"></div>
        <div class="corner bottom-left"></div>
        <div class="corner bottom-right"></div>
        <!-- Efek Laser -->
        <div class="laser-line"></div>
    </div>

    <!-- Loading Screen -->
    <div class="loading-container" id="loadingMessage">
        <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
        <div class="loading-text">Membuka Kamera...</div>
    </div>

    <!-- Wadah Kamera -->
    <div id="reader"></div>

    <!-- Library -->
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>

    <script>
        const html5QrCode = new Html5Qrcode("reader");

        // Fungsi ketika QR berhasil discan
        const qrCodeSuccessCallback = (decodedText, decodedResult) => {
            console.log(`Scan result: ${decodedText}`, decodedResult);
            
            // Hentikan kamera
            html5QrCode.stop().then(() => {
                // Beri feedback getar jika di HP
                if (navigator.vibrate) navigator.vibrate(200);
                
                // Redirect
                window.location.href = "proses_absen.php?token=" + encodeURIComponent(decodedText);
            }).catch((err) => {
                console.log("Stop failed: ", err);
            });
        };

        const config = { 
            fps: 10, 
            qrbox: { width: 250, height: 250 },
            // HAPUS aspectRatio agar CSS object-fit yang bekerja
            // aspectRatio: window.innerWidth / window.innerHeight 
        };

        // Mulai kamera
        html5QrCode.start(
            { facingMode: "environment" }, 
            config, 
            qrCodeSuccessCallback
        ).then(() => {
            // Sembunyikan loading jika berhasil
            document.getElementById('loadingMessage').style.display = 'none';
        }).catch(err => {
            // Handle Error
            console.error("Error starting camera", err);
            document.getElementById('loadingMessage').innerHTML = 
                `<div class="alert alert-danger shadow">
                    <i class="bi bi-exclamation-triangle-fill"></i><br>
                    <strong>Gagal Akses Kamera</strong><br>
                    <small>Pastikan izin kamera aktif & gunakan HTTPS.</small><br>
                    <button onclick="location.reload()" class="btn btn-sm btn-light mt-2">Coba Lagi</button>
                </div>`;
        });
    </script>
</body>
</html>