<?php
session_start();
include 'koneksi.php';

// 1. Cek akses login
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];

// --- AMBIL DATA USER (GURU) ---
$q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
if (!$q_guru || mysqli_num_rows($q_guru) == 0) {
    $guru = [
        'nama_lengkap' => 'Guru Pengajar', 
        'foto' => '', 
        'mata_pelajaran' => 'Umum'
    ];
} else {
    $guru = mysqli_fetch_assoc($q_guru);
}

// --- AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; 

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if ($check_table && mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($q_sekolah && $d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// Setup Foto Profil
$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}

// --- LOGIKA JADWAL (BARU) ---
date_default_timezone_set('Asia/Jakarta'); 

$hari_inggris = date('l');
$map_hari = [
    'Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa',
    'Wednesday' => 'Rabu', 'Thursday' => 'Kamis', 'Friday' => 'Jumat', 'Saturday' => 'Sabtu'
];
$hari_ini = $map_hari[$hari_inggris];
$jam_sekarang = date('H:i:s');

// 1. CEK: Apakah sedang ada jadwal BERLANGSUNG sekarang?
$q_now = "SELECT * FROM jadwal_mengajar 
          WHERE id_guru = '$id_guru' 
          AND hari = '$hari_ini' 
          AND '$jam_sekarang' BETWEEN jam_mulai AND jam_selesai
          LIMIT 1";
$run_now = mysqli_query($koneksi, $q_now);
$jadwal_active = mysqli_fetch_assoc($run_now);

// 2. Jika TIDAK ada yang berlangsung, cari jadwal SELANJUTNYA hari ini
$jadwal_next = null;
if (!$jadwal_active) {
    $q_next = "SELECT * FROM jadwal_mengajar 
               WHERE id_guru = '$id_guru' 
               AND hari = '$hari_ini' 
               AND jam_mulai > '$jam_sekarang' 
               ORDER BY jam_mulai ASC 
               LIMIT 1";
    $run_next = mysqli_query($koneksi, $q_next);
    $jadwal_next = mysqli_fetch_assoc($run_next);
}

// Tentukan Mode Tampilan untuk UI
$mode_tampilan = ''; 
$data_tampilan = [];

if ($jadwal_active) {
    $mode_tampilan = 'active'; 
    $data_tampilan = $jadwal_active;
} elseif ($jadwal_next) {
    $mode_tampilan = 'countdown'; 
    $data_tampilan = $jadwal_next;
} else {
    $mode_tampilan = 'done'; 
}

$target_waktu_js = ($mode_tampilan == 'countdown') ? $data_tampilan['jam_mulai'] : '';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Guru - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        /* --- CSS GLOBAL --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR (DESKTOP) --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        
        /* --- MENU UTAMA (ANDROID STYLE) --- */
        .menu-card {
            transition: transform 0.2s;
            border-radius: 12px;
            border: none;
            height: 100%;
            background: white;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05); 
        }
        .menu-card:active {
            transform: scale(0.95);
            background-color: #f8f9fa;
        }

        /* Ukuran Icon Box diperkecil */
        .icon-box {
            width: 45px; height: 45px; 
            border-radius: 12px; 
            display: flex; align-items: center; justify-content: center;
            margin: 0 auto 8px;
            font-size: 22px;
        }

        /* Teks Menu */
        .menu-title {
            font-size: 12px;
            font-weight: 600;
            color: #333;
            line-height: 1.2;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        /* Sembunyikan deskripsi kecil di mobile agar ringkas */
        .menu-desc {
            font-size: 10px;
            color: #888;
            display: block; 
        }

        /* Warna Icon */
        .bg-icon-cbt { background-color: #e0f2fe; color: #0284c7; }
        .bg-icon-absen { background-color: #dcfce7; color: #16a34a; }
        .bg-icon-poin { background-color: #fee2e2; color: #dc2626; }
        .bg-icon-jadwal { background-color: #fef9c3; color: #ca8a04; }
        .bg-icon-soal { background-color: #f3e8ff; color: #9333ea; }
        .bg-icon-rapor { background-color: #ffedd5; color: #ea580c; }
        .bg-icon-koperasi { background-color: #ccfbf1; color: #0d9488; } 

        /* --- MOBILE BOTTOM NAV --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- WELCOME CARD (UPDATED) --- */
        .welcome-card {
            background: linear-gradient(135deg, #198754, #20c997);
            color: white;
            border-radius: 15px;
            overflow: hidden;
            position: relative;
        }

        /* --- COUNTDOWN & ACTIVE BOX STYLE --- */
        .timer-box {
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(5px);
            border-radius: 10px;
            padding: 10px 15px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            text-align: center;
            min-width: 140px;
        }
        .timer-time {
            font-size: 1.5rem;
            font-weight: 800;
            font-family: 'Courier New', Courier, monospace; 
            letter-spacing: 2px;
            line-height: 1;
        }
        .timer-label {
            font-size: 0.75rem;
            opacity: 0.9;
            margin-bottom: 2px;
            text-transform: uppercase;
        }
        .timer-badge {
            font-size: 0.7rem;
            background: #fff;
            color: #198754;
            padding: 2px 8px;
            border-radius: 20px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 5px;
        }
        /* Animasi Pulse untuk Badge Live */
        @keyframes pulse-red {
            0% { box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(255, 255, 255, 0); }
            100% { box-shadow: 0 0 0 0 rgba(255, 255, 255, 0); }
        }
        .animate-pulse {
            animation: pulse-red 2s infinite;
        }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
            
            .menu-desc { display: none; } 
            .card-body { padding: 15px 5px !important; }

            /* Tweak Welcome Card di Mobile */
            .welcome-card { padding: 15px !important; }
            .welcome-card .d-flex { flex-direction: column; align-items: flex-start !important; }
            .welcome-profile { margin-bottom: 15px; width: 100%; display: flex; align-items: center; }
            .timer-section { width: 100%; margin-top: 10px; }
            .timer-box, .active-box { width: 100%; text-align: left; display: flex; justify-content: space-between; align-items: center; }
            /* Khusus tampilan mobile untuk box active/timer */
            .timer-box { flex-direction: row; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Guru</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
                <small class="text-muted">Guru</small>
            </li>
            <li><a class="dropdown-item" href="profile.php"><i class="bi bi-person me-2"></i> Profil</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link active"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <!-- UPDATE MENU ABSEN GURU DI SIDEBAR -->
                <li class="nav-item"><a href="guru_scanqr.php" class="nav-link"><i class="bi bi-qr-code-scan"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="segerahadir.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                <li class="nav-item"><a href="guru_reset.php" class="nav-link"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            
            <!-- HEADER SAMBUTAN GURU -->
            <div class="welcome-card p-4 mb-4 shadow-sm">
                <div class="d-flex justify-content-between align-items-center">
                    
                    <div class="welcome-profile d-flex align-items-center">
                        <div class="me-3">
                            <img src="<?= $foto_profil ?>" class="rounded-circle border border-3 border-white shadow-sm" style="width: 70px; height: 70px; object-fit: cover;">
                        </div>
                        <div>
                            <h5 class="fw-bold mb-1">Halo, <?= htmlspecialchars(explode(' ', $guru['nama_lengkap'])[0]) ?>!</h5>
                            <p class="mb-0 opacity-75 small">Selamat beraktivitas di <?= $nama_sekolah ?></p>
                        </div>
                    </div>

                    <div class="timer-section">
                        <?php if ($mode_tampilan == 'active'): ?>
                            <div class="timer-box d-flex flex-column align-items-end align-items-md-center justify-content-center" style="border-color: #fff; background: rgba(255,255,255,0.25);">
                                <span class="badge bg-white text-danger mb-2 animate-pulse rounded-pill px-3">
                                    <i class="bi bi-record-circle-fill me-1"></i> BERLANGSUNG
                                </span>
                                <div class="fw-bold text-white mb-1 text-end text-md-center" style="font-size: 14px; line-height: 1.2;">
                                    <?= htmlspecialchars($data_tampilan['mata_pelajaran']) ?>
                                </div>
                                <div class="text-white small mb-2 opacity-75">
                                    <?= htmlspecialchars($data_tampilan['kelas']) ?> (<?= htmlspecialchars($data_tampilan['ruangan']) ?>)
                                </div>
                                <a href="guru_mengajar.php?id_jadwal=<?= $data_tampilan['id_jadwal'] ?>" class="btn btn-light text-success fw-bold btn-sm rounded-pill px-4 shadow-sm w-100">
                                    <i class="bi bi-qr-code-scan me-1"></i> MULAI MENGAJAR
                                </a>
                            </div>
                        <?php elseif ($mode_tampilan == 'countdown'): ?>
                            <div class="timer-box">
                                <div class="text-start text-md-center">
                                    <span class="timer-badge">Jadwal Selanjutnya</span>
                                    <div class="timer-label fw-bold text-truncate" style="max-width: 200px;">
                                        <?= htmlspecialchars($data_tampilan['mata_pelajaran']) ?>
                                    </div>
                                    <small class="d-block mb-1" style="font-size: 11px;">
                                        <?= htmlspecialchars($data_tampilan['kelas']) ?> (<?= htmlspecialchars($data_tampilan['ruangan']) ?>)
                                    </small>
                                </div>
                                <div class="timer-time" id="countdownDisplay">
                                    --:--:--
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="timer-box text-center">
                                <i class="bi bi-check-circle-fill fs-4 mb-1"></i>
                                <div class="fw-bold" style="font-size: 12px; line-height: 1.2;">Tugas Hari Ini<br>Selesai</div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <h6 class="fw-bold text-secondary mb-3 small text-uppercase ls-1">Menu Aplikasi</h6>
            
            <!-- MENU GRID (ANDROID STYLE) -->
            <div class="row g-2"> 
                
                <!-- MENU 1: ABSEN GURU (UPDATED KE SCAN QR) -->
                <div class="col-4 col-md-3 col-lg-2">
                    <a href="guru_scanqr.php" class="card menu-card text-decoration-none">
                        <div class="card-body text-center py-3">
                            <div class="icon-box bg-icon-absen">
                                <!-- UPDATE ICON KE QR CODE -->
                                <i class="bi bi-qr-code-scan"></i>
                            </div>
                            <div class="menu-title">Absen Guru</div>
                            <small class="menu-desc">Scan QR</small>
                        </div>
                    </a>
                </div>

                <!-- MENU 2: KOPERASI -->
                <div class="col-4 col-md-3 col-lg-2">
                    <a href="segerahadir.php" class="card menu-card text-decoration-none">
                        <div class="card-body text-center py-3">
                            <div class="icon-box bg-icon-koperasi">
                                <i class="bi bi-shop"></i>
                            </div>
                            <div class="menu-title">Koperasi</div>
                            <small class="menu-desc">Belanja</small>
                        </div>
                    </a>
                </div>
<!-- MENU BARU: REWARD SISWA -->
<div class="col-4 col-md-3 col-lg-2">
    <a href="guru_reward.php" class="card menu-card text-decoration-none">
        <div class="card-body text-center py-3">
            <div class="icon-box bg-icon-reward">
                <i class="bi bi-trophy-fill"></i>
            </div>
            <div class="menu-title">Reward Siswa</div>
            <small class="menu-desc">Poin & Penghargaan</small>
        </div>
    </a>
</div>
                <!-- MENU 3: CBT -->
                <div class="col-4 col-md-3 col-lg-2">
                    <a href="guru_reset.php" class="card menu-card text-decoration-none">
                        <div class="card-body text-center py-3">
                            <div class="icon-box bg-icon-cbt">
                                <i class="bi bi-laptop"></i>
                            </div>
                            <div class="menu-title">CBT Ujian</div>
                            <small class="menu-desc">E-Learning</small>
                        </div>
                    </a>
                </div>

                <!-- MENU 4: ABSENSI SISWA -->
                <div class="col-4 col-md-3 col-lg-2">
                    <a href="segerahadir.php" class="card menu-card text-decoration-none">
                        <div class="card-body text-center py-3">
                            <div class="icon-box bg-icon-jadwal">
                                <i class="bi bi-calendar-check"></i>
                            </div>
                            <div class="menu-title">Absen Siswa</div>
                            <small class="menu-desc">Kelas</small>
                        </div>
                    </a>
                </div>

                <!-- MENU 5: POIN PELANGGARAN -->
                <div class="col-4 col-md-3 col-lg-2">
                    <a href="pelanggaran.php" class="card menu-card text-decoration-none">
                        <div class="card-body text-center py-3">
                            <div class="icon-box bg-icon-poin">
                                <i class="bi bi-exclamation-triangle-fill"></i>
                            </div>
                            <div class="menu-title">Pelanggaran</div>
                            <small class="menu-desc">BK Poin</small>
                        </div>
                    </a>
                </div>

                <!-- MENU 6: JADWAL -->
                <div class="col-4 col-md-3 col-lg-2">
                    <a href="guru_jadwal.php" class="card menu-card text-decoration-none">
                        <div class="card-body text-center py-3">
                            <div class="icon-box bg-icon-jadwal">
                                <i class="bi bi-calendar-week"></i>
                            </div>
                            <div class="menu-title">Jadwal</div>
                            <small class="menu-desc">Mengajar</small>
                        </div>
                    </a>
                </div>

                <!-- MENU 7: BANK SOAL -->
                <div class="col-4 col-md-3 col-lg-2">
                    <a href="guru_soal.php" class="card menu-card text-decoration-none">
                        <div class="card-body text-center py-3">
                            <div class="icon-box bg-icon-soal">
                                <i class="bi bi-file-earmark-text"></i>
                            </div>
                            <div class="menu-title">Bank Soal</div>
                            <small class="menu-desc">Arsip</small>
                        </div>
                    </a>
                </div>

                 <!-- MENU 8: E-RAPOR -->
                 <div class="col-4 col-md-3 col-lg-2">
                    <a href="segerahadir.php" class="card menu-card text-decoration-none">
                        <div class="card-body text-center py-3">
                            <div class="icon-box bg-icon-rapor">
                                <i class="bi bi-journal-bookmark-fill"></i>
                            </div>
                            <div class="menu-title">E-Rapor</div>
                            <small class="menu-desc">Penilaian</small>
                        </div>
                    </a>
                </div>

            </div>

        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item active">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <a href="pelanggaran.php" class="mobile-nav-item">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Poin</span>
    </a>
    <!-- TOMBOL TENGAH: SCAN QR -->
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="guru_scanqr.php" class="mobile-nav-fab">
            <!-- UPDATE ICON KE QR CODE -->
            <i class="bi bi-qr-code-scan"></i>
        </a>
        <div class="mobile-nav-text-fab">Scan</div>
    </div>
    <a href="profile.php" class="mobile-nav-item">
        <i class="bi bi-person-fill"></i>
        <span>Profil</span>
    </a>
    <a href="login.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- SCRIPT COUNTDOWN (HANYA AKTIF JIKA MODE = COUNTDOWN) -->
<?php if ($mode_tampilan == 'countdown'): ?>
<script>
    const targetJam = "<?= $target_waktu_js ?>"; 
    
    function updateCountdown() {
        const now = new Date();
        const target = new Date();
        
        const [hours, minutes, seconds] = targetJam.split(':');
        
        target.setHours(hours, minutes, seconds, 0);
        
        const diff = target - now;
        
        if (diff <= 0) {
            document.getElementById('countdownDisplay').innerHTML = "Refresh...";
            location.reload(); 
            return;
        }
        
        const h = Math.floor(diff / (1000 * 60 * 60));
        const m = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        const s = Math.floor((diff % (1000 * 60)) / 1000);
        
        const hDisplay = h < 10 ? "0" + h : h;
        const mDisplay = m < 10 ? "0" + m : m;
        const sDisplay = s < 10 ? "0" + s : s;
        
        document.getElementById('countdownDisplay').innerText = `${hDisplay}:${mDisplay}:${sDisplay}`;
    }

    setInterval(updateCountdown, 1000);
    updateCountdown();
</script>
<?php endif; ?>

</body>
</html>