<?php
session_start();

// Konfigurasi Database (Ganti dengan detail database Anda)
$servername = "localhost"; // Ganti jika database Anda di host lain
$username = "smkw3888_cbtbaru";          // Ganti dengan username database Anda
$password = "hayangmodol2";          // Ganti dengan password database Anda
$dbname = "smkw3888_cbtbaru"; // Ganti dengan nama database Anda

// Buat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Periksa koneksi
if ($conn->connect_error) {
    die("Koneksi database gagal: " . $conn->connect_error);
}

// Inisialisasi variabel untuk logo dan nama sekolah
$school_logo = '';
$school_name = 'Login Siswa'; // Default name if not found in database

// Ambil data logo dan nama sekolah dari tabel pengaturan_sekolah
// Diasumsikan hanya ada satu baris di tabel pengaturan_sekolah untuk pengaturan global
$settings_query = "SELECT logo_sekolah, nama_sekolah FROM pengaturan_sekolah LIMIT 1";
$settings_result = $conn->query($settings_query);

if ($settings_result && $settings_result->num_rows > 0) {
    $settings_data = $settings_result->fetch_assoc();
    $school_logo = htmlspecialchars($settings_data['logo_sekolah']);
    $school_name = htmlspecialchars($settings_data['nama_sekolah']);
}

$message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $qr_data = $_POST['qr_data'] ?? '';

    if (!empty($qr_data)) {
        // Data dari QR code akan digunakan untuk mencari di kolom qr_code_content
        $scanned_qr_content = htmlspecialchars($qr_data);

        // Siapkan pernyataan SQL untuk mengambil data siswa berdasarkan qr_code_content
        $stmt = $conn->prepare("SELECT id, nama, kelas, nomor_wa, last_logged_in_device_id FROM students WHERE qr_code_content = ?");
        $stmt->bind_param("s", $scanned_qr_content); // Bind $scanned_qr_content ke placeholder
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $student_data = $result->fetch_assoc();

            // Placeholder: Generate unique device ID for this session
            $current_device_id = session_id(); // Menggunakan ID sesi sebagai pengenal perangkat sederhana untuk demo

            // Periksa apakah akun ini sudah login di perangkat lain
            if (!empty($student_data['last_logged_in_device_id']) && $student_data['last_logged_in_device_id'] !== $current_device_id) {
                $message = "Akun ini sudah digunakan di perangkat lain. Silakan coba lagi nanti.";
            } else {
                // Update last_logged_in_device_id di database
                $update_stmt = $conn->prepare("UPDATE students SET last_logged_in_device_id = ? WHERE id = ?");
                $update_stmt->bind_param("ss", $current_device_id, $student_data['id']); // Update berdasarkan ID siswa yang ditemukan
                $update_stmt->execute();
                $update_stmt->close();

                // Simpan data siswa ke sesi
                $_SESSION['student_id'] = $student_data['id'];
                $_SESSION['student_name'] = $student_data['nama'];
                $_SESSION['student_class'] = $student_data['kelas'];
                $_SESSION['student_wa'] = $student_data['nomor_wa'];
                $_SESSION['device_id'] = $current_device_id;

                // Redirect ke halaman ujian.php
                header("Location: ujian.php");
                exit();
            }
        } else {
            // Pesan jika QR code tidak ditemukan di database
            $message = "QR code tidak valid atau siswa tidak ditemukan.";
        }
        $stmt->close();
    } else {
        $message = "QR code kosong atau tidak terbaca.";
    }
}
$conn->close(); // Tutup koneksi database
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $school_name; ?> - Login Siswa</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f2f5;
        }
        .container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        #videoElement {
            width: 100%;
            max-width: 400px; /* Batasi lebar video */
            height: auto;
            border-radius: 0.75rem; /* rounded-xl */
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06); /* shadow-md */
        }
        #qrCanvas {
            display: none; /* Kanvas tersembunyi, hanya digunakan untuk memproses frame video */
        }
        /* Custom style for the school logo when inline */
        .school-logo-inline {
            max-height: 50px; /* Adjust max height for inline display on larger screens */
            width: auto; /* Maintain aspect ratio */
            margin-right: 0.75rem; /* Space between logo and text/separator */
        }
        /* Custom style for the Digipas logo */
        .digipas-logo {
            max-height: 50px; /* Changed to match school-logo-inline max-height */
            width: auto; /* Maintain aspect ratio */
            display: inline-block; /* Allows alignment with text */
            vertical-align: middle; /* Align vertically with text */
            margin-left: 0.25rem; /* Small space between text and logo */
        }
        /* Custom style for school name text to ensure it stays on one line by default */
        .school-name-text {
            font-size: 2rem; /* Adjusted from 3xl (3rem) to 2xl (2rem) for larger screens */
            line-height: 1.25; /* Similar to Tailwind's leading-tight */
            white-space: nowrap; /* Ensures text stays on one line */
        }
        
        /* Media query for small mobile screens (max-width: 640px) */
        @media (max-width: 640px) {
            .school-logo-inline {
                max-height: 35px; /* Smaller height for logo on small screens */
                margin-right: 0.5rem; /* Reduce margin to save space */
            }
            .digipas-logo {
                max-height: 35px; /* Changed to match school-logo-inline max-height for small screens */
            }
            .header-flex {
                /* Keep as flex row to maintain side-by-side */
                flex-wrap: wrap; /* Allow wrapping if content is too wide, but prioritize nowrap on school-name-text */
                justify-content: center;
            }
            .header-flex .separator {
                /* Ensure separator is always visible */
                display: inline-block; /* Or keep default if not explicitly hidden */
                font-size: 1.5rem; /* Smaller separator font size */
                margin-left: 0.5rem; /* Reduce margin */
                margin-right: 0.5rem; /* Reduce margin */
            }
            .school-name-text {
                font-size: 1.1rem; /* Further reduce font size for better fit on small screens */
                white-space: nowrap; /* Keep it on one line as much as possible */
                text-align: left; /* Adjust alignment if it wraps */
            }
        }
        /* Even smaller breakpoint for extremely small mobile screens (max-width: 400px) */
        @media (max-width: 400px) {
            .school-logo-inline {
                max-height: 30px; /* Even smaller logo for tiny screens */
                margin-right: 0.3rem; /* Further reduce margin */
            }
            .school-name-text {
                font-size: 0.95rem; /* Even smaller font for tiny screens */
                /* Consider allowing white-space: normal here if names are extremely long */
            }
            .header-flex .separator {
                font-size: 1.2rem; /* Even smaller separator font size */
                margin-left: 0.3rem; /* Further reduce margin */
                margin-right: 0.3rem; /* Further reduce margin */
            }
            .digipas-logo {
                max-height: 30px; /* Changed to match school-logo-inline max-height for tiny screens */
            }
        }
    </style>
</head>
<body>
    <div class="container bg-gradient-to-br from-blue-100 to-indigo-200 p-4 sm:p-6 lg:p-8">
        <div class="bg-white p-6 sm:p-8 rounded-xl shadow-lg w-full max-w-sm border border-gray-200">
            <!-- School Logo and Name Section (Side-by-Side on all screens) -->
            <div class="flex items-center justify-center mb-4 header-flex">
                <?php if (!empty($school_logo)): ?>
                    <img src="admin/uploads/<?php echo $school_logo; ?>" alt="<?php echo $school_name; ?> Logo" class="school-logo-inline object-contain">
                <?php endif; ?>
                <?php if (!empty($school_logo) && !empty($school_name)): // Show separator only if both exist ?>
                    <span class="text-3xl font-extrabold text-gray-800 mx-2 separator">|</span>
                <?php endif; ?>
                <h1 class="font-extrabold text-gray-800 leading-tight mb-0 school-name-text"><?php echo $school_name; ?></h1>
            </div>
            <p class="text-center text-gray-600 mb-8">Pindai QR Code Anda untuk Masuk</p>

            <?php if (!empty($message)): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-md relative mb-6" role="alert">
                    <strong class="font-bold">Error!</strong>
                    <span class="block sm:inline"><?php echo $message; ?></span>
                </div>
            <?php endif; ?>

            <div class="flex justify-center items-center mb-6">
                <video id="videoElement" class="rounded-xl shadow-md border-4 border-indigo-400 object-cover"></video>
                <canvas id="qrCanvas"></canvas>
            </div>

            <p id="qr-status" class="text-center text-gray-700 mb-6 font-medium">
                Mencoba mengakses kamera Anda... Mohon izinkan akses kamera.
            </p>

            <!-- New section for camera error instructions -->
            <div id="camera-error-message" class="hidden bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded-md relative mb-6" role="alert">
                <strong class="font-bold">Perhatian!</strong>
                <span class="block sm:inline">
                    Kamera tidak dapat diakses. Mohon pastikan Anda telah memberikan izin akses kamera untuk situs ini di pengaturan browser Anda.
                    <br><br>
                    Untuk pengalaman terbaik, disarankan menggunakan browser <strong>Google Chrome</strong>. Jika masalah berlanjut, coba:
                    <ul class="list-disc list-inside mt-2">
                        <li>Pastikan tidak ada aplikasi lain yang menggunakan kamera.</li>
                        <li>Restart browser Anda.</li>
                        <li>Periksa pengaturan privasi kamera di perangkat Anda.</li>
                    </ul>
                </span>
            </div>

            <p id="qr-result" class="text-center text-green-600 font-bold mb-6 hidden"></p>

            <form id="loginForm" method="POST" action="index.php" class="hidden">
                <input type="hidden" name="qr_data" id="qrDataInput">
                <button type="submit" class="w-full bg-indigo-600 text-white font-semibold py-3 rounded-lg hover:bg-indigo-700 focus:outline-none focus:ring-4 focus:ring-indigo-500 focus:ring-opacity-50 transition duration-300 ease-in-out shadow-md">
                    Masuk Otomatis
                </button>
            </form>

            <!-- Powered by Digipas.id Section -->
            <div class="mt-8 text-center text-gray-500 text-sm flex items-center justify-center">
                Powered by Digipas.id
                <img src="admin/digipas.png" alt="Digipas.id Logo" class="digipas-logo">
            </div>
        </div>
    </div>

    <!-- jsQR library for QR code scanning -->
    <script src="https://cdn.jsdelivr.net/npm/jsqr@1.1.0/dist/jsQR.min.js"></script>
    <script>
        const video = document.getElementById('videoElement');
        const canvas = document.getElementById('qrCanvas');
        const qrStatus = document.getElementById('qr-status');
        const qrResult = document.getElementById('qr-result');
        const qrDataInput = document.getElementById('qrDataInput');
        const loginForm = document.getElementById('loginForm');
        const cameraErrorMessage = document.getElementById('camera-error-message'); // New element
        const context = canvas.getContext('2d');

        let cameraStream;

        // Fungsi untuk memulai pemindaian QR
        async function startQrScan() {
            try {
                // Request back camera (environment) if available, otherwise default to any
                cameraStream = await navigator.mediaDevices.getUserMedia({
                    video: {
                        facingMode: { ideal: 'environment' } // Prefer back camera
                    }
                });

                video.srcObject = cameraStream;
                video.setAttribute("playsinline", true); // required to tell iOS safari we don't want fullscreen
                video.play();
                requestAnimationFrame(tick); // Start scanning loop
                qrStatus.textContent = '';
                cameraErrorMessage.classList.add('hidden'); // Hide error message if camera starts

            } catch (err) {
                console.error("Error accessing camera: ", err);
                qrStatus.classList.add('text-red-600');
                cameraErrorMessage.classList.remove('hidden'); // Show error message

                if (err.name === 'NotAllowedError' || err.name === 'PermissionDeniedError') {
                    qrStatus.textContent = 'Akses kamera ditolak. Mohon izinkan akses kamera di pengaturan browser Anda.';
                } else if (err.name === 'NotFoundError') {
                    qrStatus.textContent = 'Tidak ada kamera yang ditemukan di perangkat ini.';
                } else {
                    qrStatus.textContent = 'Gagal mengakses kamera. Pastikan Anda mengizinkan akses dan coba lagi.';
                }
            }
        }

        // Loop untuk memindai setiap frame video
        function tick() {
            if (video.readyState === video.HAVE_ENOUGH_DATA) {
                canvas.height = video.videoHeight;
                canvas.width = video.videoWidth;
                context.drawImage(video, 0, 0, canvas.width, canvas.height);

                const imageData = context.getImageData(0, 0, canvas.width, canvas.height);
                const code = jsQR(imageData.data, imageData.width, imageData.height, {
                    inversionAttempts: "dontInvert",
                });

                if (code) {
                    // QR code ditemukan!
                    console.log("QR Code Ditemukan:", code.data);
                    qrResult.textContent = `QR Terdeteksi: ${code.data}`;
                    qrResult.classList.remove('hidden');
                    qrStatus.textContent = 'Memproses login...';
                    qrStatus.classList.remove('text-red-600');

                    // Hentikan stream kamera setelah QR ditemukan
                    if (cameraStream) {
                        cameraStream.getTracks().forEach(track => track.stop());
                    }

                    // Isi input tersembunyi dan kirim form
                    qrDataInput.value = code.data;
                    loginForm.submit();
                    return; // Hentikan loop pemindaian
                }
            }
            requestAnimationFrame(tick); // Lanjutkan memindai frame berikutnya
        }

        // Mulai pemindaian saat halaman dimuat
        window.onload = startQrScan;
    </script>
</body>
</html>
