<?php
session_start();

// Unset all of the session variables
$_SESSION = array();

// Destroy the session.
session_destroy();

// Initialize message and type variables
$message = '';
$type = '';

// Check if message and type parameters are passed in the URL
if (isset($_GET['message']) && isset($_GET['type'])) {
    $message = urlencode(htmlspecialchars($_GET['message']));
    $type = urlencode(htmlspecialchars($_GET['type']));
}

// Redirect to the login page (index.php)
// Include message and type parameters if they exist
if (!empty($message) && !empty($type)) {
    header("Location: index.php?message=" . $message . "&type=" . $type);
} else {
    header("Location: index.php");
}
exit();
?>
