<?php
session_start();
include 'koneksi.php';

// 1. Cek akses login
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];
$msg = "";
$msg_type = "";

// --- PROSES UPDATE PROFIL ---
if (isset($_POST['update_profil'])) {
    $nama_lengkap = mysqli_real_escape_string($koneksi, $_POST['nama_lengkap']);
    $password_baru = $_POST['password'];
    
    // 1. Update Data Teks (Nama)
    $query_update = "UPDATE users SET nama_lengkap = '$nama_lengkap'";

    // 2. Update Password (Jika diisi)
    if (!empty($password_baru)) {
        // Sesuaikan metode hashing dengan sistem login Anda (contoh: password_hash atau md5)
        // Di sini saya gunakan plain text/langsung sesuai umum, ganti jika perlu
        $query_update .= ", password = '$password_baru'"; 
    }

    // 3. Update Foto (Jika ada upload)
    if (!empty($_FILES['foto']['name'])) {
        $foto_name = $_FILES['foto']['name'];
        $foto_tmp = $_FILES['foto']['tmp_name'];
        $foto_ext = strtolower(pathinfo($foto_name, PATHINFO_EXTENSION));
        $allowed_ext = ['jpg', 'jpeg', 'png'];

        if (in_array($foto_ext, $allowed_ext)) {
            $new_foto_name = "guru_" . $id_guru . "_" . time() . "." . $foto_ext;
            $upload_path = "uploads/" . $new_foto_name;
            
            if (move_uploaded_file($foto_tmp, $upload_path)) {
                $query_update .= ", foto = '$new_foto_name'";
            } else {
                $msg = "Gagal mengupload foto.";
                $msg_type = "danger";
            }
        } else {
            $msg = "Format foto tidak valid (hanya jpg, jpeg, png).";
            $msg_type = "danger";
        }
    }

    $query_update .= " WHERE id = '$id_guru'";

    if (empty($msg)) { // Jika tidak ada error upload
        if (mysqli_query($koneksi, $query_update)) {
            $msg = "Profil berhasil diperbarui!";
            $msg_type = "success";
            // Update nama di session jika perlu
            $_SESSION['nama_lengkap'] = $nama_lengkap; 
        } else {
            $msg = "Gagal memperbarui database: " . mysqli_error($koneksi);
            $msg_type = "danger";
        }
    }
}

// --- AMBIL DATA USER TERBARU ---
$q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
$guru = mysqli_fetch_assoc($q_guru);

// --- AMBIL DATA PENGATURAN SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png"; 

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if (mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// Setup Foto Profil
$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Guru - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        /* --- CSS GLOBAL --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- MOBILE BOTTOM NAV (ANDROID STYLE) --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        /* Profile Specific */
        .profile-img-preview {
            width: 120px; height: 120px;
            border-radius: 50%;
            object-fit: cover;
            border: 4px solid #fff;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Guru</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
                <small class="text-muted">Guru</small>
            </li>
            <li><a class="dropdown-item" href="profil.php"><i class="bi bi-person me-2"></i> Profil</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="absenguru.php" class="nav-link"><i class="bi bi-camera-fill"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="koperasi.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                <li class="nav-item"><a href="guru_reset.php" class="nav-link"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                <li class="nav-item"><a href="soal2.php" class="nav-link"><i class="bi bi-file-earmark-text-fill"></i> Bank Soal</a></li>
                <!-- Menu ini Aktif -->
                <li class="nav-item"><a href="profil.php" class="nav-link active"><i class="bi bi-person-fill"></i> Profil</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold mb-0">Pengaturan Profil</h4>
            </div>

            <?php if (!empty($msg)): ?>
                <div class="alert alert-<?= $msg_type ?> alert-dismissible fade show shadow-sm border-0" role="alert">
                    <?= $msg ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card border-0 shadow-sm rounded-4">
                        <div class="card-body p-4 p-md-5">
                            <form method="POST" enctype="multipart/form-data">
                                <div class="text-center mb-4">
                                    <div class="position-relative d-inline-block mb-3">
                                        <img src="<?= $foto_profil ?>" class="profile-img-preview" id="previewImg">
                                        <label for="uploadFoto" class="position-absolute bottom-0 end-0 bg-success text-white rounded-circle p-2 shadow-sm" style="cursor: pointer;">
                                            <i class="bi bi-camera-fill"></i>
                                        </label>
                                        <input type="file" name="foto" id="uploadFoto" class="d-none" accept="image/*" onchange="previewFile()">
                                    </div>
                                    <h5 class="fw-bold"><?= htmlspecialchars($guru['nama_lengkap']) ?></h5>
                                    <p class="text-muted small">Guru Mata Pelajaran: <?= htmlspecialchars($guru['mata_pelajaran']) ?></p>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold text-muted small">Nama Lengkap</label>
                                    <input type="text" name="nama_lengkap" class="form-control" value="<?= htmlspecialchars($guru['nama_lengkap']) ?>" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold text-muted small">Username / NIP</label>
                                    <input type="text" class="form-control bg-light" value="<?= htmlspecialchars($guru['username'] ?? '-') ?>" readonly>
                                    <small class="text-muted fst-italic">*Username tidak dapat diubah.</small>
                                </div>

                                <hr class="my-4">
                                <h6 class="fw-bold mb-3 text-primary"><i class="bi bi-lock-fill me-2"></i>Ganti Password</h6>

                                <div class="mb-4">
                                    <label class="form-label fw-bold text-muted small">Password Baru</label>
                                    <input type="password" name="password" class="form-control" placeholder="Kosongkan jika tidak ingin mengganti password">
                                </div>

                                <div class="d-grid gap-2">
                                    <button type="submit" name="update_profil" class="btn btn-success py-2 fw-bold shadow-sm">
                                        <i class="bi bi-save me-2"></i> Simpan Perubahan
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <a href="pelanggaran.php" class="mobile-nav-item">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Poin</span>
    </a>
    <!-- FAB BUTTON ABSEN -->
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="absenguru.php" class="mobile-nav-fab">
            <i class="bi bi-camera-fill"></i>
        </a>
        <div class="mobile-nav-text-fab">Absen</div>
    </div>
    <!-- Active state di Profil -->
    <a href="profil.php" class="mobile-nav-item active">
        <i class="bi bi-person-fill"></i>
        <span>Profil</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Script sederhana untuk preview foto sebelum upload
    function previewFile() {
        const preview = document.getElementById('previewImg');
        const file = document.getElementById('uploadFoto').files[0];
        const reader = new FileReader();

        reader.addEventListener("load", function () {
            preview.src = reader.result;
        }, false);

        if (file) {
            reader.readAsDataURL(file);
        }
    }
</script>

</body>
</html>