<?php
session_start();
include 'koneksi.php';

// 1. Cek akses login (Standar Menu Guru)
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit;
}

$id_guru = $_SESSION['user_id'];

// --- AMBIL DATA USER (GURU) ---
$q_guru = mysqli_query($koneksi, "SELECT * FROM users WHERE id='$id_guru'");
$guru = mysqli_fetch_assoc($q_guru);

// --- LOGIKA SETTING SEKOLAH ---
$nama_sekolah = "SMK Pasundan 3"; 
$logo_sekolah = "assets/img/logo.png"; 

$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if (mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// Setup Foto Profil
$foto_profil = 'uploads/' . ($guru['foto'] ?? '');
if (empty($guru['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Guru"; 
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Segera Hadir - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        /* --- CSS GLOBAL DASHBOARD --- */
        body { background-color: #f5f7fa; font-family: 'Poppins', sans-serif; padding-bottom: 90px; }
        
        /* Sidebar Styles */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }

        /* Mobile Header */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- COMING SOON SPECIFIC STYLES --- */
        .coming-soon-wrapper {
            position: relative;
            min-height: 75vh; /* Agar card berada di tengah vertikal area konten */
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            border-radius: 20px;
        }

        /* Animated Background Shapes (Scoped to Wrapper) */
        .bg-shape {
            position: absolute;
            border-radius: 50%;
            filter: blur(60px);
            z-index: 0;
            animation: float 10s infinite ease-in-out;
        }
        .shape-1 { top: 0%; left: 0%; width: 250px; height: 250px; background: rgba(25, 135, 84, 0.3); animation-delay: 0s; }
        .shape-2 { bottom: 0%; right: 0%; width: 300px; height: 300px; background: rgba(32, 201, 151, 0.3); animation-delay: 5s; }
        .shape-3 { top: 40%; left: 60%; width: 150px; height: 150px; background: rgba(13, 202, 240, 0.2); animation-delay: 2s; }

        @keyframes float {
            0% { transform: translateY(0px) translateX(0px); }
            50% { transform: translateY(-20px) translateX(20px); }
            100% { transform: translateY(0px) translateX(0px); }
        }

        .coming-soon-card {
            width: 100%;
            max-width: 550px;
            border: none;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
            overflow: hidden;
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            text-align: center;
            position: relative;
            z-index: 10;
        }

        .header-bar { height: 8px; background: linear-gradient(90deg, #198754, #20c997, #0dcaf0); width: 100%; }
        .card-body { padding: 40px 30px; }

        .logo-anim { width: 70px; height: 70px; object-fit: contain; margin-bottom: 20px; animation: bounceIn 1s; }
        @keyframes bounceIn { 0% { transform: scale(0.1); opacity: 0; } 60% { transform: scale(1.2); opacity: 1; } 100% { transform: scale(1); } }

        .typing-text {
            font-weight: 700; color: #198754; font-size: 1.8rem; margin-bottom: 10px;
            border-right: 3px solid #198754; display: inline-block; white-space: nowrap; overflow: hidden;
            animation: typing 3s steps(30, end), blink .75s step-end infinite;
        }
        @keyframes typing { from { width: 0 } to { width: 100% } }
        @keyframes blink { from, to { border-color: transparent } 50% { border-color: #198754; } }

        /* Countdown */
        .countdown-container { display: flex; justify-content: center; gap: 10px; margin: 25px 0; }
        .countdown-item { background: #f8f9fa; border-radius: 10px; padding: 10px; min-width: 70px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); border-bottom: 3px solid #198754; }
        .countdown-number { font-size: 1.5rem; font-weight: bold; color: #333; display: block; line-height: 1; }
        .countdown-label { font-size: 0.7rem; text-transform: uppercase; color: #6c757d; letter-spacing: 1px; }

        /* Form Notify */
        .notify-input { border-radius: 50px 0 0 50px; padding-left: 20px; border: 1px solid #ced4da; }
        .notify-btn { border-radius: 0 50px 50px 0; background: #198754; color: white; font-weight: 600; padding: 0 20px; }
        .notify-btn:hover { background: #146c43; color: white; }

        /* --- MOBILE BOTTOM NAV --- */
        .mobile-bottom-nav {
            display: none; position: fixed; bottom: 0; left: 0; right: 0;
            background: white; box-shadow: 0 -5px 20px rgba(0,0,0,0.05); z-index: 1000;
            height: 70px; justify-content: space-between; align-items: center;
            padding: 0 15px; border-top-left-radius: 20px; border-top-right-radius: 20px;
        }
        .mobile-nav-item { display: flex; flex-direction: column; align-items: center; text-decoration: none; color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s; }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab { position: absolute; bottom: 5px; font-size: 11px; color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none; }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Panel Guru</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li class="px-3 py-2 text-center bg-light mb-2">
                <strong class="d-block text-truncate"><?= htmlspecialchars($guru['nama_lengkap']) ?></strong>
                <small class="text-muted">Guru</small>
            </li>
            <li><a class="dropdown-item" href="profil.php"><i class="bi bi-person me-2"></i> Profil</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Guru</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="home.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="absenguru.php" class="nav-link"><i class="bi bi-camera-fill"></i> Absen Guru</a></li>
                <li class="nav-item"><a href="koperasi.php" class="nav-link"><i class="bi bi-shop"></i> Koperasi</a></li>
                <!-- Contoh Menu Aktif (Misal ini menu E-Rapor atau fitur baru) -->
                <li class="nav-item"><a href="#" class="nav-link active"><i class="bi bi-stars"></i> Fitur Baru</a></li>
                <li class="nav-item"><a href="guru_reset.php" class="nav-link"><i class="bi bi-laptop"></i> CBT Ujian</a></li>
                <li class="nav-item"><a href="absen.php" class="nav-link"><i class="bi bi-calendar-check"></i> Absensi Siswa</a></li>
                <li class="nav-item"><a href="pelanggaran.php" class="nav-link"><i class="bi bi-exclamation-triangle-fill"></i> Pelanggaran</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT (COMING SOON AREA) -->
        <div class="col-md-9 col-lg-10 main-content">
            
            <!-- Wrapper untuk memusatkan card Coming Soon di area konten -->
            <div class="coming-soon-wrapper">
                
                <!-- Background Elements (Scoped inside wrapper) -->
                <div class="bg-shape shape-1"></div>
                <div class="bg-shape shape-2"></div>
                <div class="bg-shape shape-3"></div>

                <div class="coming-soon-card">
                    <div class="header-bar"></div>
                    <div class="card-body">
                        <!-- Logo & Title -->
                        <img src="<?= $logo_sekolah ?>" alt="Logo" class="logo-anim" onerror="this.src='https://via.placeholder.com/100?text=Logo'">
                        
                        <div class="d-block mb-3">
                            <h2 class="typing-text">Segera Hadir!</h2>
                        </div>
                        
                        <p class="text-muted mb-4 small">
                            Fitur <strong>Menu Guru Baru</strong> sedang dalam pengembangan akhir. Kami menjanjikan pengalaman yang lebih baik.
                        </p>

                        <!-- Countdown Timer -->
                        <div class="countdown-container">
                            <div class="countdown-item">
                                <span class="countdown-number" id="days">00</span>
                                <span class="countdown-label">Hari</span>
                            </div>
                            <div class="countdown-item">
                                <span class="countdown-number" id="hours">00</span>
                                <span class="countdown-label">Jam</span>
                            </div>
                            <div class="countdown-item">
                                <span class="countdown-number" id="minutes">00</span>
                                <span class="countdown-label">Menit</span>
                            </div>
                            <div class="countdown-item">
                                <span class="countdown-number" id="seconds">00</span>
                                <span class="countdown-label">Detik</span>
                            </div>
                        </div>

                        <!-- Notify Form -->
                        <form action="" class="mt-4 mb-2">
                            <div class="input-group">
                                <input type="email" class="form-control notify-input py-2 bg-light" placeholder="Email Anda..." required>
                                <button class="btn notify-btn" type="button" onclick="alert('Kami akan memberi tahu Anda!')">
                                    <i class="bi bi-bell-fill"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="home.php" class="mobile-nav-item">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <a href="pelanggaran.php" class="mobile-nav-item">
        <i class="bi bi-exclamation-triangle"></i>
        <span>Poin</span>
    </a>
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="absenguru.php" class="mobile-nav-fab">
            <i class="bi bi-camera-fill"></i>
        </a>
        <div class="mobile-nav-text-fab">Absen</div>
    </div>
    <a href="profil.php" class="mobile-nav-item">
        <i class="bi bi-person-fill"></i>
        <span>Profil</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // --- COUNTDOWN SCRIPT ---
    const targetDate = new Date();
    targetDate.setDate(targetDate.getDate() + 14); // 14 hari lagi

    function updateCountdown() {
        const now = new Date().getTime();
        const distance = targetDate - now;

        if (distance < 0) {
            document.getElementById("days").innerText = "00";
            return;
        }

        const days = Math.floor(distance / (1000 * 60 * 60 * 24));
        const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((distance % (1000 * 60)) / 1000);

        document.getElementById("days").innerText = days < 10 ? "0" + days : days;
        document.getElementById("hours").innerText = hours < 10 ? "0" + hours : hours;
        document.getElementById("minutes").innerText = minutes < 10 ? "0" + minutes : minutes;
        document.getElementById("seconds").innerText = seconds < 10 ? "0" + seconds : seconds;
    }

    setInterval(updateCountdown, 1000);
    updateCountdown();
</script>
</body>
</html>