<?php
session_start();
include 'koneksi.php';

// Cek Login Siswa
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'siswa') {
    header("Location: login_siswa.php");
    exit;
}
$id_siswa = $_SESSION['user_id'];

// --- PROSES UPDATE DATA ---
$pesan = "";
$tipe_pesan = "";

if (isset($_POST['simpan_profil'])) {
    $nomor_wa = mysqli_real_escape_string($koneksi, $_POST['nomor_wa']);
    $password_baru = mysqli_real_escape_string($koneksi, $_POST['password']);
    
    // 1. Update Password & No WA
    $query_update = "UPDATE students SET nomor_wa = '$nomor_wa'";
    if (!empty($password_baru)) {
        $query_update .= ", password = '$password_baru'";
    }
    
    // 2. Update Foto jika ada yang diupload
    if (!empty($_FILES['foto']['name'])) {
        $nama_file = $_FILES['foto']['name'];
        $tmp_file = $_FILES['foto']['tmp_name'];
        $ext = pathinfo($nama_file, PATHINFO_EXTENSION);
        $nama_baru = "siswa_" . $id_siswa . "_" . time() . "." . $ext;
        $path = "uploads/siswa/" . $nama_baru;

        // Pastikan folder ada
        if (!file_exists("uploads/siswa")) {
            mkdir("uploads/siswa", 0777, true);
        }

        if (move_uploaded_file($tmp_file, $path)) {
            $query_update .= ", foto = '$nama_baru'";
        }
    }

    $query_update .= " WHERE id = '$id_siswa'";

    if (mysqli_query($koneksi, $query_update)) {
        $pesan = "Profil berhasil diperbarui!";
        $tipe_pesan = "success";
    } else {
        $pesan = "Gagal memperbarui profil: " . mysqli_error($koneksi);
        $tipe_pesan = "danger";
    }
}

// Ambil Data Siswa Terbaru
$q_siswa = mysqli_query($koneksi, "SELECT * FROM students WHERE id='$id_siswa'");
$siswa = mysqli_fetch_assoc($q_siswa);

// Ambil Pengaturan Sekolah
$nama_sekolah = "SMK Pasundan 3";
$logo_sekolah = "assets/img/logo.png";
$check_table = mysqli_query($koneksi, "SHOW TABLES LIKE 'pengaturan_sekolah'");
if (mysqli_num_rows($check_table) > 0) {
    $q_sekolah = mysqli_query($koneksi, "SELECT * FROM pengaturan_sekolah LIMIT 1");
    if ($d_sekolah = mysqli_fetch_assoc($q_sekolah)) {
        $nama_sekolah = $d_sekolah['nama_sekolah'];
        if (!empty($d_sekolah['logo_sekolah'])) {
            $logo_sekolah = 'admin/uploads/' . $d_sekolah['logo_sekolah'];
        }
    }
}

// Setup Foto Profil
$foto_profil = 'uploads/siswa/' . ($siswa['foto'] ?? '');
if (empty($siswa['foto']) || !file_exists($foto_profil)) {
    $foto_profil = "https://via.placeholder.com/100?text=Siswa"; 
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Edit Profil - <?= $nama_sekolah ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        /* --- CSS GLOBAL --- */
        body { background-color: #f5f7fa; font-family: 'Segoe UI', sans-serif; padding-bottom: 90px; }
        
        /* --- SIDEBAR --- */
        .sidebar { min-height: 100vh; background: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); z-index: 100; }
        .sidebar .nav-link { color: #6c757d; font-weight: 500; padding: 12px 20px; border-radius: 8px; margin-bottom: 5px; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #e8f5e9; color: #198754; }
        .sidebar .nav-link i { margin-right: 10px; font-size: 1.1rem; }
        .school-logo { width: 60px; height: 60px; object-fit: contain; margin-bottom: 10px; }
        .main-content { padding: 30px; }
        
        /* --- MOBILE HEADER --- */
        .mobile-header { display: none; background: white; box-shadow: 0 2px 5px rgba(0,0,0,0.05); z-index: 999; }
        .mobile-avatar { width: 35px; height: 35px; object-fit: cover; border-radius: 50%; border: 2px solid #e8f5e9; }

        /* --- MOBILE BOTTOM NAV --- */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0; left: 0; right: 0;
            background: white;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
            z-index: 1000;
            height: 70px;
            justify-content: space-between;
            align-items: center;
            padding: 0 15px;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
        }
        .mobile-nav-item {
            display: flex; flex-direction: column; align-items: center; text-decoration: none;
            color: #adb5bd; font-size: 11px; flex: 1; transition: 0.3s;
        }
        .mobile-nav-item i { font-size: 22px; margin-bottom: 4px; }
        .mobile-nav-item.active { color: #198754; font-weight: 600; }
        
        .mobile-nav-fab {
            position: relative; top: -25px; width: 60px; height: 60px;
            background: linear-gradient(135deg, #198754, #20c997);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 15px rgba(25, 135, 84, 0.4);
            border: 4px solid #f5f7fa; color: white; text-decoration: none; transition: transform 0.2s;
            cursor: pointer;
        }
        .mobile-nav-fab i { font-size: 28px; }
        .mobile-nav-text-fab {
            position: absolute; bottom: 5px; font-size: 11px;
            color: #198754; font-weight: bold; width: 100%; text-align: center; pointer-events: none;
        }

        /* --- PROFILE SPECIFIC --- */
        .profile-img-lg {
            width: 120px;
            height: 120px;
            object-fit: cover;
            border-radius: 50%;
            border: 4px solid white;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .form-control:focus {
            border-color: #198754;
            box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);
        }

        @media (max-width: 768px) {
            .sidebar { display: none; }
            .mobile-bottom-nav { display: flex; }
            .mobile-header { display: flex; }
            body { padding-top: 70px; }
            .main-content { padding-top: 15px; padding-left: 15px; padding-right: 15px; }
        }
    </style>
</head>
<body>

<!-- MOBILE HEADER -->
<div class="mobile-header fixed-top justify-content-between align-items-center px-3 py-2">
    <div class="d-flex align-items-center">
        <img src="<?= $logo_sekolah ?>" alt="Logo" style="height: 40px; width: 40px; object-fit: contain;" class="me-2" onerror="this.src='https://via.placeholder.com/40?text=Logo'">
        <div class="lh-1">
            <h6 class="mb-0 fw-bold text-success" style="font-size: 14px;"><?= $nama_sekolah ?></h6>
            <small class="text-muted" style="font-size: 11px;">Edit Profil</small>
        </div>
    </div>
    <div class="dropdown">
        <a href="#" class="d-flex align-items-center text-decoration-none" id="dropdownUserMobile" data-bs-toggle="dropdown">
            <img src="<?= $foto_profil ?>" alt="User" class="mobile-avatar">
        </a>
        <ul class="dropdown-menu dropdown-menu-end shadow border-0">
            <li><a class="dropdown-item" href="siswa.php"><i class="bi bi-grid me-2"></i> Dashboard</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
        </ul>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        
        <!-- SIDEBAR (DESKTOP) -->
        <div class="col-md-3 col-lg-2 sidebar d-none d-md-block pt-4 px-3">
            <div class="text-center mb-5">
                <img src="<?= $logo_sekolah ?>" alt="Logo" class="school-logo" onerror="this.src='https://via.placeholder.com/60?text=Logo'">
                <h6 class="fw-bold text-success mb-0 text-uppercase"><?= $nama_sekolah ?></h6>
                <small class="text-muted">Panel Siswa</small>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item"><a href="siswa.php" class="nav-link"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li class="nav-item"><a href="siswa.php" class="nav-link"><i class="bi bi-qr-code-scan"></i> Scan Absen</a></li>
                <li class="nav-item mt-4"><a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-left"></i> Logout</a></li>
            </ul>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-9 col-lg-10 main-content">
            
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h5 class="fw-bold text-dark mb-0">Edit Profil</h5>
                    <small class="text-muted">Perbarui data diri Anda</small>
                </div>
                <a href="siswa.php" class="btn btn-outline-secondary btn-sm"><i class="bi bi-arrow-left me-1"></i> Kembali</a>
            </div>

            <?php if ($pesan != ""): ?>
                <div class="alert alert-<?= $tipe_pesan ?> alert-dismissible fade show shadow-sm border-0 mb-4" role="alert">
                    <i class="bi bi-info-circle-fill me-2"></i> <?= $pesan ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <form action="" method="POST" enctype="multipart/form-data">
                        <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                            <!-- Header Profil Background -->
                            <div class="bg-success bg-gradient p-4 text-center" style="height: 150px;"></div>
                            
                            <div class="card-body px-4 pb-4 position-relative">
                                <!-- Foto Profil -->
                                <div class="text-center position-relative" style="margin-top: -75px;">
                                    <img src="<?= $foto_profil ?>" id="preview-foto" class="profile-img-lg bg-white">
                                    <div class="mt-3">
                                        <label for="input-foto" class="btn btn-sm btn-light border shadow-sm rounded-pill">
                                            <i class="bi bi-camera me-1"></i> Ganti Foto
                                        </label>
                                        <input type="file" name="foto" id="input-foto" class="d-none" accept="image/*" onchange="previewImage(this)">
                                    </div>
                                    <h5 class="fw-bold mt-2 mb-0"><?= htmlspecialchars($siswa['nama']) ?></h5>
                                    <small class="text-muted"><?= htmlspecialchars($siswa['kelas']) ?> - <?= htmlspecialchars($siswa['ruangan']) ?></small>
                                </div>

                                <hr class="my-4">

                                <!-- Form Input -->
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-secondary">Nomor WhatsApp</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-white"><i class="bi bi-whatsapp text-success"></i></span>
                                            <input type="text" name="nomor_wa" class="form-control" value="<?= htmlspecialchars($siswa['nomor_wa'] ?? '') ?>" placeholder="08xxxxxxxxxx">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold small text-secondary">Password Baru</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-white"><i class="bi bi-lock"></i></span>
                                            <input type="password" name="password" class="form-control" placeholder="Biarkan kosong jika tidak diganti">
                                        </div>
                                        <div class="form-text small"><i class="bi bi-info-circle"></i> Isi hanya jika ingin mengubah password.</div>
                                    </div>
                                    
                                    <div class="col-12 mt-4">
                                        <button type="submit" name="simpan_profil" class="btn btn-success w-100 py-2 fw-bold rounded-3 shadow-sm">
                                            <i class="bi bi-save me-2"></i> SIMPAN PERUBAHAN
                                        </button>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- ANDROID STYLE BOTTOM NAV -->
<nav class="mobile-bottom-nav">
    <a href="siswa.php" class="mobile-nav-item">
        <i class="bi bi-house-door-fill"></i>
        <span>Home</span>
    </a>
    <a href="siswa_profile.php" class="mobile-nav-item active">
        <i class="bi bi-person-badge"></i>
        <span>Profil</span>
    </a>
    
    <div style="position: relative; width: 20%; display: flex; justify-content: center;">
        <a href="siswa.php" class="mobile-nav-fab">
            <i class="bi bi-qr-code-scan text-white"></i>
        </a>
        <div class="mobile-nav-text-fab">Scan</div>
    </div>

    <a href="#" class="mobile-nav-item">
        <i class="bi bi-file-text"></i>
        <span>Tugas</span>
    </a>
    <a href="logout.php" class="mobile-nav-item text-danger">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Script untuk preview foto sebelum upload
    function previewImage(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                document.getElementById('preview-foto').src = e.target.result;
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
</body>
</html>