<?php
session_start();

// --- DEBUGGING START ---
// Hapus atau set ke 0 saat production
error_reporting(E_ALL);
ini_set('display_errors', 1);
// --- DEBUGGING END ---

require_once 'config.php'; 

// Periksa sesi
if (!isset($_SESSION['student_id'])) {
    header("Location: index.php"); 
    exit();
}

// Data Siswa
$student_id = htmlspecialchars($_SESSION['student_id']);
$student_name = htmlspecialchars($_SESSION['student_name']);
$student_class = htmlspecialchars($_SESSION['student_class']);
$student_wa = htmlspecialchars($_SESSION['student_wa']);
$current_device_id = session_id();

// Fallback koneksi
if (!$conn) {
    die("Kesalahan Fatal: Koneksi database tidak tersedia.");
}

// --- Logika Keamanan Sesi (Single Device Login) ---
$stmt = $conn->prepare("SELECT last_logged_in_device_id FROM students WHERE id = ?");
if ($stmt) {
    $stmt->bind_param("s", $_SESSION['student_id']);
    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $student_data_db = $result->fetch_assoc();
        $stmt->close();

        if (empty($student_data_db['last_logged_in_device_id']) || $student_data_db['last_logged_in_device_id'] !== $current_device_id) {
            session_unset();
            session_destroy();
            header("Location: index.php?message=" . urlencode("Sesi telah berakhir atau Anda login di perangkat lain.") . "&type=error");
            exit();
        }
    } else {
        // Error handling db
        session_unset(); session_destroy();
        header("Location: index.php?message=" . urlencode("Gangguan teknis.") . "&type=error");
        exit();
    }
} else {
    // Error handling prepare
    session_unset(); session_destroy();
    header("Location: index.php?message=" . urlencode("Kesalahan sistem.") . "&type=error");
    exit();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Konfirmasi Peserta Ujian - CBT</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <!-- Icons (Lucide) -->
    <script src="https://unpkg.com/lucide@latest"></script>

    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: linear-gradient(135deg, #4f46e5 0%, #06b6d4 100%);
            background-attachment: fixed;
            overflow-x: hidden;
        }

        /* Glassmorphism Effect */
        .glass-card {
            background: rgba(255, 255, 255, 0.85);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
        }

        /* Animations */
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes pulse-ring {
            0% { transform: scale(0.95); box-shadow: 0 0 0 0 rgba(79, 70, 229, 0.7); }
            70% { transform: scale(1); box-shadow: 0 0 0 10px rgba(79, 70, 229, 0); }
            100% { transform: scale(0.95); box-shadow: 0 0 0 0 rgba(79, 70, 229, 0); }
        }
        .status-dot {
            animation: pulse-ring 2s cubic-bezier(0.215, 0.61, 0.355, 1) infinite;
        }

        /* Checkbox Custom */
        .custom-checkbox:checked + div {
            background-color: #4f46e5;
            border-color: #4f46e5;
        }
        .custom-checkbox:checked + div svg {
            display: block;
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4 selection:bg-indigo-500 selection:text-white">

    <!-- Background Decorative Elements -->
    <div class="fixed top-0 left-0 w-full h-full overflow-hidden -z-10 pointer-events-none">
        <div class="absolute top-[-10%] left-[-10%] w-96 h-96 bg-purple-500 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-float"></div>
        <div class="absolute bottom-[-10%] right-[-10%] w-96 h-96 bg-cyan-500 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-float" style="animation-delay: 2s"></div>
    </div>

    <!-- Main Card -->
    <div class="glass-card w-full max-w-2xl rounded-3xl p-6 sm:p-10 relative overflow-hidden transition-all duration-300 hover:shadow-2xl transform">
        
        <!-- Header: Time & Status -->
        <div class="flex justify-between items-center mb-8 border-b border-gray-200 pb-4">
            <div class="flex items-center gap-2">
                <div class="w-3 h-3 bg-green-500 rounded-full status-dot"></div>
                <span class="text-sm font-semibold text-gray-600">Sistem Online</span>
            </div>
            <div class="text-right">
                <div id="clock" class="text-xl font-bold text-indigo-700 font-mono tracking-widest">00:00:00</div>
                <div id="greeting" class="text-xs text-gray-500 font-medium uppercase tracking-wide">Selamat Datang</div>
            </div>
        </div>

        <!-- Profile Section -->
        <div class="flex flex-col sm:flex-row items-center gap-6 mb-8">
            <!-- Avatar generated from name -->
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-indigo-500 to-cyan-500 rounded-full blur opacity-25 group-hover:opacity-75 transition duration-1000 group-hover:duration-200"></div>
                <img src="https://ui-avatars.com/api/?name=<?php echo urlencode($student_name); ?>&background=4f46e5&color=fff&size=128&bold=true" 
                     alt="Avatar" 
                     class="relative w-24 h-24 rounded-full border-4 border-white shadow-md object-cover">
            </div>
            
            <div class="text-center sm:text-left flex-1">
                <h2 class="text-2xl font-bold text-gray-800"><?php echo $student_name; ?></h2>
                <div class="flex flex-wrap justify-center sm:justify-start gap-2 mt-2">
                    <span class="px-3 py-1 bg-indigo-50 text-indigo-700 rounded-full text-sm font-semibold border border-indigo-100 flex items-center gap-1">
                        <i data-lucide="users" class="w-4 h-4"></i> <?php echo $student_class; ?>
                    </span>
                    <span class="px-3 py-1 bg-gray-50 text-gray-600 rounded-full text-sm font-semibold border border-gray-200 flex items-center gap-1">
                        <i data-lucide="monitor" class="w-4 h-4"></i> ID: <?php echo substr(session_id(), 0, 8); ?>...
                    </span>
                </div>
            </div>
        </div>

        <!-- Rules Accordion -->
        <div class="mb-8">
            <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded-r-lg">
                <div class="flex justify-between items-center cursor-pointer" onclick="toggleRules()">
                    <h3 class="font-bold text-yellow-800 flex items-center gap-2">
                        <i data-lucide="alert-triangle" class="w-5 h-5"></i> Tata Tertib Ujian
                    </h3>
                    <i data-lucide="chevron-down" id="rules-icon" class="w-5 h-5 text-yellow-700 transition-transform duration-300"></i>
                </div>
                <div id="rules-content" class="mt-2 text-sm text-yellow-800 hidden transition-all duration-300">
                    <ul class="list-disc list-inside space-y-1 ml-1 opacity-90">
                        <li>Dilarang membuka tab lain atau browser lain.</li>
                        <li>Dilarang menggunakan alat bantu hitung / komunikasi.</li>
                        <li>Waktu ujian berjalan otomatis saat tombol mulai ditekan.</li>
                        <li>Pastikan koneksi internet stabil.</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Action Area -->
        <div class="space-y-4">
            <!-- Checkbox Agreement -->
            <label class="flex items-center gap-3 p-3 rounded-lg hover:bg-white/50 cursor-pointer transition-colors border border-transparent hover:border-gray-200">
                <div class="relative flex items-center">
                    <input type="checkbox" id="agreement" class="peer custom-checkbox sr-only" onchange="toggleStartButton()">
                    <div class="w-6 h-6 border-2 border-gray-300 rounded bg-white peer-checked:border-indigo-600 peer-checked:bg-indigo-600 transition-all flex items-center justify-center">
                        <svg class="w-4 h-4 text-white hidden pointer-events-none" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
                    </div>
                </div>
                <span class="text-gray-700 text-sm select-none">Saya menyatakan data di atas benar dan siap mematuhi tata tertib.</span>
            </label>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-6">
                <!-- Logout Button -->
                <a href="logout.php" class="group relative flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-xl text-red-700 bg-red-100 hover:bg-red-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 transition-all">
                    <span class="flex items-center gap-2">
                        <i data-lucide="log-out" class="w-4 h-4"></i> Keluar
                    </span>
                </a>

                <!-- Start Button (Initially Disabled) -->
                <button id="start-btn" onclick="startExam()" disabled class="group relative flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-xl text-white bg-gray-400 cursor-not-allowed shadow-sm transition-all duration-300">
                    <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                        <i data-lucide="play-circle" class="w-5 h-5 text-white/70 group-hover:text-white transition-colors"></i>
                    </span>
                    Mulai Kerjakan
                </button>
            </div>
        </div>
        
        <p class="text-center text-xs text-gray-400 mt-6">
            IP Address: <?php echo $_SERVER['REMOTE_ADDR']; ?> &bull; Server Time
        </p>

    </div>

    <!-- JavaScript Interactions -->
    <script>
        // Inisialisasi Icons
        lucide.createIcons();

        // 1. Real-time Clock & Greeting
        function updateClock() {
            const now = new Date();
            const timeString = now.toLocaleTimeString('id-ID', { hour12: false });
            document.getElementById('clock').innerText = timeString;

            const hour = now.getHours();
            let greet = "Selamat Pagi";
            if (hour >= 11 && hour < 15) greet = "Selamat Siang";
            else if (hour >= 15 && hour < 18) greet = "Selamat Sore";
            else if (hour >= 18) greet = "Selamat Malam";
            
            document.getElementById('greeting').innerText = greet + ", <?php echo explode(' ', trim($student_name))[0]; ?>";
        }
        setInterval(updateClock, 1000);
        updateClock();

        // 2. Toggle Rules Accordion
        function toggleRules() {
            const content = document.getElementById('rules-content');
            const icon = document.getElementById('rules-icon');
            content.classList.toggle('hidden');
            if (content.classList.contains('hidden')) {
                icon.style.transform = 'rotate(0deg)';
            } else {
                icon.style.transform = 'rotate(180deg)';
            }
        }

        // 3. Enable Start Button Logic
        function toggleStartButton() {
            const checkbox = document.getElementById('agreement');
            const btn = document.getElementById('start-btn');
            
            if (checkbox.checked) {
                btn.disabled = false;
                btn.classList.remove('bg-gray-400', 'cursor-not-allowed');
                btn.classList.add('bg-indigo-600', 'hover:bg-indigo-700', 'hover:-translate-y-1', 'shadow-lg', 'shadow-indigo-500/30');
            } else {
                btn.disabled = true;
                btn.classList.add('bg-gray-400', 'cursor-not-allowed');
                btn.classList.remove('bg-indigo-600', 'hover:bg-indigo-700', 'hover:-translate-y-1', 'shadow-lg', 'shadow-indigo-500/30');
            }
        }

        // 4. Start Exam Function (Fullscreen & Redirect)
        function startExam() {
            const btn = document.getElementById('start-btn');
            btn.innerHTML = '<svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Memuat Soal...';
            
            // Request Fullscreen (Opsional, tergantung kebijakan)
            const elem = document.documentElement;
            if (elem.requestFullscreen) {
                elem.requestFullscreen().catch(err => {
                    console.log("Fullscreen blocked or not supported");
                });
            }

            // Redirect dengan sedikit delay agar animasi terlihat
            setTimeout(() => {
                window.location.href = 'cbt.php';
            }, 800);
        }
    </script>
</body>
</html>